/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.assertions;

import com.eviware.soapui.config.LoadTestAssertionConfig;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.AbstractLoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStatistics;
import com.eviware.soapui.impl.wsdl.support.Configurable;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import org.apache.xmlbeans.XmlObject;

public class TestStepAverageAssertion
extends AbstractLoadTestAssertion
implements Configurable {
    private static final String NAME_FIELD = "Name";
    private static final String NAME_ELEMENT = "name";
    private static final String SAMPLE_INTERVAL_ELEMENT = "sample-interval";
    private static final String SAMPLE_INTERVAL_FIELD = "Sample Interval";
    private static final String MAX_AVERAGE_ELEMENT = "max-average";
    private static final String MAX_ERRORS_ELEMENT = "max-errors";
    private static final String MAX_ERRORS_FIELD = "Max Errors";
    private static final String MIN_REQUESTS_ELEMENT = "min-requests";
    private static final String MAX_AVERAGE_FIELD = "Max Average";
    private static final String MINIMUM_REQUESTS_FIELD = "Minimum Requests";
    private int minRequests;
    private int maxAverage;
    private int maxErrors;
    private int sampleInterval;
    private XFormDialog dialog;
    public static final String STEP_AVERAGE_TYPE = "Step Average";

    public TestStepAverageAssertion(LoadTestAssertionConfig assertionConfig, WsdlLoadTest loadTest) {
        super(assertionConfig, loadTest);
        this.init(assertionConfig);
        this.initIcon("/average_loadtest_assertion.gif");
    }

    private void init(LoadTestAssertionConfig assertionConfig) {
        XmlObject configuration = assertionConfig.getConfiguration();
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(configuration);
        this.setName(reader.readString(NAME_ELEMENT, STEP_AVERAGE_TYPE));
        this.minRequests = reader.readInt(MIN_REQUESTS_ELEMENT, 100);
        this.maxAverage = reader.readInt(MAX_AVERAGE_ELEMENT, 1000);
        this.setTargetStep(reader.readString("test-step", "- Any -"));
        this.maxErrors = reader.readInt(MAX_ERRORS_ELEMENT, -1);
        this.sampleInterval = reader.readInt(SAMPLE_INTERVAL_ELEMENT, 20);
    }

    @Override
    public String assertResult(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestStepResult result, TestCaseRunner testRunner, TestCaseRunContext runContext) {
        WsdlLoadTest loadTest = (WsdlLoadTest)loadTestRunner.getLoadTest();
        LoadTestStatistics statisticsModel = loadTest.getStatisticsModel();
        TestStep step = result.getTestStep();
        if (this.targetStepMatches(step)) {
            int index = step.getTestCase().getIndexOfTestStep(step);
            long average = statisticsModel.getStatistic(index, LoadTestStatistics.Statistic.AVERAGE);
            long count = statisticsModel.getStatistic(index, LoadTestStatistics.Statistic.AVERAGE);
            if (count > (long)this.minRequests && count % (long)this.sampleInterval == 0L && average >= (long)this.maxAverage) {
                return this.returnErrorOrFail("Average [" + average + "] exceeds limit [" + this.maxAverage + "]", this.maxErrors, loadTestRunner, context);
            }
        } else if ("- Total -".equals(this.getTargetStep())) {
            long average = statisticsModel.getStatistic(-1, LoadTestStatistics.Statistic.AVERAGE);
            long count = statisticsModel.getStatistic(-1, LoadTestStatistics.Statistic.COUNT);
            if (count > (long)this.minRequests && count % (long)this.sampleInterval == 0L && average >= (long)this.maxAverage) {
                return this.returnErrorOrFail("Average [" + average + "] exceeds limit [" + this.maxAverage + "]", this.maxErrors, loadTestRunner, context);
            }
        }
        return null;
    }

    @Override
    public String assertResults(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext) {
        return null;
    }

    @Override
    public String getDescription() {
        return "testStep: " + this.getTargetStep() + ", minRequests: " + this.minRequests + ", maxAverage: " + this.maxAverage + ", maxErrors: " + this.maxErrors + ", sampleInterval: " + this.sampleInterval;
    }

    @Override
    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(NAME_FIELD, this.getName());
        values.put(MINIMUM_REQUESTS_FIELD, String.valueOf(this.minRequests));
        values.put(MAX_AVERAGE_FIELD, String.valueOf(this.maxAverage));
        values.put("TestStep", this.getTargetStep());
        values.put(MAX_ERRORS_FIELD, String.valueOf(this.maxErrors));
        values.put(SAMPLE_INTERVAL_FIELD, String.valueOf(this.sampleInterval));
        this.dialog.setOptions("TestStep", this.getTargetStepOptions(true));
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            try {
                this.minRequests = Integer.parseInt((String)values.get(MINIMUM_REQUESTS_FIELD));
                this.maxAverage = Integer.parseInt((String)values.get(MAX_AVERAGE_FIELD));
                this.maxErrors = Integer.parseInt((String)values.get(MAX_ERRORS_FIELD));
                this.sampleInterval = Integer.parseInt((String)values.get(SAMPLE_INTERVAL_FIELD));
                this.setName((String)values.get(NAME_FIELD));
                this.setTargetStep((String)values.get("TestStep"));
            }
            catch (Exception e) {
                UISupport.showErrorMessage(e.getMessage());
            }
            this.updateConfiguration();
            return true;
        }
        return false;
    }

    @Override
    protected void updateConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(NAME_ELEMENT, this.getName());
        builder.add(MIN_REQUESTS_ELEMENT, this.minRequests);
        builder.add(MAX_AVERAGE_ELEMENT, this.maxAverage);
        builder.add("test-step", this.getTargetStep());
        builder.add(MAX_ERRORS_ELEMENT, this.maxErrors);
        builder.add(SAMPLE_INTERVAL_ELEMENT, this.sampleInterval);
        this.setConfiguration(builder.finish());
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Step Average Assertion");
        XForm form = builder.createForm("Basic");
        form.addTextField(NAME_FIELD, "Name of this assertion", XForm.FieldType.TEXT);
        form.addTextField(MINIMUM_REQUESTS_FIELD, "Minimum number of steps before asserting", XForm.FieldType.TEXT);
        form.addTextField(MAX_AVERAGE_FIELD, "Maximum allowed average step time", XForm.FieldType.TEXT);
        form.addTextField(MAX_ERRORS_FIELD, "Maximum number of allowed errors before failing loadtest (-1 = unlimited)", XForm.FieldType.TEXT);
        form.addTextField(SAMPLE_INTERVAL_FIELD, "Step count interval between sampling", XForm.FieldType.TEXT);
        form.addComboBox("TestStep", new String[0], "TestStep to assert");
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/Load-Testing/step-average-assertion.html"), "Specify options for this Step Average Assertion", UISupport.OPTIONS_ICON);
    }
}

