/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testcase;

import com.eviware.soapui.config.WsrmVersionTypeConfig;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;

public class TestCaseOptionsAction
extends AbstractSoapUIAction<WsdlTestCase> {
    private static final String KEEP_SESSION = "Session";
    private static final String FAIL_ON_ERROR = "Abort on Error";
    private static final String FAIL_TESTCASE_ON_ERROR = "Fail TestCase on error";
    private static final String DISCARD_OK_RESULTS = "Discard OK Results";
    private static final String SOCKET_TIMEOUT = "Socket timeout";
    private static final String SEARCH_PROPERTIES = "Search Properties";
    public static final String SOAPUI_ACTION_ID = "TestCaseOptionsAction";
    private static final String TESTCASE_TIMEOUT = "TestCase timeout";
    private static final String MAXRESULTS = "Max Results";
    private static final String WS_RM_ENABLED = "WS-RM Enabled";
    private static final String WS_RM_VERSION = "WS-RM Version";
    private static final String WS_RM_ACK_TO = "WS-RM Ack To";
    private static final String WS_RM_EXPIRES = "WS-RM Expires";
    private static final String AMF_LOGIN = "login";
    private static final String AMF_PASSWORD = "password";
    private static final String AMF_AUTHORISATION_ENABLE = "AMF Session";
    private static final String AMF_ENDPOINT = "endpoint";
    private XFormDialog dialog;
    private XForm form;
    private XForm amfForm;
    private XForm wsrmForm;

    public TestCaseOptionsAction() {
        super("Options", "Sets options for this TestCase");
    }

    @Override
    public void perform(WsdlTestCase testCase, Object param) {
        if (this.dialog == null) {
            XFormDialogBuilder builder = XFormFactory.createDialogBuilder("TestCase Options");
            this.form = builder.createForm("Basic");
            this.form.addCheckBox(SEARCH_PROPERTIES, "Search preceding TestSteps for property values");
            this.form.addCheckBox(KEEP_SESSION, "Maintain HTTP session");
            this.form.addCheckBox(FAIL_ON_ERROR, "Abort test if an error occurs").addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    TestCaseOptionsAction.this.form.getFormField(TestCaseOptionsAction.FAIL_TESTCASE_ON_ERROR).setEnabled(!Boolean.parseBoolean(newValue));
                }
            });
            this.form.addCheckBox(FAIL_TESTCASE_ON_ERROR, "Fail TestCase if it has failed TestSteps");
            this.form.addCheckBox(DISCARD_OK_RESULTS, "Discards successful TestStep results to preserve memory");
            this.form.addTextField(SOCKET_TIMEOUT, "Socket timeout in milliseconds", XForm.FieldType.TEXT);
            this.form.addTextField(TESTCASE_TIMEOUT, "Timeout in milliseconds for entire TestCase", XForm.FieldType.TEXT);
            this.form.addTextField(MAXRESULTS, "Maximum number of TestStep results to keep in memory during a run", XForm.FieldType.TEXT);
            this.wsrmForm = builder.createForm("WS-RM");
            this.wsrmForm.addCheckBox(WS_RM_ENABLED, "Use WS-Reliable Messaging");
            this.wsrmForm.addComboBox(WS_RM_VERSION, new String[]{WsrmVersionTypeConfig.X_1_0.toString(), WsrmVersionTypeConfig.X_1_1.toString(), WsrmVersionTypeConfig.X_1_2.toString()}, "The  property for managing WS-RM version");
            this.wsrmForm.addTextField(WS_RM_ACK_TO, "Acknowledgments To", XForm.FieldType.TEXT);
            this.wsrmForm.addTextField(WS_RM_EXPIRES, "Expires after", XForm.FieldType.TEXT);
            this.amfForm = builder.createForm("AMF");
            this.amfForm.addCheckBox(AMF_AUTHORISATION_ENABLE, "Enable AMF Session").addFormFieldListener(new AMFXFormFieldListener());
            this.amfForm.addTextField(AMF_ENDPOINT, "AMF Authorization endpoint", XForm.FieldType.TEXT);
            this.amfForm.addTextField(AMF_LOGIN, "AMF Authorization usernmae", XForm.FieldType.TEXT);
            this.amfForm.addTextField(AMF_PASSWORD, "AMF Authorization password", XForm.FieldType.PASSWORD);
            this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/Functional-Testing/testcase-options.html"), "Specify general options for this TestCase", UISupport.OPTIONS_ICON);
        }
        StringToStringMap values = new StringToStringMap();
        values.put(SEARCH_PROPERTIES, String.valueOf(testCase.getSearchProperties()));
        values.put(KEEP_SESSION, String.valueOf(testCase.getKeepSession()));
        values.put(FAIL_ON_ERROR, String.valueOf(testCase.getFailOnError()));
        values.put(FAIL_TESTCASE_ON_ERROR, String.valueOf(testCase.getFailTestCaseOnErrors()));
        values.put(DISCARD_OK_RESULTS, String.valueOf(testCase.getDiscardOkResults()));
        values.put(SOCKET_TIMEOUT, String.valueOf(testCase.getSettings().getString(HttpSettings.SOCKET_TIMEOUT, "")));
        values.put(TESTCASE_TIMEOUT, String.valueOf(testCase.getTimeout()));
        values.put(MAXRESULTS, String.valueOf(testCase.getMaxResults()));
        values.put(WS_RM_ENABLED, String.valueOf(testCase.getWsrmEnabled()));
        values.put(WS_RM_VERSION, String.valueOf(testCase.getWsrmVersion()));
        if (testCase.getWsrmAckTo() != null) {
            values.put(WS_RM_ACK_TO, String.valueOf(testCase.getWsrmAckTo()));
        }
        if (testCase.getWsrmExpires() != 0L) {
            values.put(WS_RM_EXPIRES, String.valueOf(testCase.getWsrmExpires()));
        }
        values.put(AMF_AUTHORISATION_ENABLE, String.valueOf(testCase.getAmfAuthorisation()));
        values.put(AMF_ENDPOINT, String.valueOf(testCase.getAmfEndpoint()));
        values.put(AMF_LOGIN, String.valueOf(testCase.getAmfLogin()));
        values.put(AMF_PASSWORD, String.valueOf(testCase.getAmfPassword()));
        this.dialog.getFormField(FAIL_TESTCASE_ON_ERROR).setEnabled(!Boolean.parseBoolean(String.valueOf(testCase.getFailOnError())));
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            try {
                String timeout;
                testCase.setSearchProperties(Boolean.parseBoolean((String)values.get(SEARCH_PROPERTIES)));
                testCase.setKeepSession(Boolean.parseBoolean((String)values.get(KEEP_SESSION)));
                testCase.setDiscardOkResults(Boolean.parseBoolean((String)values.get(DISCARD_OK_RESULTS)));
                testCase.setFailOnError(Boolean.parseBoolean((String)values.get(FAIL_ON_ERROR)));
                testCase.setFailTestCaseOnErrors(Boolean.parseBoolean((String)values.get(FAIL_TESTCASE_ON_ERROR)));
                testCase.setTimeout(Long.parseLong((String)values.get(TESTCASE_TIMEOUT)));
                testCase.setMaxResults(Integer.parseInt((String)values.get(MAXRESULTS)));
                testCase.setWsrmEnabled(Boolean.parseBoolean((String)values.get(WS_RM_ENABLED)));
                testCase.setWsrmVersion((String)values.get(WS_RM_VERSION));
                testCase.setWsrmAckTo((String)values.get(WS_RM_ACK_TO));
                if (values.get(WS_RM_EXPIRES) != null && ((String)values.get(WS_RM_EXPIRES)).length() > 0) {
                    testCase.setWsrmExpires(Long.parseLong((String)values.get(WS_RM_EXPIRES)));
                }
                if ((timeout = (String)values.get(SOCKET_TIMEOUT)).trim().length() == 0) {
                    testCase.getSettings().clearSetting(HttpSettings.SOCKET_TIMEOUT);
                } else {
                    testCase.getSettings().setString(HttpSettings.SOCKET_TIMEOUT, timeout);
                }
                testCase.setAmfAuthorisation(Boolean.parseBoolean((String)values.get(AMF_AUTHORISATION_ENABLE)));
                testCase.setAmfEndpoint((String)values.get(AMF_ENDPOINT));
                testCase.setAmfLogin((String)values.get(AMF_LOGIN));
                testCase.setAmfPassword((String)values.get(AMF_PASSWORD));
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1.getMessage());
            }
        }
    }

    private class AMFXFormFieldListener
    implements XFormFieldListener {
        private AMFXFormFieldListener() {
        }

        @Override
        public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
            TestCaseOptionsAction.this.amfForm.getFormField(TestCaseOptionsAction.AMF_ENDPOINT).setEnabled(Boolean.parseBoolean(newValue));
            TestCaseOptionsAction.this.amfForm.getFormField(TestCaseOptionsAction.AMF_LOGIN).setEnabled(Boolean.parseBoolean(newValue));
            TestCaseOptionsAction.this.amfForm.getFormField(TestCaseOptionsAction.AMF_PASSWORD).setEnabled(Boolean.parseBoolean(newValue));
        }
    }
}

