/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.project.SimpleDialog;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.util.HermesUtils;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.components.DirectoryFormComponent;
import com.eviware.soapui.support.components.SimpleForm;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class StartHermesJMS
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "StarHermesJMS";

    public StartHermesJMS() {
        super("Start HermesJMS", "Start HermesJMS application");
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        String hermesConfigPath = this.chooseFolderDialog(project);
        if (hermesConfigPath == null) {
            return;
        }
        project.setHermesConfig(hermesConfigPath);
        String hermesHome = SoapUI.getSettings().getString(ToolsSettings.HERMES_JMS, HermesUtils.defaultHermesJMSPath());
        if (!this.isHermesHomeValid(hermesHome)) {
            UISupport.showErrorMessage("Please set Hermes JMS path in Preferences->Tools ! ");
            if (UISupport.getMainFrame() != null && SoapUIPreferencesAction.getInstance().show("Tools")) {
                hermesHome = SoapUI.getSettings().getString(ToolsSettings.HERMES_JMS, HermesUtils.defaultHermesJMSPath());
            }
        }
        if (!this.isHermesHomeValid(hermesHome)) {
            return;
        }
        this.startHermesJMS(hermesConfigPath, hermesHome);
    }

    private boolean isHermesHomeValid(String hermesHome) {
        File file = new File(hermesHome + File.separator + "bin" + File.separator + "hermes.bat");
        return file.exists();
    }

    private void startHermesJMS(String hermesConfigPath, String hermesHome) {
        String extension = UISupport.isWindows() ? ".bat" : ".sh";
        String hermesBatPath = hermesHome + File.separator + "bin" + File.separator + "hermes" + extension;
        try {
            File file = new File(hermesConfigPath + File.separator + HermesUtils.HERMES_CONFIG_XML);
            if (!file.exists()) {
                UISupport.showErrorMessage("No hermes-config.xml on this path!");
                return;
            }
            ProcessBuilder pb = new ProcessBuilder(hermesBatPath);
            Map<String, String> env = pb.environment();
            env.put("HERMES_CONFIG", hermesConfigPath);
            env.put("JAVA_HOME", System.getProperty("java.home"));
            pb.start();
        }
        catch (IOException e) {
            SoapUI.logError(e);
        }
    }

    private String chooseFolderDialog(WsdlProject project) {
        HermesConfigDialog chooseHermesConfigPath = new HermesConfigDialog(PropertyExpander.expandProperties(project, project.getHermesConfig()));
        chooseHermesConfigPath.setVisible(true);
        String hermesConfigPath = chooseHermesConfigPath.getPath();
        return hermesConfigPath;
    }

    private class HermesConfigDialog
    extends SimpleDialog {
        String path;
        DirectoryFormComponent folderComponent;

        public HermesConfigDialog(String initialPath) {
            super("Start  HermesJMS", "Hermes configuration", null, true);
            this.setVisible(false);
            this.folderComponent.setValue(initialPath);
            this.folderComponent.setInitialFolder(initialPath);
        }

        @Override
        protected Component buildContent() {
            SimpleForm form = new SimpleForm();
            this.folderComponent = new DirectoryFormComponent("Location of desired HermesJMS configuration (hermes-config.xml)");
            form.addSpace(5);
            form.append("Path", this.folderComponent);
            form.addSpace(5);
            return form.getPanel();
        }

        @Override
        protected boolean handleOk() {
            this.setPath(this.folderComponent.getValue());
            return true;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

