/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.operation;

import com.eviware.soapui.config.MockResponseStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.actions.support.AbstractAddToTestCaseAction;
import com.eviware.soapui.impl.wsdl.support.CompressedStringSupport;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMockResponseTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlMockResponseStepFactory;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;

public class AddOperationAsMockResponseStepAction
extends AbstractAddToTestCaseAction<WsdlOperation> {
    private XFormDialog dialog;

    public AddOperationAsMockResponseStepAction() {
        super("Add as MockResponse Step", "Creates a MockResponseStep for this Operation");
    }

    @Override
    public void perform(WsdlOperation operation, Object param) {
        WsdlTestCase testCase = AddOperationAsMockResponseStepAction.getTargetTestCase(operation.getInterface().getProject());
        if (testCase != null) {
            this.addMockResponse(testCase, operation);
        }
    }

    protected boolean addMockResponse(WsdlTestCase testCase, WsdlOperation operation) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.setWidth(450);
        }
        this.dialog.setValue("Name", operation.getName());
        this.dialog.setBooleanValue("Shows TestCase Editor", true);
        this.dialog.setIntValue("Port", 8181);
        this.dialog.setValue("Path", "/" + operation.getName());
        if (!this.dialog.show()) {
            return false;
        }
        TestStepConfig config = WsdlMockResponseStepFactory.createConfig(operation, false);
        MockResponseStepConfig mockResponseStepConfig = (MockResponseStepConfig)config.getConfig();
        config.setName(this.dialog.getValue("Name"));
        mockResponseStepConfig.setPath(this.dialog.getValue("Path"));
        mockResponseStepConfig.setPort(this.dialog.getIntValue("Port", 8181));
        String response = operation.createResponse(operation.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS));
        CompressedStringSupport.setString(mockResponseStepConfig.addNewResponse().addNewResponseContent(), response);
        WsdlMockResponseTestStep testStep = (WsdlMockResponseTestStep)testCase.addTestStep(config);
        if (this.dialog.getBooleanValue("Add Schema Assertion")) {
            testStep.addAssertion("Schema Compliance");
        }
        UISupport.selectAndShow(testStep);
        if (this.dialog.getBooleanValue("Shows TestCase Editor")) {
            UISupport.selectAndShow(testCase);
        }
        return true;
    }

    @AForm(name="Add MockResponse to TestCase", description="Options for adding this Operations Response to a TestCase using a default response message generated from the schema.", helpUrl="http://www.soapui.org/Service-Mocking/mocking-soap-services.html", icon="/applications-system.png")
    private static interface Form {
        @AField(name="Name", description="Unique name of MockResponse Step")
        public static final String STEP_NAME = "Name";
        @AField(name="Path", description="Path to listen on")
        public static final String PATH = "Path";
        @AField(name="Port", description="Port to listen on", type=AField.AFieldType.INT)
        public static final String PORT = "Port";
        @AField(name="Add Schema Assertion", description="Adds SchemaCompliance Assertion for request", type=AField.AFieldType.BOOLEAN)
        public static final String ADD_SCHEMA_ASSERTION = "Add Schema Assertion";
        @AField(name="Shows TestCase Editor", description="Shows the target steps TestCase editor", type=AField.AFieldType.BOOLEAN)
        public static final String SHOW_TESTCASE = "Shows TestCase Editor";
    }
}

