/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.soapui.TestRunnerAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SecurityTestRunnerAction
extends TestRunnerAction {
    private static final String SH = ".sh";
    private static final String BAT = ".bat";
    private static final String SECURITYTESTRUNNER = "securitytestrunner";
    private static final String SECURITYTEST = "SecurityTest";
    protected static final String TESTRUNNERPATH = "SecurityTestRunner Path";
    public static final String SOAPUI_ACTION_ID = "SecurityTestRunnerAction";
    private static final String ALL_VALUE = "<all>";
    private static final Logger log = Logger.getLogger(SecurityTestRunnerAction.class);

    public SecurityTestRunnerAction() {
        super("Launch Security TestRunner", "Launch command-line SecurityTestRunner for this project");
    }

    @Override
    protected XFormDialog buildDialog(WsdlProject modelItem) {
        if (modelItem == null) {
            return null;
        }
        this.proVersion = this.isProVersion(modelItem);
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Launch SecurityTestRunner");
        this.createTestCaseRunnerTabs(modelItem, builder);
        return builder.buildDialog(this.buildDefaultActions("http://www.soapui.org/Test-Automation/launch-testrunner.html", modelItem), "Specify arguments for launching SoapUI Security TestRunner", UISupport.TOOL_ICON);
    }

    @Override
    protected StringToStringMap initValues(WsdlProject modelItem, Object param) {
        if (modelItem != null && this.mainForm != null) {
            ArrayList<String> endpoints = new ArrayList<String>();
            for (Interface iface : modelItem.getInterfaceList()) {
                for (String endpoint : iface.getEndpoints()) {
                    if (endpoints.contains(endpoint)) continue;
                    endpoints.add(endpoint);
                }
            }
            endpoints.add(0, null);
            this.advForm.setOptions("Endpoint", endpoints.toArray());
            this.testSuites = modelItem.getTestSuiteList();
            for (int c = 0; c < this.testSuites.size(); ++c) {
                if (((TestSuite)this.testSuites.get(c)).getTestCaseCount() != 0) continue;
                this.testSuites.remove(c);
                --c;
            }
            this.mainForm.setOptions("TestSuite", ModelSupport.getNames(new String[]{ALL_VALUE}, this.testSuites));
            ArrayList<String> testCases = new ArrayList<String>();
            for (TestSuite testSuite : this.testSuites) {
                for (TestCase testCase : testSuite.getTestCaseList()) {
                    if (testCases.contains(testCase.getName())) continue;
                    testCases.add(testCase.getName());
                }
            }
            testCases.add(0, ALL_VALUE);
            this.mainForm.setOptions("TestCase", testCases.toArray());
            ArrayList<String> securityTests = new ArrayList<String>();
            for (TestSuite testSuite : this.testSuites) {
                for (TestCase testCase : testSuite.getTestCaseList()) {
                    for (SecurityTest securityTest : testCase.getSecurityTestList()) {
                        if (securityTests.contains(securityTest.getName())) continue;
                        securityTests.add(securityTest.getName());
                    }
                }
            }
            securityTests.add(0, ALL_VALUE);
            this.mainForm.setOptions(SECURITYTEST, securityTests.toArray());
        } else if (this.mainForm != null) {
            this.mainForm.setOptions("Endpoint", new String[]{null});
        }
        this.initEnvironment(modelItem);
        StringToStringMap values = super.initValues(modelItem, param);
        if (this.mainForm != null) {
            if (param instanceof WsdlTestCase) {
                this.mainForm.getFormField("TestSuite").setValue(((WsdlTestCase)param).getTestSuite().getName());
                this.mainForm.getFormField("TestCase").setValue(((WsdlTestCase)param).getName());
                values.put("TestSuite", ((WsdlTestCase)param).getTestSuite().getName());
                values.put("TestCase", ((WsdlTestCase)param).getName());
            } else if (param instanceof WsdlTestSuite) {
                this.mainForm.getFormField("TestSuite").setValue(((WsdlTestSuite)param).getName());
                values.put("TestSuite", ((WsdlTestSuite)param).getName());
            }
            this.mainForm.getComponent("Save Project").setEnabled(!modelItem.isRemote());
        }
        return values;
    }

    private void createTestCaseRunnerTabs(WsdlProject modelItem, XFormDialogBuilder builder) {
        this.mainForm = builder.createForm("Basic");
        this.mainForm.addComboBox("TestSuite", new String[0], "The TestSuite to run").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                ArrayList<String> testCases = new ArrayList<String>();
                String tc = SecurityTestRunnerAction.this.mainForm.getComponentValue("TestCase");
                if (newValue.equals(SecurityTestRunnerAction.ALL_VALUE)) {
                    for (TestSuite testSuite : SecurityTestRunnerAction.this.testSuites) {
                        for (TestCase testCase : testSuite.getTestCaseList()) {
                            if (testCases.contains(testCase.getName())) continue;
                            testCases.add(testCase.getName());
                        }
                    }
                } else {
                    WsdlTestSuite testSuite = ((WsdlProject)SecurityTestRunnerAction.this.getModelItem()).getTestSuiteByName(newValue);
                    if (testSuite != null) {
                        testCases.addAll(Arrays.asList(ModelSupport.getNames(testSuite.getTestCaseList())));
                    }
                }
                testCases.add(0, SecurityTestRunnerAction.ALL_VALUE);
                SecurityTestRunnerAction.this.mainForm.setOptions("TestCase", testCases.toArray());
                if (testCases.contains(tc)) {
                    SecurityTestRunnerAction.this.mainForm.getFormField("TestCase").setValue(tc);
                }
            }
        });
        this.mainForm.addComboBox("TestCase", new String[0], "The TestCase to run").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                ArrayList<String> securityTests = new ArrayList<String>();
                String st = SecurityTestRunnerAction.this.mainForm.getComponentValue(SecurityTestRunnerAction.SECURITYTEST);
                if (newValue.equals(SecurityTestRunnerAction.ALL_VALUE)) {
                    for (TestSuite testSuite : SecurityTestRunnerAction.this.testSuites) {
                        for (TestCase testCase : testSuite.getTestCaseList()) {
                            for (SecurityTest securityTest : testCase.getSecurityTestList()) {
                                if (securityTests.contains(securityTest.getName())) continue;
                                securityTests.add(securityTest.getName());
                            }
                        }
                    }
                } else {
                    TestCase testCase = null;
                    try {
                        testCase = ((WsdlProject)SecurityTestRunnerAction.this.getModelItem()).getTestSuiteByName(SecurityTestRunnerAction.this.mainForm.getComponentValue("TestSuite")).getTestCaseByName(SecurityTestRunnerAction.this.mainForm.getComponentValue("TestCase"));
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    if (testCase != null) {
                        securityTests.addAll(Arrays.asList(ModelSupport.getNames(testCase.getSecurityTestList())));
                    }
                }
                securityTests.add(0, SecurityTestRunnerAction.ALL_VALUE);
                SecurityTestRunnerAction.this.mainForm.setOptions(SecurityTestRunnerAction.SECURITYTEST, securityTests.toArray());
                if (securityTests.contains(st)) {
                    SecurityTestRunnerAction.this.mainForm.getFormField(SecurityTestRunnerAction.SECURITYTEST).setValue(st);
                }
            }
        });
        this.mainForm.addComboBox(SECURITYTEST, new String[0], "The Security Test to run");
        this.mainForm.addSeparator();
        this.mainForm.addCheckBox("Enable UI", "Enables UI components in scripts");
        this.mainForm.addTextField(TESTRUNNERPATH, "Folder containing SecurityTestRunner.bat to use", XForm.FieldType.FOLDER);
        this.mainForm.addCheckBox("Save Project", "Saves project before running").setEnabled(!modelItem.isRemote());
        this.mainForm.addCheckBox("Add Settings", "Adds global settings to command-line");
        this.mainForm.addSeparator();
        this.mainForm.addTextField("Project Password", "Set project password", XForm.FieldType.PASSWORD);
        this.mainForm.addTextField("user-settings.xml Password", "Set soapui-settings.xml password", XForm.FieldType.PASSWORD);
        this.mainForm.addCheckBox("Ignore Errors", "Do not stop if error occurs, ignore them");
        this.mainForm.addCheckBox("Save After", "Sets to save the project file after tests have been run");
        this.advForm = builder.createForm("Overrides");
        this.advForm.addComboBox("Environment", new String[]{"Default"}, "The environment to set for all requests").setEnabled(this.proVersion);
        this.advForm.addComboBox("Endpoint", new String[]{""}, "endpoint to forward to");
        this.advForm.addTextField("Host:Port", "Host:Port to use for requests", XForm.FieldType.TEXT);
        this.advForm.addSeparator();
        this.advForm.addTextField("Username", "The username to set for all requests", XForm.FieldType.TEXT);
        this.advForm.addTextField("Password", "The password to set for all requests", XForm.FieldType.PASSWORD);
        this.advForm.addTextField("Domain", "The domain to set for all requests", XForm.FieldType.TEXT);
        this.advForm.addComboBox("WSS Password Type", new String[]{"", "Text", "Digest"}, "The username to set for all requests");
        this.reportForm = builder.createForm("Reports");
        this.reportForm.addCheckBox("Print Report", "Prints a summary report to the console");
        this.reportForm.addCheckBox("Export JUnit Results", "Exports results to a JUnit-Style report");
        this.reportForm.addCheckBox("Export All", "Exports all results (not only errors)");
        this.reportForm.addTextField("Root Folder", "Folder to export to", XForm.FieldType.FOLDER);
        this.reportForm.addSeparator();
        this.reportForm.addCheckBox("Coverage Report", "Generate WSDL Coverage report (SoapUI Pro only)").setEnabled(this.proVersion);
        this.reportForm.addCheckBox("Open Report", "Opens generated report(s) in browser (SoapUI Pro only)").setEnabled(this.proVersion);
        this.reportForm.addTextField("Select Report Type", "Report to Generate (SoapUI Pro only)", XForm.FieldType.TEXT).setEnabled(this.proVersion);
        this.reportForm.addTextField("Report Format(s)", "Choose report format(s), comma-separated (SoapUI Pro only)", XForm.FieldType.TEXT).setEnabled(this.proVersion);
        this.propertyForm = builder.createForm("Properties");
        this.propertyForm.addComponent("Global Properties", this.createTextArea());
        this.propertyForm.addComponent("System Properties", this.createTextArea());
        this.propertyForm.addComponent("Project Properties", this.createTextArea());
        this.setToolsSettingsAction(null);
        this.buildArgsForm(builder, false, "TestRunner");
    }

    @Override
    protected ArgumentBuilder buildArgs(WsdlProject modelItem) throws IOException {
        XFormDialog dialog = this.getDialog();
        if (dialog == null) {
            ArgumentBuilder builder = new ArgumentBuilder(new StringToStringMap());
            builder.startScript(SECURITYTESTRUNNER, BAT, SH);
            return builder;
        }
        StringToStringMap values = dialog.getValues();
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.startScript(SECURITYTESTRUNNER, BAT, SH);
        builder.addString("Endpoint", "-e", "");
        builder.addString("Host:Port", "-h", "");
        if (!((String)values.get("TestSuite")).equals(ALL_VALUE)) {
            builder.addString("TestSuite", "-s", "");
        }
        if (!((String)values.get("TestCase")).equals(ALL_VALUE)) {
            builder.addString("TestCase", "-c", "");
        }
        if (!((String)values.get(SECURITYTEST)).equals(ALL_VALUE)) {
            builder.addString(SECURITYTEST, "-n", "");
        }
        builder.addString("Username", "-u", "");
        builder.addStringShadow("Password", "-p", "");
        builder.addString("Domain", "-d", "");
        builder.addString("WSS Password Type", "-w", "");
        builder.addBoolean("Print Report", "-r");
        builder.addBoolean("Export All", "-a");
        builder.addBoolean("Export JUnit Results", "-j");
        builder.addString("Root Folder", "-f", "");
        if (this.proVersion) {
            builder.addBoolean("Open Report", "-o");
            builder.addBoolean("Coverage Report", "-g");
            builder.addString("Select Report Type", "-R", "");
            builder.addString("Report Format(s)", "-F", "");
            builder.addString("Environment", "-E", "");
        }
        builder.addStringShadow("Project Password", "-x", "");
        builder.addStringShadow("user-settings.xml Password", "-v", "");
        builder.addBoolean("Ignore Errors", "-I");
        builder.addBoolean("Save After", "-S");
        this.addPropertyArguments(builder);
        if (dialog.getBooleanValue("Add Settings")) {
            try {
                builder.addBoolean("Add Settings", "-t" + SoapUI.saveSettings());
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        builder.addBoolean("Enable UI", "-i");
        builder.addArgs(modelItem.getPath());
        this.addToolArgs(values, builder);
        return builder;
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost, WsdlProject modelItem) throws Exception {
        String testRunnerDir = this.mainForm.getComponentValue(TESTRUNNERPATH);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder args = this.buildArgs(modelItem);
        builder.command(args.getArgs());
        if (StringUtils.isNullOrEmpty(testRunnerDir)) {
            builder.directory(new File("."));
        } else {
            builder.directory(new File(testRunnerDir));
        }
        if (this.mainForm.getComponentValue("Save Project").equals(Boolean.TRUE.toString())) {
            modelItem.save();
        } else if (StringUtils.isNullOrEmpty(modelItem.getPath())) {
            UISupport.showErrorMessage("Project [" + modelItem.getName() + "] has not been saved to file.");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launching testrunner in directory [" + builder.directory() + "] with arguments [" + args.toString() + "]"));
        }
        toolHost.run(new ProcessToolRunner(builder, "SoapUI TestRunner", (ModelItem)modelItem, args));
    }
}

