/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.submit.RequestTransport;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public final class WsdlSubmit<T extends AbstractHttpRequestInterface<?>>
implements Runnable,
Submit {
    private static final Logger logger = Logger.getLogger(WsdlSubmit.class);
    private T request;
    private SubmitListener[] listeners;
    private Submit.Status status;
    private Exception error;
    private Response response;
    private volatile Future<?> future;
    private SubmitContext submitContext;
    private RequestTransport transport;

    public WsdlSubmit(T wsdlRequest, SubmitListener[] listeners, RequestTransport transport) {
        int c;
        this.request = wsdlRequest;
        this.transport = transport;
        List<SubmitListener> regListeners = SoapUI.getListenerRegistry().getListeners(SubmitListener.class);
        this.listeners = new SubmitListener[listeners.length + regListeners.size()];
        for (c = 0; c < listeners.length; ++c) {
            this.listeners[c] = listeners[c];
        }
        for (c = 0; c < regListeners.size(); ++c) {
            this.listeners[listeners.length + c] = regListeners.get(c);
        }
        this.error = null;
        this.status = Submit.Status.INITIALIZED;
        this.future = null;
    }

    public void submitRequest(SubmitContext submitContext, boolean async) {
        this.submitContext = submitContext;
        if (async && this.future != null) {
            throw new RuntimeException("Submit already running");
        }
        if (async) {
            this.future = SoapUI.getThreadPool().submit(this);
        } else {
            this.run();
        }
    }

    @Override
    public void cancel() {
        if (this.status == Submit.Status.CANCELED) {
            return;
        }
        logger.info((Object)"Canceling request..");
        if (this.status == Submit.Status.RUNNING) {
            this.transport.abortRequest(this.submitContext);
        }
        this.status = Submit.Status.CANCELED;
        for (int i = 0; i < this.listeners.length; ++i) {
            try {
                this.listeners[i].afterSubmit(this, this.submitContext);
                continue;
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block19: {
            try {
                this.submitContext.setProperty("requestTransport", this.transport);
                this.submitContext.setProperty("wsdlRequest", this.request);
                for (int i = 0; i < this.listeners.length; ++i) {
                    if (this.listeners[i].beforeSubmit(this, this.submitContext)) continue;
                    this.status = Submit.Status.CANCELED;
                    System.err.println("listener cancelled submit..");
                    return;
                }
                this.status = Submit.Status.RUNNING;
                this.response = this.transport.sendRequest(this.submitContext, (Request)this.request);
                if (this.status != Submit.Status.CANCELED) {
                    this.status = Submit.Status.FINISHED;
                }
                if (this.response.getTimeTaken() != 0L) break block19;
                logger.warn((Object)("Request took 0 in thread " + Thread.currentThread().getId() + ", response length = " + this.response.getContentLength()));
            }
            catch (Exception e1) {
                this.error = e1;
                if (this.status != Submit.Status.CANCELED) {
                    this.status = Submit.Status.ERROR;
                    logger.error((Object)("Exception in request: " + e1));
                    SoapUI.logError(e1);
                }
                if (this.response == null) {
                    this.response = (Response)this.submitContext.getProperty("httpResponse");
                }
            }
            finally {
                if (this.status == Submit.Status.CANCELED) break block19;
                for (int i = 0; i < this.listeners.length; ++i) {
                    try {
                        this.listeners[i].afterSubmit(this, this.submitContext);
                        continue;
                    }
                    catch (Throwable e) {
                        SoapUI.logError(e);
                    }
                }
            }
        }
    }

    public T getRequest() {
        return this.request;
    }

    @Override
    public Submit.Status getStatus() {
        return this.status;
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public synchronized Submit.Status waitUntilFinished() {
        if (this.future != null) {
            if (!this.future.isDone()) {
                try {
                    this.future.get();
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        } else {
            throw new RuntimeException("cannot wait on null future");
        }
        return this.getStatus();
    }

    @Override
    public Response getResponse() {
        return this.response;
    }
}

