/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.http;

import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.config.HttpRequestConfig;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.XmlBeansRestParamsTestPropertyHolder;
import com.eviware.soapui.impl.support.AbstractHttpOperation;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.HttpAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.submit.RequestTransportRegistry;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.support.jms.header.JMSHeaderConfig;
import com.eviware.soapui.impl.wsdl.support.jms.property.JMSPropertiesConfig;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;

public class HttpRequest
extends AbstractHttpRequest<HttpRequestConfig>
implements HttpRequestInterface<HttpRequestConfig> {
    private XmlBeansRestParamsTestPropertyHolder params;
    private JMSHeaderConfig jmsHeaderConfig;
    private JMSPropertiesConfig jmsPropertyConfig;

    protected HttpRequest(HttpRequestConfig config, boolean forLoadTest) {
        super(config, null, "/http_request.gif", forLoadTest);
        if (config.getParameters() == null) {
            config.addNewParameters();
        }
        this.params = new XmlBeansRestParamsTestPropertyHolder(this, config.getParameters());
    }

    @Override
    public TestProperty addProperty(String name) {
        return this.params.addProperty(name);
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.params.moveProperty(propertyName, targetIndex);
    }

    @Override
    public TestProperty removeProperty(String propertyName) {
        return this.params.removeProperty(propertyName);
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return this.params.renameProperty(name, newName);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.params.addTestPropertyListener(listener);
    }

    @Override
    public ModelItem getModelItem() {
        return this;
    }

    @Override
    public String getMediaType() {
        return ((HttpRequestConfig)this.getConfig()).getMediaType() != null ? ((HttpRequestConfig)this.getConfig()).getMediaType() : "application/xml";
    }

    @Override
    public String getPath() {
        return this.getEndpoint();
    }

    @Override
    public boolean hasRequestBody() {
        RestRequestInterface.HttpMethod method = this.getMethod();
        return method == RestRequestInterface.HttpMethod.POST || method == RestRequestInterface.HttpMethod.PUT || method == RestRequestInterface.HttpMethod.PATCH;
    }

    @Override
    public RestParamsPropertyHolder getParams() {
        return this.params;
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.params.getProperties();
    }

    @Override
    public RestParamProperty getProperty(String name) {
        return this.params.getProperty(name);
    }

    @Override
    public RestParamProperty getPropertyAt(int index) {
        return this.params.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.params.getPropertyCount();
    }

    @Override
    public String[] getPropertyNames() {
        return this.params.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.params.getPropertyValue(name);
    }

    @Override
    public boolean isPostQueryString() {
        return this.hasRequestBody() && ((HttpRequestConfig)this.getConfig()).getPostQueryString();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.params.hasProperty(name);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.params.setPropertyValue(name, value);
    }

    @Override
    public void setMediaType(String mediaType) {
        String old = this.getMediaType();
        ((HttpRequestConfig)this.getConfig()).setMediaType(mediaType);
        this.notifyPropertyChanged("mediaType", old, mediaType);
    }

    @Override
    public void setPostQueryString(boolean b) {
        boolean old = this.isPostQueryString();
        ((HttpRequestConfig)this.getConfig()).setPostQueryString(b);
        this.notifyPropertyChanged("postQueryString", old, b);
        if (!"multipart/form-data".equals(this.getMediaType()) && !"multipart/mixed".equals(this.getMediaType())) {
            this.setMediaType(b ? "application/x-www-form-urlencoded" : this.getMediaType());
        }
    }

    @Override
    public void setMethod(RestRequestInterface.HttpMethod method) {
        RestRequestInterface.HttpMethod old = this.getMethod();
        ((HttpRequestConfig)this.getConfig()).setMethod(method.toString());
        this.setIcon(UISupport.createImageIcon("/" + method.toString().toLowerCase() + "_method.gif"));
        this.notifyPropertyChanged("method", (Object)old, (Object)method);
    }

    public void setDownloadIncludedResources(boolean downloadIncludedResources) {
        boolean old = this.getDownloadIncludedResources();
        ((HttpRequestConfig)this.getConfig()).setDownloadIncludedResources(downloadIncludedResources);
        this.notifyPropertyChanged("downloadIncludedResources", old, downloadIncludedResources);
    }

    public boolean getDownloadIncludedResources() {
        return ((HttpRequestConfig)this.getConfig()).getDownloadIncludedResources();
    }

    @Override
    public String getPropertiesLabel() {
        return "HTTP Params";
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.params.removeTestPropertyListener(listener);
    }

    @Override
    public HttpAttachmentPart getAttachmentPart(String partName) {
        return null;
    }

    public HttpAttachmentPart[] getDefinedAttachmentParts() {
        return new HttpAttachmentPart[0];
    }

    @Override
    public RestRequestInterface.HttpMethod getMethod() {
        String method = ((HttpRequestConfig)this.getConfig()).getMethod();
        return method == null ? null : RestRequestInterface.HttpMethod.valueOf(method);
    }

    @Override
    public MessagePart[] getRequestParts() {
        ArrayList<MessagePart.ContentPart> result = new ArrayList<MessagePart.ContentPart>();
        for (int c = 0; c < this.getPropertyCount(); ++c) {
            result.add(new RestRequest.ParameterMessagePart(this.getPropertyAt(c)));
        }
        if (this.getMethod() == RestRequestInterface.HttpMethod.POST || this.getMethod() == RestRequestInterface.HttpMethod.PUT || this.getMethod() == RestRequestInterface.HttpMethod.PATCH) {
            result.add(new HttpContentPart());
        }
        return result.toArray(new MessagePart[result.size()]);
    }

    @Override
    public MessagePart[] getResponseParts() {
        return new MessagePart[0];
    }

    @Override
    public String getResponseContentAsXml() {
        HttpResponse response = this.getResponse();
        if (response == null) {
            return null;
        }
        return response.getContentAsXml();
    }

    @Override
    public WsdlSubmit<HttpRequest> submit(SubmitContext submitContext, boolean async) throws Request.SubmitException {
        String endpoint = PropertyExpander.expandProperties(submitContext, this.getEndpoint());
        if (StringUtils.isNullOrEmpty(endpoint)) {
            UISupport.showErrorMessage("Missing endpoint for request [" + this.getName() + "]");
            return null;
        }
        try {
            WsdlSubmit<HttpRequest> submitter = new WsdlSubmit<HttpRequest>(this, this.getSubmitListeners(), RequestTransportRegistry.getTransport(endpoint, submitContext));
            submitter.submitRequest(submitContext, async);
            return submitter;
        }
        catch (Exception e) {
            throw new Request.SubmitException(e.toString());
        }
    }

    @Override
    public void updateConfig(HttpRequestConfig request) {
        this.setConfig(request);
        if (this.params == null) {
            this.params = new XmlBeansRestParamsTestPropertyHolder(this, request.getParameters());
        } else {
            this.params.resetPropertiesConfig(request.getParameters());
        }
        List<AttachmentConfig> attachmentConfigs = ((HttpRequestConfig)this.getConfig()).getAttachmentList();
        for (int i = 0; i < attachmentConfigs.size(); ++i) {
            AttachmentConfig config = attachmentConfigs.get(i);
            this.getAttachmentsList().get(i).updateConfig(config);
        }
        if (this.jmsHeaderConfig != null) {
            this.jmsHeaderConfig.setJMSHeaderConfConfig(request.getJmsConfig());
        }
        if (this.jmsPropertyConfig != null) {
            this.jmsPropertyConfig.setJmsPropertyConfConfig(request.getJmsPropertyConfig());
        }
    }

    @Override
    public AbstractHttpOperation getOperation() {
        return null;
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.params.getPropertyList();
    }

    @Override
    public JMSHeaderConfig getJMSHeaderConfig() {
        if (this.jmsHeaderConfig == null) {
            if (!((HttpRequestConfig)this.getConfig()).isSetJmsConfig()) {
                ((HttpRequestConfig)this.getConfig()).addNewJmsConfig();
            }
            this.jmsHeaderConfig = new JMSHeaderConfig(((HttpRequestConfig)this.getConfig()).getJmsConfig(), this);
        }
        return this.jmsHeaderConfig;
    }

    @Override
    public JMSPropertiesConfig getJMSPropertiesConfig() {
        if (this.jmsPropertyConfig == null) {
            if (!((HttpRequestConfig)this.getConfig()).isSetJmsPropertyConfig()) {
                ((HttpRequestConfig)this.getConfig()).addNewJmsPropertyConfig();
            }
            this.jmsPropertyConfig = new JMSPropertiesConfig(((HttpRequestConfig)this.getConfig()).getJmsPropertyConfig(), this);
        }
        return this.jmsPropertyConfig;
    }

    @Override
    public void notifyPropertyChanged(String responseContentProperty, String oldContent, String responseContent) {
        this.notifyPropertyChanged(responseContentProperty, (Object)oldContent, (Object)responseContent);
    }

    @Override
    public String getMultiValueDelimiter() {
        return ((HttpRequestConfig)this.getConfig()).getMultiValueDelimiter();
    }

    public void setMultiValueDelimiter(String delimiter) {
        String old = this.getMultiValueDelimiter();
        ((HttpRequestConfig)this.getConfig()).setMultiValueDelimiter(delimiter);
        this.notifyPropertyChanged("multiValueDelimiter", old, delimiter);
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this, this);
        result.addAll(super.getPropertyExpansions());
        result.addAll(this.params.getPropertyExpansions());
        return result.toArray();
    }

    public boolean isSendEmptyParameters() {
        return this.getSettings().getBoolean("sendEmptyParameters");
    }

    public void setSendEmptyParameters(boolean sendEmptyParameters) {
        this.getSettings().setBoolean("sendEmptyParameters", sendEmptyParameters);
    }

    public class HttpContentPart
    extends MessagePart.ContentPart
    implements MessagePart {
        @Override
        public SchemaGlobalElement getPartElement() {
            return null;
        }

        @Override
        public QName getPartElementName() {
            return null;
        }

        @Override
        public SchemaType getSchemaType() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        public String getMediaType() {
            return ((HttpRequestConfig)HttpRequest.this.getConfig()).getMediaType();
        }
    }
}

