/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MockRequestDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MultipartMessageSupport;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public abstract class AbstractMockRequest
implements MockRequest {
    private StringToStringsMap requestHeaders;
    private String requestContent;
    private MultipartMessageSupport multipartMessageSupport;
    private final HttpServletResponse response;
    private String protocol;
    private String path;
    private final WsdlMockRunContext context;
    private final WsdlMockRunContext requestContext;
    private final HttpServletRequest request;
    private MockRequestDataSource mockRequestDataSource;
    private String actualRequestContent;
    private boolean responseMessage;
    private XmlObject requestXmlObject;

    public AbstractMockRequest(HttpServletRequest request, HttpServletResponse response, WsdlMockRunContext context) throws Exception {
        this.request = request;
        this.response = response;
        this.context = context;
        this.requestContext = new WsdlMockRunContext(context.getMockService(), null);
        this.requestHeaders = new StringToStringsMap();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            String lcHeader = header.toLowerCase();
            if (lcHeader.equals("soapaction")) {
                this.requestHeaders.put("SOAPAction", request.getHeader(header));
                continue;
            }
            if (lcHeader.equals("content-type")) {
                this.requestHeaders.put("Content-Type", request.getHeader(header));
                continue;
            }
            if (lcHeader.equals("content-length")) {
                this.requestHeaders.put("Content-Length", request.getHeader(header));
                continue;
            }
            if (lcHeader.equals("content-encoding")) {
                this.requestHeaders.put("Content-Encoding", request.getHeader(header));
                continue;
            }
            this.requestHeaders.put(header, request.getHeader(header));
        }
        this.protocol = request.getProtocol();
        this.path = request.getPathInfo();
        if (this.path == null) {
            this.path = "";
        }
        if ("POST".equals(request.getMethod())) {
            this.initPostRequest(request, context);
        }
    }

    protected void initPostRequest(HttpServletRequest request, WsdlMockRunContext context) throws Exception {
        String contentType = request.getContentType();
        if (this.isMultiPart(contentType)) {
            this.readMultipartRequest(request);
            contentType = this.getMultiPartContentType(contentType);
        } else {
            String requestContent = this.readRequestContent(request);
            this.setRequestContent(requestContent);
        }
        this.initProtocolSpecificPostContent(context, contentType);
    }

    protected void initProtocolSpecificPostContent(WsdlMockRunContext context, String contentType) throws IOException {
    }

    protected boolean isMultiPart(String contentType) {
        return contentType != null && contentType.toUpperCase().startsWith("MULTIPART");
    }

    private String getMultiPartContentType(String contentType) {
        MultipartMessageSupport multipartMessageSupport = this.getMultipartMessageSupport();
        if (multipartMessageSupport != null && multipartMessageSupport.getRootPart() != null) {
            contentType = multipartMessageSupport.getRootPart().getContentType();
        }
        return contentType;
    }

    private void readMultipartRequest(HttpServletRequest request) throws MessagingException {
        StringToStringMap values = StringToStringMap.fromHttpHeader(request.getContentType());
        MockRequestDataSource mockRequestDataSource = new MockRequestDataSource(request);
        this.setMockRequestDataSource(mockRequestDataSource);
        Settings settings = this.getRequestContext().getMockService().getSettings();
        boolean isPrettyPrint = settings.getBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES);
        MultipartMessageSupport mmSupport = new MultipartMessageSupport(mockRequestDataSource, (String)values.get("start"), null, true, isPrettyPrint);
        this.setMultipartMessageSupport(mmSupport);
    }

    private String readRequestContent(HttpServletRequest request) throws Exception {
        String compressionAlg;
        ServletInputStream is;
        String messageContent = null;
        String encoding = request.getCharacterEncoding();
        if (encoding != null) {
            encoding = StringUtils.unquote(encoding);
        }
        if ((is = request.getInputStream()).markSupported() && request.getContentLength() > 0) {
            is.mark(request.getContentLength());
        }
        ByteArrayOutputStream out = Tools.readAll((InputStream)is, 0L);
        byte[] data = out.toByteArray();
        if (is.markSupported() && request.getContentLength() > 0) {
            try {
                is.reset();
            }
            catch (IOException e) {
                SoapUI.logError(e);
            }
        }
        if ((compressionAlg = HttpClientSupport.getCompressionType(request.getContentType(), this.getRequestHeaders().get("Content-Encoding", (String)null))) != null) {
            try {
                data = CompressionSupport.decompress(compressionAlg, data);
            }
            catch (Exception e) {
                IOException ioe = new IOException("Decompression of response failed");
                ioe.initCause(e);
                throw ioe;
            }
        }
        int contentOffset = 0;
        String contentType = request.getContentType();
        if (contentType != null && data.length > 0) {
            if (contentType.toLowerCase().endsWith("xml") && data.length > 3 && data[0] == -17 && data[1] == -69 && data[2] == -65) {
                encoding = "UTF-8";
                contentOffset = 3;
            }
            String string = messageContent = (encoding = StringUtils.unquote(encoding)) == null ? new String(data) : new String(data, contentOffset, data.length - contentOffset, encoding);
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (messageContent == null) {
            messageContent = new String(data, encoding);
        }
        return messageContent;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public Attachment[] getRequestAttachments() {
        return this.multipartMessageSupport == null ? new Attachment[]{} : this.multipartMessageSupport.getAttachments();
    }

    @Override
    public String getRequestContent() {
        return this.multipartMessageSupport == null ? this.requestContent : this.multipartMessageSupport.getContentAsString();
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public HttpServletResponse getHttpResponse() {
        return this.response;
    }

    @Override
    public HttpServletRequest getHttpRequest() {
        return this.request;
    }

    @Override
    public RestRequestInterface.HttpMethod getMethod() {
        return RestRequestInterface.HttpMethod.valueOf(this.request.getMethod());
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public WsdlMockRunContext getContext() {
        return this.context;
    }

    public void setOperation(WsdlOperation operation) {
        if (this.multipartMessageSupport != null) {
            this.multipartMessageSupport.setOperation(operation);
        }
    }

    @Override
    public WsdlMockRunContext getRequestContext() {
        return this.requestContext;
    }

    @Override
    public byte[] getRawRequestData() {
        return this.mockRequestDataSource == null ? (this.actualRequestContent == null ? this.requestContent.getBytes() : this.actualRequestContent.getBytes()) : this.mockRequestDataSource.getData();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setActualRequestContent(String actualRequestContent) {
        this.actualRequestContent = actualRequestContent;
    }

    public void setMultipartMessageSupport(MultipartMessageSupport multipartMessageSupport) {
        this.multipartMessageSupport = multipartMessageSupport;
    }

    public MultipartMessageSupport getMultipartMessageSupport() {
        return this.multipartMessageSupport;
    }

    @Override
    public void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
    }

    public void setMockRequestDataSource(MockRequestDataSource mockRequestDataSource) {
        this.mockRequestDataSource = mockRequestDataSource;
    }

    public void setResponseMessage(boolean responseMessage) {
        this.responseMessage = responseMessage;
    }

    public boolean isResponseMessage() {
        return this.responseMessage;
    }

    public void setRequestXmlObject(XmlObject requestXmlObject) {
        this.requestXmlObject = requestXmlObject;
    }

    @Override
    public XmlObject getRequestXmlObject() throws XmlException {
        if (this.requestXmlObject == null && StringUtils.hasContent(this.getRequestContent())) {
            this.requestXmlObject = XmlUtils.createXmlObject(this.getRequestContent(), XmlUtils.createDefaultXmlOptions());
        }
        return this.requestXmlObject;
    }
}

