/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.config.BaseMockOperationConfig;
import com.eviware.soapui.config.MockOperationDispatchStyleConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatchRegistry;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockService;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMockOperation<BaseMockOperationConfigType extends BaseMockOperationConfig, MockResponseType extends MockResponse>
extends AbstractWsdlModelItem<BaseMockOperationConfigType>
implements MockOperation,
PropertyChangeListener {
    public static final String DISPATCH_PATH_PROPERTY = MockOperation.class.getName() + "@dispatchpath";
    public static final String DISPATCH_STYLE_PROPERTY = MockOperation.class.getName() + "@dispatchstyle";
    private MockOperationDispatcher dispatcher;
    private List<MockResponseType> responses = new ArrayList<MockResponseType>();

    protected AbstractMockOperation(BaseMockOperationConfigType config, MockService parent, String icon) {
        super(config, parent, icon);
    }

    protected void setupConfig(BaseMockOperationConfigType config) {
        Operation operation = this.getOperation();
        if (!config.isSetName()) {
            config.setName(operation == null ? "<missing operation>" : operation.getName());
        }
        if (!config.isSetDefaultResponse() && this.getMockResponseCount() > 0) {
            this.setDefaultResponse(this.getMockResponseAt(0).getName());
        }
        if (!config.isSetDispatchStyle()) {
            config.setDispatchStyle(MockOperationDispatchStyleConfig.SEQUENCE);
            this.setExampleScript();
        }
        this.dispatcher = MockOperationDispatchRegistry.buildDispatcher(((BaseMockOperationConfig)this.getConfig()).getDispatchStyle().toString(), this);
    }

    public void addMockResponse(MockResponseType response) {
        this.responses.add(response);
    }

    @Override
    public List<MockResponse> getMockResponses() {
        return new ArrayList<MockResponse>(this.responses);
    }

    public MockResponseType getMockResponseAt(int index) {
        return (MockResponseType)((MockResponse)this.responses.get(index));
    }

    @Override
    public int getMockResponseCount() {
        return this.responses.size();
    }

    public MockResponseType getMockResponseByName(String name) {
        return (MockResponseType)((MockResponse)this.getWsdlModelItemByName(this.getMockResponses(), name));
    }

    @Override
    public MockResult getLastMockResult() {
        MockResult result = null;
        for (MockResponse response : this.getMockResponses()) {
            MockResult mockResult = response.getMockResult();
            if (mockResult == null || result != null && result.getTimestamp() <= mockResult.getTimestamp()) continue;
            result = mockResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMockResponse(MockResponse mockResponse) {
        int ix = this.responses.indexOf(mockResponse);
        this.responses.remove(ix);
        mockResponse.removePropertyChangeListener(this);
        try {
            this.getMockService().fireMockResponseRemoved(mockResponse);
        }
        finally {
            mockResponse.release();
            this.removeResponseFromConfig(ix);
        }
    }

    public abstract void removeResponseFromConfig(int var1);

    public String getDefaultResponse() {
        return ((BaseMockOperationConfig)this.getConfig()).getDefaultResponse();
    }

    public void setDefaultResponse(String defaultResponse) {
        String old = this.getDefaultResponse();
        ((BaseMockOperationConfig)this.getConfig()).setDefaultResponse(defaultResponse);
    }

    @Override
    public String getScript() {
        return ((BaseMockOperationConfig)this.getConfig()).getDispatchPath();
    }

    @Override
    public void setScript(String dispatchPath) {
        String old = this.getScript();
        ((BaseMockOperationConfig)this.getConfig()).setDispatchPath(dispatchPath);
        this.notifyPropertyChanged(DISPATCH_PATH_PROPERTY, old, dispatchPath);
    }

    public void setExampleScript() {
    }

    public MockOperationDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(MockOperationDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public String getDispatchStyle() {
        return String.valueOf((Object)(((BaseMockOperationConfig)this.getConfig()).isSetDispatchStyle() ? ((BaseMockOperationConfig)this.getConfig()).getDispatchStyle() : MockOperationDispatchStyleConfig.SEQUENCE));
    }

    public MockOperationDispatcher setDispatchStyle(String dispatchStyle) {
        String old = this.getDispatchStyle();
        MockOperationDispatcher dispatcher = this.getDispatcher();
        if (dispatcher != null && dispatchStyle.equals(old)) {
            return dispatcher;
        }
        ((BaseMockOperationConfig)this.getConfig()).setDispatchStyle(MockOperationDispatchStyleConfig.Enum.forString(dispatchStyle));
        if (dispatcher != null) {
            dispatcher.release();
        }
        this.setDispatcher(MockOperationDispatchRegistry.buildDispatcher(dispatchStyle, this));
        this.notifyPropertyChanged(DISPATCH_STYLE_PROPERTY, old, dispatchStyle);
        return dispatcher;
    }
}

