/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.support;

import com.eviware.soapui.impl.rest.RestURIParser;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class RestURIParserImpl
implements RestURIParser {
    private static final String SCHEME_SEPARATOR = "://";
    private static final String DEFAULT_SCHEME = "http";
    private String resourcePath = "";
    private String query = "";
    private String scheme = "";
    private String authority = "";

    public RestURIParserImpl(String uriString) throws MalformedURLException {
        this.preValidation(uriString);
        this.parseURI(uriString);
        this.postValidation();
    }

    private void preValidation(String uriString) throws MalformedURLException {
        if (uriString == null || uriString.isEmpty()) {
            throw new MalformedURLException("Empty URI");
        }
    }

    private void parseURI(String uriString) throws MalformedURLException {
        try {
            if (this.isAPossibleEndPointWithoutScheme(uriString)) {
                uriString = "http://" + uriString;
            }
            this.parseWithURI(uriString);
        }
        catch (URISyntaxException e) {
            this.parseWithURL(uriString);
        }
    }

    private void postValidation() throws MalformedURLException {
        if (!this.validateScheme()) {
            throw new MalformedURLException("URI contains unsupported protocol. Supported protocols are HTTP/HTTPS");
        }
        if (!this.validateAuthority()) {
            throw new MalformedURLException("Invalid endpoint");
        }
    }

    private boolean validateScheme() throws MalformedURLException {
        String scheme = this.getScheme();
        return scheme.isEmpty() || scheme.matches("(HTTP|http).*");
    }

    private boolean validateAuthority() throws MalformedURLException {
        String endpoint = this.getEndpoint();
        return endpoint.isEmpty() || !endpoint.matches(".*[\\\\]+.*");
    }

    @Override
    public String getEndpoint() {
        String endpoint = this.authority.isEmpty() ? "" : (this.scheme.isEmpty() ? "http://" + this.authority : this.scheme + SCHEME_SEPARATOR + this.authority);
        return endpoint;
    }

    @Override
    public String getResourceName() {
        String path = this.getResourcePath();
        if (path.isEmpty()) {
            return path;
        }
        String[] splitResourcePath = path.split("/");
        if (splitResourcePath.length == 0) {
            return "";
        }
        String resourceName = splitResourcePath[splitResourcePath.length - 1];
        if (resourceName.startsWith(";")) {
            return "";
        }
        if ((resourceName = resourceName.replaceAll("\\{", "").replaceAll("\\}", "")).contains(";")) {
            resourceName = resourceName.substring(0, resourceName.indexOf(";"));
        }
        return resourceName.substring(0, 1).toUpperCase() + resourceName.substring(1);
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getResourcePath() {
        String path = this.resourcePath;
        path = this.addPrefixSlash(path);
        return path;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    private String addPrefixSlash(String path) {
        if (!path.startsWith("/") && !path.isEmpty()) {
            path = "/" + path;
        }
        return path;
    }

    private void parseWithURI(String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        this.resourcePath = uri.getPath() == null ? "" : uri.getPath();
        this.query = uri.getQuery() == null ? "" : uri.getQuery();
        this.scheme = uri.getScheme() == null ? "" : uri.getScheme();
        this.authority = uri.getAuthority() == null ? "" : uri.getAuthority();
    }

    private boolean isURIWithoutScheme(String uriString) {
        return !uriString.matches("[a-zA-Z]+\\:[\\/\\/]+.*");
    }

    private boolean isAPossibleEndPointWithoutScheme(String uriString) {
        int indexOfDot = uriString.indexOf(".");
        return indexOfDot > 0 && this.isURIWithoutScheme(uriString);
    }

    private void parseWithURL(String uriString) throws MalformedURLException {
        try {
            URL url = new URL(uriString);
            this.resourcePath = url.getPath() == null ? "" : url.getPath();
            this.query = url.getQuery() == null ? "" : url.getQuery();
            this.scheme = url.getProtocol() == null ? "" : url.getProtocol();
            this.authority = url.getAuthority() == null ? "" : url.getAuthority();
        }
        catch (MalformedURLException e) {
            this.parseManually(uriString);
        }
    }

    private void parseManually(String uriString) {
        int startIndexOfResource;
        this.resourcePath = uriString;
        this.query = "";
        this.scheme = "";
        this.authority = "";
        int startIndexOfQuery = uriString.indexOf(63);
        if (startIndexOfQuery >= 0) {
            this.query = uriString.substring(startIndexOfQuery + 1);
            this.resourcePath = uriString.substring(0, startIndexOfQuery);
        }
        if ((startIndexOfResource = this.resourcePath.indexOf(47)) >= 0) {
            this.resourcePath = this.resourcePath.substring(startIndexOfResource + 1);
            this.authority = this.resourcePath.substring(0, startIndexOfResource);
        }
    }
}

