/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.InvalidOAuth2ParametersException;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2ClientFacade;
import com.eviware.soapui.impl.rest.actions.oauth.OltuOAuth2ClientFacade;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class GetOAuthAccessTokenAction
extends AbstractAction {
    private OAuth2Profile target;

    public GetOAuthAccessTokenAction(OAuth2Profile target) {
        this.target = target;
        this.putValue("Name", "Get Access Token");
        this.putValue("ShortDescription", "Gets an OAuth 2 access token and stores it in this profile");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            this.getOAuthClientFacade().requestAccessToken(this.target);
        }
        catch (InvalidOAuth2ParametersException e) {
            UISupport.showErrorMessage("Invalid OAuth 2 parameters: " + e.getMessage());
        }
        catch (Exception e) {
            SoapUI.logError(e, "Error retrieving OAuth 2 access token");
            UISupport.showErrorMessage("Could not retrieve access token. Check the SoapUI log for details");
        }
    }

    protected OAuth2ClientFacade getOAuthClientFacade() {
        return new OltuOAuth2ClientFacade();
    }
}

