/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.actions.RestServiceBuilder;
import com.eviware.soapui.impl.actions.RestUriDialogHandler;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.ModelItemNamer;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class NewRestProjectAction
extends AbstractSoapUIAction<WorkspaceImpl> {
    public static final String SOAPUI_ACTION_ID = "NewRestProjectAction";
    private static final String DEFAULT_PROJECT_NAME = "REST Project";
    private static final MessageSupport messages = MessageSupport.getMessages(NewRestProjectAction.class);
    private RestUriDialogHandler dialogBuilder = new RestUriDialogHandler();
    private XFormDialog dialog;
    private RestServiceBuilder serviceBuilder = new RestServiceBuilder();

    public NewRestProjectAction() {
        super(messages.get("Title"), messages.get("Description"));
    }

    @Override
    public void perform(WorkspaceImpl workspace, Object param) {
        this.dialog = this.dialogBuilder.buildDialog(messages, new AbstractAction("Import WADL..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewRestProjectAction.this.dialog.setVisible(false);
                SoapUI.getActionRegistry().getAction("NewWadlProjectAction").perform(SoapUI.getWorkspace(), null);
                Analytics.trackAction((String)SoapUIActions.IMPORT_WADL.getActionName());
            }
        });
        while (this.dialog.show()) {
            WsdlProject project = null;
            try {
                String uri = this.dialogBuilder.getUri();
                if (uri != null) {
                    project = workspace.createProject(ModelItemNamer.createName(DEFAULT_PROJECT_NAME, workspace.getProjectList()), null);
                    this.serviceBuilder.createRestService(project, uri);
                }
                Analytics.trackAction((String)SoapUIActions.CREATE_REST_PROJECT.getActionName());
                break;
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex.getMessage());
                if (project != null) {
                    workspace.removeProject(project);
                }
                this.dialogBuilder.resetUriField();
            }
        }
    }
}

