/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.GlobalPropertySettings;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.types.StringToStringMap;
import java.awt.Dimension;

public class GlobalPropertiesPrefs
implements Prefs {
    public static final String ENABLE_OVERRIDE = "Enable Override";
    private SimpleForm globalPropertiesForm;

    @Override
    public SimpleForm getForm() {
        if (this.globalPropertiesForm == null) {
            this.globalPropertiesForm = new SimpleForm();
            PropertyHolderTable propertyHolderTable = new PropertyHolderTable(PropertyExpansionUtils.getGlobalProperties());
            propertyHolderTable.setPreferredSize(new Dimension(200, 300));
            this.globalPropertiesForm.addComponent(propertyHolderTable);
            this.globalPropertiesForm.addSpace();
            this.globalPropertiesForm.appendCheckBox(ENABLE_OVERRIDE, "Enables overriding of any property-reference with global properties", false);
        }
        return this.globalPropertiesForm;
    }

    @Override
    public void getFormValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        this.globalPropertiesForm.getValues(values);
        this.storeValues(values, settings);
    }

    @Override
    public String getTitle() {
        return "Global Properties";
    }

    @Override
    public StringToStringMap getValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        values.put(ENABLE_OVERRIDE, settings.getBoolean(GlobalPropertySettings.ENABLE_OVERRIDE));
        return values;
    }

    @Override
    public void setFormValues(Settings settings) {
        this.globalPropertiesForm.setValues(this.getValues(settings));
    }

    @Override
    public void storeValues(StringToStringMap values, Settings settings) {
        settings.setBoolean(GlobalPropertySettings.ENABLE_OVERRIDE, values.getBoolean(ENABLE_OVERRIDE));
    }
}

