/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.schemaanalyzer;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.schemaanalyzer.AnyElementProperties;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class AnyElementPropertiesImpl
implements AnyElementProperties {
    Element anyElement;
    Element documentElement;

    public AnyElementPropertiesImpl(Element anyElement, Element documentElement) {
        this.anyElement = anyElement;
        this.documentElement = documentElement;
    }

    @Override
    public Element getDocumentElement() {
        return this.documentElement;
    }

    @Override
    public String getProcessContentsAttribute() {
        String processContents = this.anyElement.getAttribute("processContents");
        if (processContents == null || processContents.isEmpty()) {
            processContents = "strict";
        }
        return processContents;
    }

    @Override
    public String getNamespaceAttributeValue() {
        String namespace = this.anyElement.getAttribute("namespace");
        if (namespace == null || namespace.isEmpty()) {
            namespace = "##any";
        }
        return namespace;
    }

    private boolean allowsDirectChildelements() {
        return this.getNamespaceAttributeValue().equals("##any");
    }

    @Override
    public boolean needsWrapper(String childNamespaceURI) {
        String namespace = this.anyElement.getAttribute("namespace");
        boolean needsWrapper = namespace != null && namespace.equals("##other") ? this.documentElement.getNamespaceURI().equals(childNamespaceURI) : !this.allowsDirectChildelements();
        return needsWrapper;
    }

    @Override
    public int compareTo(AnyElementProperties other) {
        return DomUtilities.getFastXPath((Node)this.documentElement).compareTo(DomUtilities.getFastXPath((Node)other.getDocumentElement()));
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other instanceof AnyElementPropertiesImpl) {
            isEqual = DomUtilities.getFastXPath((Node)this.documentElement).equals(DomUtilities.getFastXPath((Node)((AnyElementProperties)other).getDocumentElement()));
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.documentElement != null ? DomUtilities.getFastXPath((Node)this.documentElement).hashCode() : 0);
        return hash;
    }

    public String toString() {
        return String.format("AnyElementProperties{processContents=%s, namespace=%s, documentElement=%s}", this.getProcessContentsAttribute(), this.getNamespaceAttributeValue(), DomUtilities.getFastXPath((Node)this.documentElement));
    }
}

