/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SoapUtilities {
    private static final Logger log = Logger.getLogger(SoapUtilities.class);
    public static final String SOAP_11_NAMESPACE_URL = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP_12_NAMESPACE_URL = "http://www.w3.org/2003/05/soap-envelope";

    public static SOAPMessage stringToSoap(String soapString) throws SOAPException {
        SOAPMessage sm;
        String protocol;
        byte[] bytes;
        try {
            bytes = soapString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.fatal("### Error - this should never happen: " + e.getMessage());
            bytes = "".getBytes();
        }
        if (soapString.contains(SOAP_11_NAMESPACE_URL)) {
            protocol = "SOAP 1.1 Protocol";
        } else if (soapString.contains(SOAP_12_NAMESPACE_URL)) {
            protocol = "SOAP 1.2 Protocol";
        } else {
            throw new SOAPException("Could't not detect SOAP protocol Version");
        }
        try {
            sm = MessageFactory.newInstance((String)protocol).createMessage(null, (InputStream)new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            log.fatal("### Error - this should never happen: " + e.getMessage());
            sm = MessageFactory.newInstance().createMessage();
        }
        return sm;
    }

    public static String soapToString(SOAPElement element) {
        return SoapUtilities.domToString(element.getOwnerDocument());
    }

    public static Document stringToDom(String xmlString) throws SAXException {
        return SoapUtilities.stringToDom(xmlString, false);
    }

    public static Document stringToDom(String xmlString, boolean useNamespaces) throws SAXException {
        Document dom;
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(useNamespaces);
        StringReader reader = new StringReader(xmlString);
        InputSource input = new InputSource(reader);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.fatal("### Error - this should never happen: " + e.getMessage());
            return null;
        }
        try {
            dom = builder.parse(input);
        }
        catch (IOException e) {
            log.fatal("### Error - this should never happen: " + e.getMessage());
            return null;
        }
        return dom;
    }

    public static String domToString(Document domDoc) {
        StringWriter output = new StringWriter();
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(domDoc), new StreamResult(output));
        }
        catch (TransformerConfigurationException e) {
            log.fatal("### Error - Misconfigured Transformer Configuration, this should never happen: " + e.getMessage());
        }
        catch (TransformerFactoryConfigurationError e) {
            log.fatal("### Error - Misconfigured Transformer Factory, this should never happen: " + e.getMessage());
        }
        catch (TransformerException e) {
            log.fatal("### Error - Illegal Input, this should never happen: " + e.getMessage());
        }
        return output.toString();
    }

    public static List<SOAPElement> getSoapChilds(SOAPElement ele, QName name) {
        ArrayList<SOAPElement> list = new ArrayList<SOAPElement>();
        Iterator ei = name == null ? ele.getChildElements() : ele.getChildElements(name);
        while (ei.hasNext()) {
            Object o = ei.next();
            if (!(o instanceof SOAPElement)) continue;
            SOAPElement e = (SOAPElement)o;
            log.trace("Found Child Element // " + e.getNodeName());
            list.add(e);
        }
        return list;
    }

    public static List<SOAPElement> getSoapChilds(SOAPElement ele) {
        return SoapUtilities.getSoapChilds(ele, null);
    }

    public static List<SOAPElement> inputNeeded(SOAPElement ele) {
        ArrayList<SOAPElement> l = new ArrayList<SOAPElement>();
        log.trace("Starting Input-Needed Lookup for " + ele.getNodeName());
        SoapUtilities.inputNeeded(ele, l);
        log.trace("Input-Needed Lookup done: " + l);
        return l;
    }

    private static void inputNeeded(SOAPElement ele, List<SOAPElement> l) {
        String namespace;
        if (!(ele.hasChildNodes() && (ele.getChildNodes().getLength() != 1 || ele.getFirstChild().getNodeType() != 3) || (namespace = ele.getNamespaceURI()) != null && (namespace.equals(SOAP_11_NAMESPACE_URL) || namespace.equals(SOAP_12_NAMESPACE_URL)))) {
            log.trace("Adding node " + ele.getNodeName());
            l.add(ele);
        }
        for (SOAPElement e : SoapUtilities.getSoapChilds(ele)) {
            SoapUtilities.inputNeeded(e, l);
        }
    }

    public static Map<String, String> allNamespaces(SOAPElement ele) {
        TreeMap<String, String> nsList = new TreeMap<String, String>();
        log.trace("Starting Namespace Lookup in " + ele.getNodeName());
        SoapUtilities.allNamespaces(ele, nsList);
        log.trace("Namespace Lookup done: " + nsList);
        return nsList;
    }

    private static void allNamespaces(SOAPElement ele, Map<String, String> nsList) {
        Iterator i = ele.getNamespacePrefixes();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = ele.getNamespaceURI(prefix);
            log.trace("Found Namespace // " + prefix + ":" + uri);
            nsList.put(prefix, uri);
        }
        for (SOAPElement e : SoapUtilities.getSoapChilds(ele)) {
            SoapUtilities.allNamespaces(e, nsList);
        }
    }

    public static List<SOAPElement> getParents(SOAPElement e) {
        ArrayList<SOAPElement> parents = new ArrayList<SOAPElement>();
        for (SOAPElement zwerg = e.getParentElement(); zwerg != null; zwerg = zwerg.getParentElement()) {
            parents.add(zwerg);
        }
        return parents;
    }

    public static SOAPElement getRoot(SOAPElement e) {
        List<SOAPElement> parents = SoapUtilities.getParents(e);
        int size = parents.size();
        if (size > 0) {
            return parents.get(size - 1);
        }
        return e;
    }
}

