/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.testsuite;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdesktop.beans.AbstractBean;
import wsattacker.main.composition.testsuite.CurrentInterfaceObserver;
import wsattacker.main.testsuite.TestSuite;

public class CurrentInterface
extends AbstractBean
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(CurrentInterface.class);
    public static final String PROP_WSDLINTERFACE = "wsdlInterface";
    private TestSuite testsuite;
    private WsdlInterface wsdlInterface;
    private TestSuite testSuite;
    private final List<CurrentInterfaceObserver> observers = new ArrayList<CurrentInterfaceObserver>();

    public TestSuite getTestsuite() {
        return this.testsuite;
    }

    public void setTestsuite(TestSuite testsuite) {
        this.testsuite = testsuite;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public void setTestSuite(TestSuite newTestSuite) {
        TestSuite oldTestSuite = this.testSuite;
        if (oldTestSuite != null) {
            oldTestSuite.removePropertyChangeListener(this);
        }
        this.testSuite = newTestSuite;
        if (newTestSuite != null) {
            newTestSuite.addPropertyChangeListener("project", this);
        }
    }

    public WsdlInterface getWsdlInterface() {
        return this.wsdlInterface;
    }

    public void setWsdlInterface(WsdlInterface newWsdlInterface) {
        WsdlInterface oldWsdlInterface = this.wsdlInterface;
        this.wsdlInterface = newWsdlInterface;
        this.firePropertyChange(PROP_WSDLINTERFACE, oldWsdlInterface, newWsdlInterface);
        this.notifyCurrentServiceObservers(newWsdlInterface, oldWsdlInterface);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        WsdlProject newProject;
        String propName = pce.getPropertyName();
        if ("project".equals(propName) && (newProject = (WsdlProject)pce.getNewValue()) != null && newProject.getInterfaceCount() > 0) {
            WsdlInterface service = (WsdlInterface)newProject.getInterfaceAt(0);
            LOG.info("Set default Service to: " + service.getName());
            this.setWsdlInterface(this.wsdlInterface);
        }
    }

    @Deprecated
    public void addCurrentServiceObserver(CurrentInterfaceObserver o) {
        this.observers.add(o);
    }

    @Deprecated
    public void removeCurrentServiceObserver(CurrentInterfaceObserver o) {
        this.observers.remove(o);
    }

    private void notifyCurrentServiceObservers(WsdlInterface newService, WsdlInterface oldService) {
        if (newService == null) {
            for (CurrentInterfaceObserver o : this.observers) {
                o.noCurrentInterface();
            }
        } else {
            for (CurrentInterfaceObserver o : this.observers) {
                o.currentInterfaceChanged(newService, oldService);
            }
        }
    }
}

