/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.plugin.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import wsattacker.main.composition.ResultObserver;
import wsattacker.main.plugin.result.ResultEntry;
import wsattacker.main.plugin.result.ResultLevel;
import wsattacker.main.plugin.result.ResultObserverSettings;

public class Result
implements Collection<ResultEntry> {
    private static final Result globalLog = new Result();
    List<ResultEntry> log = new ArrayList<ResultEntry>();
    Map<ResultObserver, ResultObserverSettings> observers = new HashMap<ResultObserver, ResultObserverSettings>();

    public static Result getGlobalResult() {
        return globalLog;
    }

    public ResultEntry get(int index) {
        return this.log.get(index);
    }

    public Result filterOut(List<String> sources) {
        Result ret = new Result();
        for (ResultEntry l : this.log) {
            if (sources.contains(l.getSource())) continue;
            ret.add(l);
        }
        return ret;
    }

    public Result filterOut(String source) {
        Result ret = new Result();
        for (ResultEntry l : this.log) {
            if (l.getSource().equals(source)) continue;
            ret.add(l);
        }
        return ret;
    }

    public Result filterOut(ResultLevel level) {
        Result ret = new Result();
        for (ResultEntry l : this.log) {
            if (l.getLevel().compareTo(level) <= 0) continue;
            ret.add(l);
        }
        return ret;
    }

    public Result filterOnly(String source) {
        Result ret = new Result();
        for (ResultEntry l : this.log) {
            if (!l.getSource().equals(source)) continue;
            ret.add(l);
        }
        return ret;
    }

    public Result filterOnly(List<String> sources) {
        Result ret = new Result();
        for (ResultEntry l : this.log) {
            if (!sources.contains(l.getSource())) continue;
            ret.add(l);
        }
        return ret;
    }

    public Result filterOnly(ResultLevel level) {
        Result ret = new Result();
        for (ResultEntry l : this.log) {
            if (l.getLevel().compareTo(level) > 0) continue;
            ret.add(l);
        }
        return ret;
    }

    public boolean registerObserver(ResultObserver o) {
        if (!this.observers.containsKey(o)) {
            this.observers.put(o, new ResultObserverSettings());
            return true;
        }
        return false;
    }

    public boolean removeObserver(ResultObserver o) {
        if (this.observers.containsKey(o)) {
            this.observers.remove(o);
            return true;
        }
        return false;
    }

    public void setObserverLevel(ResultObserver o, ResultLevel level) {
        this.observers.get(o).setLevel(level);
    }

    public void addObserverLogSource(ResultObserver o, String source) {
        this.observers.get(o).addSource(source);
    }

    public void removeObserverLogSource(ResultObserver o, String source) {
        this.observers.get(o).removeSource(source);
    }

    public List<String> getSoures(ResultObserver o) {
        return this.observers.get(o).getSources();
    }

    public void setSources(ResultObserver o, List<String> sources) {
        this.observers.get(o).setSources(sources);
    }

    private void notifyObserversAdd(ResultEntry newResult) {
        for (Map.Entry<ResultObserver, ResultObserverSettings> entry : this.observers.entrySet()) {
            ResultObserver o = entry.getKey();
            ResultObserverSettings s = entry.getValue();
            if (!s.check(newResult)) continue;
            o.logUpdate(newResult);
        }
    }

    private void notifyObserversClear() {
        for (Map.Entry<ResultObserver, ResultObserverSettings> entry : this.observers.entrySet()) {
            entry.getKey().logClear();
        }
    }

    @Override
    public Iterator<ResultEntry> iterator() {
        return this.log.iterator();
    }

    @Override
    public boolean add(ResultEntry arg0) {
        boolean ret = this.log.add(arg0);
        this.notifyObserversAdd(arg0);
        return ret;
    }

    @Override
    public boolean addAll(Collection<? extends ResultEntry> arg0) {
        boolean ret = true;
        for (ResultEntry resultEntry : arg0) {
            ret &= this.add(resultEntry);
        }
        return ret;
    }

    @Override
    public void clear() {
        this.log.clear();
        this.notifyObserversClear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.log.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.log.containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.log.isEmpty();
    }

    @Override
    public boolean remove(Object arg0) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.log.retainAll(arg0);
    }

    @Override
    public int size() {
        return this.log.size();
    }

    @Override
    public Object[] toArray() {
        return this.log.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.log.toArray(arg0);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (ResultEntry l : this.log) {
            b.append(l.toString()).append("\n");
        }
        return new String(b);
    }
}

