/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.composition.plugin.option;

import java.io.File;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.gui.component.pluginconfiguration.option.OptionFileGUI_NB;
import wsattacker.main.composition.plugin.option.AbstractOption;

public abstract class AbstractOptionFile
extends AbstractOption {
    private static final long serialVersionUID = 2L;
    public static final String PROP_FILE = "file";
    private File file = null;

    protected AbstractOptionFile(String name, String description) {
        super(name, description);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (!this.isValid(file)) {
            throw new IllegalArgumentException(String.format("isValid(\"%s\") returned false", file));
        }
        File oldFile = this.file;
        this.file = file;
        this.firePropertyChange(PROP_FILE, oldFile, file);
    }

    @Override
    public boolean isValid(String value) {
        try {
            File test = new File(value);
            return this.isValid(test);
        }
        catch (Exception e) {
            return false;
        }
    }

    public abstract boolean isValid(File var1);

    @Override
    public void parseValue(String value) {
        if (!this.isValid(value)) {
            throw new IllegalArgumentException(String.format("isValid(\"%s\") returned false", value));
        }
        this.setFile(new File(value));
    }

    @Override
    public String getValueAsString() {
        return this.file == null ? "" : this.file.toString();
    }

    @Override
    public OptionGUI createOptionGUI() {
        return new OptionFileGUI_NB(this);
    }
}

