/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.main.composition.plugin.option;

import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.gui.component.pluginconfiguration.option.OptionBooleanGUI_NB;
import wsattacker.main.composition.plugin.option.AbstractOption;

public abstract class AbstractOptionBoolean
extends AbstractOption {
    private static final long serialVersionUID = 2L;
    public static final String PROP_ON = "on";
    private boolean on;

    public AbstractOptionBoolean(String name, boolean on) {
        this(name, on, "");
    }

    public AbstractOptionBoolean(String name, boolean on, String description) {
        super(name, description);
        this.on = on;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        if (!this.isValid(on)) {
            throw new IllegalArgumentException(String.format("isValid(%s) returned false", on));
        }
        boolean oldOn = this.on;
        this.on = on;
        this.firePropertyChange(PROP_ON, oldOn, on);
    }

    @Override
    public void parseValue(String value) {
        if (!this.isValid(value)) {
            throw new IllegalArgumentException(String.format("isValid(\"%s\") returned false", value));
        }
        this.setOn(Boolean.valueOf(value));
    }

    @Override
    public String getValueAsString() {
        return String.format("%b", this.isOn());
    }

    public abstract boolean isValid(boolean var1);

    @Override
    public OptionGUI createOptionGUI() {
        return new OptionBooleanGUI_NB(this);
    }
}

