/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class MultiLineTableCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private final List<List<Integer>> rowColHeight = new ArrayList<List<Integer>>();

    public MultiLineTableCellRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(new EmptyBorder(1, 2, 1, 2));
        }
        if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
        this.adjustRowHeight(table, row, column);
        return this;
    }

    private void adjustRowHeight(JTable table, int row, int column) {
        int cWidth = table.getTableHeader().getColumnModel().getColumn(column).getWidth();
        this.setSize(new Dimension(cWidth, 1000));
        int prefH = this.getPreferredSize().height;
        while (this.rowColHeight.size() <= row) {
            this.rowColHeight.add(new ArrayList(column));
        }
        List<Integer> colHeights = this.rowColHeight.get(row);
        while (colHeights.size() <= column) {
            colHeights.add(0);
        }
        colHeights.set(column, prefH);
        int maxH = prefH;
        for (Integer colHeight : colHeights) {
            if (colHeight <= maxH) continue;
            maxH = colHeight;
        }
        if (table.getRowHeight(row) != maxH) {
            table.setRowHeight(row, maxH);
        }
    }
}

