/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.util;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import wsattacker.gui.util.CenteredTableCellRenderer;
import wsattacker.gui.util.Colors;
import wsattacker.main.plugin.PluginState;

public class ColoredPluginStateTableCellRenderer
extends CenteredTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final String FONTNAME = "Dialog";

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value != null) {
            c.setText(value.toString());
            PluginState state = PluginState.valueOf(c.getText());
            switch (state) {
                case Ready: {
                    c.setFont(new Font(FONTNAME, 0, 12));
                    break;
                }
                case Running: {
                    c.setFont(new Font(FONTNAME, 2, 12));
                    c.setBackground(Colors.RUNNING);
                    c.setOpaque(true);
                    break;
                }
                case Finished: {
                    c.setFont(new Font(FONTNAME, 1, 12));
                    c.setBackground(Colors.OK);
                    c.setOpaque(true);
                    break;
                }
                case Aborting: 
                case Stopped: 
                case Failed: 
                case Not_Configured: {
                    c.setFont(new Font(FONTNAME, 1, 12));
                    c.setBackground(Colors.INVALID);
                    c.setOpaque(true);
                }
            }
        } else {
            c.setText("");
        }
        return c;
    }
}

