/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.target.subcomponent;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.model.iface.Request;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import wsattacker.main.composition.ControllerInterface;
import wsattacker.main.testsuite.TestSuite;
import wsattacker.util.SoapUtilities;

public class RequestInputTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String PROP_CONTROLLER = "controller";
    private final String[] columnNames = new String[]{"Name", "Parents", "Value"};
    private List<SOAPElement> list;
    private ControllerInterface controller;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public RequestInputTableModel() {
        this.list = new ArrayList<SOAPElement>();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public String getColumnName(int num) {
        return this.columnNames[num];
    }

    @Override
    public boolean isCellEditable(int y, int x) {
        return x == 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.list.get(row).getNodeName();
        }
        if (col == 1) {
            List<SOAPElement> parents = SoapUtilities.getParents(this.list.get(row));
            StringBuffer buffer = new StringBuffer();
            for (SOAPElement e : parents) {
                buffer.insert(0, e.getNodeName() + " -> ");
            }
            buffer.delete(buffer.length() - 4, buffer.length());
            return buffer.toString();
        }
        if (col == 2) {
            return this.list.get(row).getTextContent();
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String newValue = (String)value;
        SOAPElement theElement = this.list.get(row);
        theElement.setTextContent(newValue);
        Logger log = Logger.getLogger(this.getClass());
        log.trace(String.format("Set Value @ (%d,%d) --> %s='%s'", row, col, theElement.getNodeName(), newValue));
        if (this.getController() != null) {
            this.getController().setRequestContent(this.getRequestContent());
        }
    }

    public List<SOAPElement> getData() {
        return this.list;
    }

    public void setData(Request request) throws SOAPException {
        this.setData(request.getRequestContent());
    }

    public void setData(String request) throws SOAPException {
        SOAPMessage msg = SoapUtilities.stringToSoap(request);
        List<SOAPElement> list = SoapUtilities.inputNeeded((SOAPElement)msg.getSOAPPart().getEnvelope());
        this.setData(list);
    }

    public void setData(List<SOAPElement> list) {
        if (list == null) {
            return;
        }
        this.list = list;
        this.fireTableDataChanged();
    }

    public SOAPElement getRequestRoot() {
        if (this.list.size() > 0) {
            return SoapUtilities.getRoot(this.list.get(0));
        }
        return null;
    }

    public String getRequestContent() {
        SOAPElement root = this.getRequestRoot();
        if (root == null) {
            return "";
        }
        return SoapUtilities.soapToString(root);
    }

    public void currentRequestChanged(WsdlRequest newRequest, WsdlRequest oldRequest) {
        try {
            this.setData(newRequest);
        }
        catch (SOAPException e) {
            Logger.getLogger(this.getClass()).error("Invalid Request " + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error("Unknown Error: Invalid Request " + e.getMessage() != null ? e.getMessage() : "");
        }
    }

    public void currentRequestContentChanged(String newContent, String oldContent) {
        try {
            this.setData(newContent);
        }
        catch (SOAPException e) {
            Logger.getLogger(this.getClass()).error("Invalid Request " + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error("Unknown Error: Invalid Request " + e.getMessage() != null ? e.getMessage() : "");
        }
    }

    public void noCurrentRequest() {
        this.setData(new ArrayList<SOAPElement>());
    }

    public void noCurrentRequestcontent() {
        this.setData(new ArrayList<SOAPElement>());
    }

    public ControllerInterface getController() {
        return this.controller;
    }

    public void setController(ControllerInterface controller) {
        ControllerInterface oldController = controller;
        this.controller = controller;
        if (oldController != null) {
            oldController.getTestSuite().getCurrentRequest().removePropertyChangeListener(this);
        }
        if (this.controller != null) {
            TestSuite testSuite = this.controller.getTestSuite();
            testSuite.getCurrentRequest().addPropertyChangeListener("wsdlRequest", this);
            testSuite.getCurrentRequest().addPropertyChangeListener("wsdlRequestContent", this);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_CONTROLLER, oldController, controller);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if (propName.equals("wsdlRequest")) {
            WsdlRequest newRequest = (WsdlRequest)pce.getNewValue();
            WsdlRequest oldRequest = (WsdlRequest)pce.getOldValue();
            if (newRequest == null) {
                this.noCurrentRequest();
            } else {
                this.currentRequestChanged(newRequest, oldRequest);
            }
        } else if (propName.equals("wsdlRequestContent")) {
            String newContent = (String)pce.getNewValue();
            String oldContent = (String)pce.getOldValue();
            if (newContent == null) {
                this.noCurrentRequestcontent();
            } else {
                this.currentRequestContentChanged(newContent, oldContent);
            }
        }
    }
}

