/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.target.subcomponent;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.model.iface.Operation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComboBox;
import wsattacker.main.composition.ControllerInterface;
import wsattacker.main.testsuite.TestSuite;

public class OperationComboBox
extends JComboBox
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String PROP_CONTROLLER = "controller";
    private ControllerInterface controller;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public OperationComboBox() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (OperationComboBox.this.controller != null && OperationComboBox.this.getSelectedIndex() >= 0) {
                    OperationComboBox.this.controller.setCurrentOperation(OperationComboBox.this.getSelectedIndex());
                }
            }
        });
    }

    public void currentInterfaceChanged(WsdlInterface newService, WsdlInterface oldService) {
        this.removeAllItems();
        if (newService.getOperationList() != null) {
            for (Operation operation : newService.getOperationList()) {
                this.addItem(operation.getName());
            }
        }
        if (this.getItemCount() > 0) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void noCurrentInterface() {
        this.removeAllItems();
        this.setEnabled(false);
    }

    public void currentOperationChanged(WsdlOperation newOperation, WsdlOperation oldOperation) {
        this.setSelectedItem(newOperation.getName());
    }

    public void noCurrentOperation() {
    }

    public ControllerInterface getController() {
        return this.controller;
    }

    public void setController(ControllerInterface controller) {
        TestSuite testSuite;
        ControllerInterface oldController = controller;
        this.controller = controller;
        if (oldController != null) {
            testSuite = oldController.getTestSuite();
            testSuite.getCurrentInterface().removePropertyChangeListener("wsdlInterface", this);
            testSuite.getCurrentOperation().removePropertyChangeListener("wsdlOperation", this);
        }
        if (this.controller != null) {
            testSuite = this.controller.getTestSuite();
            testSuite.getCurrentInterface().addPropertyChangeListener("wsdlInterface", this);
            testSuite.getCurrentOperation().addPropertyChangeListener("wsdlOperation", this);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_CONTROLLER, oldController, controller);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if ("wsdlInterface".equals(propName)) {
            WsdlInterface newInterface = (WsdlInterface)pce.getNewValue();
            WsdlInterface oldInterface = (WsdlInterface)pce.getOldValue();
            if (newInterface == null) {
                this.noCurrentInterface();
            } else {
                this.currentInterfaceChanged(newInterface, oldInterface);
            }
        } else if ("wsdlOperation".equals(propName)) {
            WsdlOperation newOperation = (WsdlOperation)pce.getNewValue();
            WsdlOperation oldOperation = (WsdlOperation)pce.getOldValue();
            this.currentOperationChanged(newOperation, oldOperation);
        }
    }
}

