/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.pluginconfiguration.subcomponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.PropertyResolutionException;
import org.jdesktop.el.ELException;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.gui.component.pluginconfiguration.controller.SelectedPluginController;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.option.AbstractOption;

public class SelectedPlugin
extends JPanel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(SelectedPlugin.class);
    private JLabel authorLabel;
    private JLabel authorValue;
    private JLabel descriptionLabel;
    private JScrollPane descriptionScrollPane;
    private JTextPane descriptionValue;
    private JLabel nameLabel;
    private JLabel optionLabel;
    private JPanel optionPanel;
    private JScrollPane optionScrollPane;
    private JLabel pluginIcon;
    private SelectedPluginController selectedPluginController;
    private JLabel versionLabel;
    private JLabel versionValue;
    private BindingGroup bindingGroup;

    public SelectedPlugin() {
        this.initComponents();
        this.selectedPluginController.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.selectedPluginController = new SelectedPluginController();
        this.nameLabel = new JLabel();
        this.authorLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.versionValue = new JLabel();
        this.authorValue = new JLabel();
        this.descriptionLabel = new JLabel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionValue = new JTextPane();
        this.optionLabel = new JLabel();
        this.optionScrollPane = new JScrollPane();
        this.optionPanel = new JPanel();
        this.pluginIcon = new JLabel();
        this.nameLabel.setFont(new Font("Dialog", 1, 18));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.selectedPluginController, ELProperty.create("${selectedPlugin.name}"), this.nameLabel, BeanProperty.create("text"), "pluginName");
        this.bindingGroup.addBinding(binding);
        this.authorLabel.setText("Author:");
        this.versionLabel.setText("Version:");
        this.versionValue.setFont(new Font("Dialog", 0, 12));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.selectedPluginController, ELProperty.create("${selectedPlugin.version}"), this.versionValue, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.authorValue.setFont(new Font("Dialog", 0, 12));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.selectedPluginController, ELProperty.create("${selectedPlugin.author}"), this.authorValue, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.descriptionLabel.setText("Description:");
        this.descriptionValue.setEditable(false);
        this.descriptionValue.setBackground(new Color(238, 238, 238));
        this.descriptionValue.setContentType("text/html");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.selectedPluginController, ELProperty.create("${selectedPlugin.description}"), this.descriptionValue, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.descriptionScrollPane.setViewportView(this.descriptionValue);
        this.optionLabel.setText("Options:");
        this.optionScrollPane.setMaximumSize(new Dimension(200, Short.MAX_VALUE));
        this.optionPanel.setCursor(new Cursor(0));
        this.optionPanel.setLayout(new BoxLayout(this.optionPanel, 1));
        this.optionScrollPane.setViewportView(this.optionPanel);
        this.pluginIcon.setHorizontalAlignment(11);
        this.pluginIcon.setIconTextGap(0);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.selectedPluginController, ELProperty.create("${selectedPlugin.icon}"), this.pluginIcon, BeanProperty.create("icon"), "iconBinding");
        binding.setSourceNullValue(null);
        binding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.selectedPluginController, ELProperty.create("${selectedPlugin.name}"), this.pluginIcon, BeanProperty.create("toolTipText"));
        this.bindingGroup.addBinding(binding);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionScrollPane, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.descriptionScrollPane).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.optionLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authorLabel).addComponent(this.versionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.versionValue, -1, -1, Short.MAX_VALUE).addComponent(this.authorValue, -1, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pluginIcon, -2, 107, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorLabel).addComponent(this.authorValue, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.versionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.versionValue, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionLabel)).addComponent(this.pluginIcon, -2, 57, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionScrollPane, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionScrollPane, -1, 1108, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    public SelectedPluginController getSelectedPluginController() {
        return this.selectedPluginController;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propertyName = pce.getPropertyName();
        if ("selectedPlugin".equals(propertyName)) {
            List<AbstractOption> newOptions = ((AbstractPlugin)pce.getNewValue()).getPluginOptions().getOptions();
            this.removeAndUnbindAllComponents();
            this.handleMultipleNewOptions(0, Collections.emptyList(), newOptions);
            this.adjustingOptionPanelSize();
            this.handleOptionContainerChangeListener(pce);
        } else if (pce instanceof IndexedPropertyChangeEvent && "options".equals(pce.getPropertyName())) {
            IndexedPropertyChangeEvent ipce = (IndexedPropertyChangeEvent)pce;
            int index = ipce.getIndex();
            if (ipce.getNewValue() instanceof List) {
                List oldValue = (List)ipce.getOldValue();
                List newValue = (List)ipce.getNewValue();
                this.handleMultipleNewOptions(index, oldValue, newValue);
            } else if (ipce.getNewValue() instanceof AbstractOption) {
                this.handleReplacedOption(index, ipce);
            }
        }
    }

    private OptionGUI createOption(AbstractOption option) {
        return option.createOptionGUI();
    }

    private void handleOptionContainerChangeListener(PropertyChangeEvent pce) {
        AbstractPlugin oldPlugin = (AbstractPlugin)pce.getOldValue();
        AbstractPlugin newPlugin = (AbstractPlugin)pce.getNewValue();
        if (oldPlugin != null) {
            oldPlugin.getPluginOptions().removePropertyChangeListener(this);
        }
        if (newPlugin != null) {
            newPlugin.getPluginOptions().addPropertyChangeListener(this);
        }
    }

    private void handleMultipleNewOptions(int index, List<AbstractOption> oldValue, List<AbstractOption> newValue) {
        ArrayList<AbstractOption> oldOptions = new ArrayList<AbstractOption>(oldValue);
        this.removeNoLongerUsedOptions(oldOptions, newValue);
        for (int newIndex = 0; newIndex < newValue.size(); ++newIndex) {
            AbstractOption newOption = newValue.get(newIndex);
            int oldIndex = oldOptions.indexOf(newOption);
            if (oldIndex == newIndex) continue;
            if (oldIndex < 0) {
                this.insertOptionAtPosition(newOption, newIndex, oldOptions);
                continue;
            }
            this.moveOption(oldIndex, newIndex, oldOptions);
        }
    }

    private void handleReplacedOption(int index, IndexedPropertyChangeEvent ipce) {
        try {
            this.optionPanel.remove(index);
            AbstractOption option = (AbstractOption)ipce.getNewValue();
            LOG.debug("Created Option " + option.getName());
            OptionGUI optionGUI = this.createOption(option);
            this.optionPanel.add((Component)optionGUI, index);
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    private void removeAndUnbind(int index) {
        if (this.optionPanel.getComponent(index) instanceof OptionGUI) {
            OptionGUI option = (OptionGUI)this.optionPanel.getComponent(index);
            try {
                option.bindingDoUnbind();
            }
            catch (ELException e) {
                LOG.warn(e);
            }
            catch (PropertyResolutionException e) {
                LOG.warn(e);
            }
        }
        this.optionPanel.remove(index);
    }

    private void removeAndUnbindAllComponents() {
        int max = this.optionPanel.getComponentCount();
        for (int i = 0; i < max; ++i) {
            this.removeAndUnbind(0);
        }
    }

    JPanel getOptionPanel() {
        return this.optionPanel;
    }

    private void removeNoLongerUsedOptions(List<AbstractOption> oldOptions, List<AbstractOption> newOptions) {
        int end;
        for (int oldIndex = end = oldOptions.size() - 1; oldIndex >= 0; --oldIndex) {
            AbstractOption o = oldOptions.get(oldIndex);
            if (newOptions.contains(o)) continue;
            this.removeAndUnbind(oldIndex);
            oldOptions.remove(oldIndex);
        }
    }

    private void insertOptionAtPosition(AbstractOption newOption, int newIndex, List<AbstractOption> oldOptions) {
        try {
            LOG.debug("Created Option " + newOption.getName());
            OptionGUI optionGUI = this.createOption(newOption);
            this.optionPanel.add((Component)optionGUI, newIndex);
            oldOptions.add(newIndex, newOption);
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    private void moveOption(int oldIndex, int newIndex, List<AbstractOption> oldOptions) {
        Component component = this.optionPanel.getComponent(oldIndex);
        this.optionPanel.remove(component);
        this.optionPanel.add(component, newIndex);
        oldOptions.add(newIndex, oldOptions.remove(oldIndex));
    }

    private void adjustingOptionPanelSize() {
        int width = this.optionScrollPane.getSize().width - 20;
        for (int i = 0; i < this.optionPanel.getComponentCount(); ++i) {
            Component c = this.optionPanel.getComponent(i);
            int height = c.getPreferredSize().height;
            c.setPreferredSize(new Dimension(width, height));
        }
        this.optionPanel.setSize(this.optionPanel.getPreferredSize());
    }
}

