/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.pluginconfiguration.subcomponent;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.DefaultCheckboxTreeCellRenderer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.apache.log4j.Logger;
import wsattacker.gui.component.pluginconfiguration.subcomponent.PluginTree;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.util.Category;

public class PluginTreeCellRenderer
extends DefaultCheckboxTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(PluginTreeCellRenderer.class);
    public static final String PROP_PLUGINTREE = "pluginTree";
    private JTree pluginTree;

    public JTree getPluginTree() {
        return this.pluginTree;
    }

    public void setPluginTree(PluginTree pluginTree) {
        JTree oldPluginTree = this.pluginTree;
        this.pluginTree = pluginTree;
        super.firePropertyChange(PROP_PLUGINTREE, oldPluginTree, pluginTree);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component defaultCell = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        JLabel additionalText = new JLabel();
        additionalText.setFont(new Font("Dialog", 2, 12));
        JPanel newCell = new JPanel();
        newCell.setLayout(new FlowLayout(0, 0, 0));
        newCell.setOpaque(false);
        newCell.add(defaultCell);
        newCell.add(additionalText);
        if (value instanceof Category) {
            additionalText.setText(String.format("(%d)", ((Category)value).getLeafsRecursive().size()));
        } else if (value instanceof AbstractPlugin) {
            AbstractPlugin plugin = (AbstractPlugin)value;
            additionalText.setText(String.format("(%s)", new Object[]{plugin.getState()}));
        } else {
            LOG.warn("Does not expect class: " + value.getClass());
        }
        return newCell;
    }
}

