/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.gui.component.pluginconfiguration.option;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionMultiFiles;
import wsattacker.main.plugin.option.OptionSimpleMultiFiles;

public class OptionMultiFileGUI_NB
extends OptionGUI {
    private AbstractOptionMultiFiles option = new OptionSimpleMultiFiles("Sample File Option", "Sample File Description");
    public static final String PROP_OPTION = "option";
    private JLabel currentFileLabel;
    private JLabel description;
    private JButton fileButton;
    private JFileChooser fileChooser;
    private JList fileList;
    private JScrollPane fileListScrollPane;
    private JLabel name;
    private JButton removeButton;
    private JLabel typeLabel;
    private JLabel typeValue;
    private BindingGroup bindingGroup;

    public AbstractOptionMultiFiles getOption() {
        return this.option;
    }

    public void setOption(AbstractOptionMultiFiles option) {
        AbstractOptionMultiFiles oldOption = this.option;
        this.option = option;
        this.firePropertyChange(PROP_OPTION, oldOption, option);
    }

    public OptionMultiFileGUI_NB() {
        this.initComponents();
    }

    public OptionMultiFileGUI_NB(AbstractOptionMultiFiles option) {
        this.option = option;
        this.initComponents();
    }

    private void setValueBackgroundIfError(boolean error) {
        if (error) {
            this.fileButton.setBackground(COLOR_ERROR);
        } else {
            this.fileButton.setBackground(COLOR_OK);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.fileChooser = new JFileChooser();
        this.name = new JLabel();
        this.description = new JLabel();
        this.currentFileLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.typeValue = new JLabel();
        this.fileButton = new JButton();
        this.fileListScrollPane = new JScrollPane();
        this.fileList = new JList();
        this.removeButton = new JButton();
        this.fileChooser.setDialogTitle("Select the Files");
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return OptionMultiFileGUI_NB.this.getOption().getDescription();
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return OptionMultiFileGUI_NB.this.getOption().isValid(f);
            }
        });
        this.fileChooser.setMultiSelectionEnabled(true);
        this.name.setFont(new Font("Dialog", 1, 18));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.name}"), this.name, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Name");
        binding.setSourceUnreadableValue("Option Name");
        this.bindingGroup.addBinding(binding);
        this.description.setFont(new Font("Dialog", 0, 12));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this, ELProperty.create("${option.description}"), this.description, BeanProperty.create("text"));
        binding.setSourceNullValue("Option Description");
        binding.setSourceUnreadableValue("Option Description");
        this.bindingGroup.addBinding(binding);
        this.currentFileLabel.setFont(new Font("Dialog", 0, 12));
        this.currentFileLabel.setText("Current Files:");
        this.typeLabel.setFont(new Font("Dialog", 0, 12));
        this.typeLabel.setText("Type:");
        this.typeValue.setText("multiple File");
        this.fileButton.setText("Select Files");
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionMultiFileGUI_NB.this.fileButtonActionPerformed(evt);
            }
        });
        this.fileList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.fileList.setLayoutOrientation(2);
        ELProperty eLProperty = ELProperty.create("${option.files}");
        JListBinding jListBinding = SwingBindings.createJListBinding(AutoBinding.UpdateStrategy.READ, this, eLProperty, this.fileList);
        jListBinding.setDetailBinding(ELProperty.create("${name}"));
        this.bindingGroup.addBinding(jListBinding);
        this.fileListScrollPane.setViewportView(this.fileList);
        this.removeButton.setText("Remove Selected");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionMultiFileGUI_NB.this.removeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.typeLabel).addGap(15, 15, 15).addComponent(this.typeValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentFileLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.fileListScrollPane)).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name).addGroup(layout.createSequentialGroup().addComponent(this.fileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton)).addComponent(this.description)).addContainerGap(-1, Short.MAX_VALUE)))));
        layout.linkSize(0, this.fileButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.name).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileButton).addComponent(this.removeButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.currentFileLabel).addComponent(this.typeLabel).addComponent(this.typeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileListScrollPane, -2, 94, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.description)));
        this.bindingGroup.bind();
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File[] files = this.fileChooser.getSelectedFiles();
            boolean valid = this.option.isValid(files);
            this.setValueBackgroundIfError(!valid);
            if (valid) {
                this.option.setFilesAsArray(files);
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] selected = this.fileList.getSelectedIndices();
        Arrays.sort(selected);
        ArrayList<File> currentFileList = new ArrayList<File>(this.option.getFiles());
        for (int i = selected.length - 1; i >= 0; --i) {
            currentFileList.remove(selected[i]);
        }
        this.option.setFiles(currentFileList);
    }

    @Override
    public void bindingDoUnbind() {
        this.bindingGroup.unbind();
    }

    public JList getFileList() {
        return this.fileList;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    @Override
    public AbstractOption getUsedOption() {
        return this.option;
    }
}

