#!/usr/bin/env python3
#
# MIT - (c) 2016 ThomasTJ (TTJ)
#
# Module for WMDframe
# This modules is a plain runner for SPARTA
#


try:
    import core.core as core
    import core.commands as comm
    import core.modules as cmodules
    from core.colors import bc as bc
except:
    # Running module outside the WMDframe might require path changing to import core modules
    import sys
    sys.path.append('././')
    import core.core as core
    import core.commands as comm
    import core.modules as cmodules
    from core.colors import bc as bc


# ==========================
# Core START
# ==========================
config = core.config()
SPARTA_SYM = (config['TOOLS']['SPARTA_SYM'])

# logger = core.log()
# logger.debug('Starting module')
# ==========================
# Core END
# ==========================


# ==========================
# Log files, global variables, etc. START
# ==========================

# ==========================
# Log files, global variables, etc. end
# ==========================


# OPTIONS
class Options():
    """Main class for module."""

    Author = 'Thomas TJ (TTJ)'
    Name = 'SPARTA'
    Call = 'sparta'
    Modulename = 'pen_sparta'  # Filename
    Category = 'pentesting'
    Type = 'niptt'
    Version = '0.1'
    License = 'MIT'
    Description = 'SPARTA is a python GUI application which simplifies network infrastructure penetration testing.'
    Datecreation = '2017/02/01'
    Lastmodified = '2017/02/01'

    def __init__(self):
        """Define variables and show options on run."""
        self.show_all()

    def show_all(self):
        """Show all options.

        Sending main options to the core module modules.py for parsing.
        """
        cmodules.showModuleData(
            Options.Author,
            Options.Name,
            Options.Call,
            Options.Category,
            Options.Type,
            Options.Version,
            Options.Description,
            Options.License,
            Options.Datecreation,
            Options.Lastmodified
        )
# END OPTIONS


def run():
    """The main run function."""
    comm.runCommand(SPARTA_SYM, 'SPARTA')


def main():
    """The first function to run."""
    print('\n')
    print('\t   _____ ____  ___    ____  _________   ')
    print('\t  / ___// __ \/   |  / __ \/_  __/   |  ')
    print('\t  \__ \/ /_/ / /| | / /_/ / / / / /| |  ')
    print('\t ___/ / ____/ ___ |/ _, _/ / / / ___ |  ')
    print('\t/____/_/   /_/  |_/_/ |_| /_/ /_/  |_|  ')
    print('\n')
    print('\t' + bc.OKBLUE + 'CHECKING REQUIREMENTS' + bc.ENDC)
    comm.checkInstalled('python2')
    comm.checkInstalled(SPARTA_SYM)
    print('')
    run()


# For testing uncomment "main()", place module in root directory and run module with "python3 modulename.py"
# main()
