/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.process.win32;

import com.jpexs.helpers.ProgressListener;
import com.jpexs.process.Process;
import com.jpexs.process.win32.Win32ProcessTools;
import com.sun.jna.platform.win32.WinDef;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.Map;

public class Win32Process
implements Process {
    public String filePath;
    public String fileName;
    public BufferedImage icon;
    public WinDef.DWORD th32ProcessID;

    @Override
    public long getPid() {
        return this.th32ProcessID.longValue();
    }

    public Win32Process(String filePath, String fileName, BufferedImage icon, WinDef.DWORD th32ProcessID) {
        this.filePath = filePath;
        this.fileName = fileName;
        this.icon = icon;
        this.th32ProcessID = th32ProcessID;
    }

    @Override
    public String toString() {
        return new File(this.filePath).getName() + " (pid " + this.th32ProcessID.longValue() + ")";
    }

    @Override
    public int compareTo(Process o) {
        if (!(o instanceof Win32Process)) {
            return -1;
        }
        Win32Process p = (Win32Process)o;
        int ret = this.fileName.toLowerCase().compareTo(p.fileName.toLowerCase());
        if (ret == 0) {
            ret = this.th32ProcessID.intValue() - p.th32ProcessID.intValue();
        }
        return ret;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public BufferedImage getIcon() {
        return this.icon;
    }

    @Override
    public Map<Long, InputStream> search(byte[] ... data) {
        return this.search((ProgressListener)null, data);
    }

    @Override
    public Map<Long, InputStream> search(ProgressListener progListener, byte[] ... data) {
        return Win32ProcessTools.findBytesInProcessMemory(progListener, this.th32ProcessID, data);
    }
}

