/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.timeline;

import com.jpexs.decompiler.flash.gui.timeline.FrameSelectionListener;
import com.jpexs.decompiler.flash.gui.timeline.TimelinePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class TimelineTimePanel
extends JPanel
implements MouseListener {
    public static final Color borderColor = Color.black;
    public static final int lineLength = 3;
    public static final int lineTextSpace = 3;
    public static final Color fontColor = Color.black;
    public float fontSize = 10.0f;
    private int scrollOffset = 0;
    private int selectedFrame = -1;
    private final List<FrameSelectionListener> listeners = new ArrayList<FrameSelectionListener>();

    public TimelineTimePanel() {
        Dimension dim = new Dimension(Integer.MAX_VALUE, 18);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.addMouseListener(this);
    }

    public void addFrameSelectionListener(FrameSelectionListener l) {
        this.listeners.add(l);
    }

    public void removeFrameSelectionListener(FrameSelectionListener l) {
        this.listeners.remove(l);
    }

    public void frameSelect(int frame) {
        if (this.selectedFrame == frame) {
            return;
        }
        for (FrameSelectionListener l : this.listeners) {
            l.frameSelected(frame, -1);
        }
        this.selectedFrame = frame;
        this.repaint();
    }

    public void scroll(int offset) {
        this.scrollOffset = offset;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int f;
        Rectangle clip = g.getClipBounds();
        int start_f = (this.scrollOffset + clip.x) / 8;
        int end_f = (this.scrollOffset + clip.x + clip.width) / 8;
        g.setColor(TimelinePanel.getBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(borderColor);
        int xofs = 8 - this.scrollOffset % 8 - 1;
        for (f = 0; f <= end_f; ++f) {
            g.drawLine(xofs + f * 8 + 1, 17, xofs + f * 8 + 1, 15);
        }
        g.setFont(g.getFont().deriveFont(this.fontSize));
        for (f = 0; f <= end_f; ++f) {
            int cur_f = start_f + f;
            if (this.selectedFrame == cur_f) {
                g.setColor(TimelinePanel.selectedColor);
                g.fillRect(xofs + (f - 1) * 8 + 1, 0, 8, 17);
                g.setColor(TimelinePanel.selectedBorderColor);
                g.drawRect(xofs + (f - 1) * 8 + 1, 0, 8, 17);
            }
            g.setColor(fontColor);
            if ((cur_f + 1) % 5 != 0 && cur_f != 0) continue;
            String timeStr = Integer.toString(cur_f + 1);
            int w = g.getFontMetrics().stringWidth(timeStr);
            g.drawString(timeStr, xofs + (f - 1) * 8 + 4 - w / 2, 12);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.frameSelect((this.scrollOffset + e.getX()) / 8);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

