/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.proxy;

import com.jpexs.proxy.Replacement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SWFListModel
implements ListModel<Replacement> {
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    private final List<Replacement> replacements;

    public SWFListModel(List<Replacement> replacements) {
        this.replacements = replacements;
    }

    public Replacement removeURL(int index) {
        if (index == -1) {
            return null;
        }
        if (index < this.replacements.size()) {
            Replacement r = this.replacements.remove(index);
            for (ListDataListener l : this.listeners) {
                l.intervalRemoved(new ListDataEvent(this, 2, index, index));
            }
            return r;
        }
        return null;
    }

    public void dataChanged(int index) {
        if (index == -1) {
            return;
        }
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(new ListDataEvent(this, 0, index, index));
        }
    }

    public int indexOf(Replacement replacement) {
        for (int i = 0; i < this.replacements.size(); ++i) {
            if (this.replacements.get(i) != replacement) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        int size = this.replacements.size();
        if (size == 0) {
            return;
        }
        this.replacements.clear();
        for (ListDataListener l : this.listeners) {
            l.intervalRemoved(new ListDataEvent(this, 2, 0, size - 1));
        }
    }

    public boolean contains(String url) {
        for (Replacement r : this.replacements) {
            if (!r.matches(url)) continue;
            return true;
        }
        return false;
    }

    public void addURL(Replacement replacement) {
        int sizeBefore = this.replacements.size();
        this.replacements.add(replacement);
        for (ListDataListener l : this.listeners) {
            l.intervalAdded(new ListDataEvent(this, 1, sizeBefore, sizeBefore));
        }
    }

    @Override
    public int getSize() {
        return this.replacements.size();
    }

    @Override
    public Replacement getElementAt(int index) {
        return this.replacements.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }
}

