/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.gui.ComboBoxItem;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.helpers.ReflectionTools;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class EnumEditor
extends JComboBox<ComboBoxItem<Integer>>
implements GenericTagEditor {
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private final SWFType swfType;
    private String fieldName;
    private Map<Integer, String> values;

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public int getBaseline(int width, int height) {
        return 0;
    }

    @Override
    public void added() {
    }

    public EnumEditor(String fieldName, Object obj, Field field, int index, Class<?> type, SWFType swfType, Map<Integer, String> values) {
        this.setSize(100, this.getSize().height);
        this.setMaximumSize(this.getSize());
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.swfType = swfType;
        this.fieldName = fieldName;
        this.values = values;
        Object[] valuesArray = new Integer[values.size()];
        values.keySet().toArray(valuesArray);
        Arrays.sort(valuesArray);
        Object[] objectArray = valuesArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int value = (Integer)objectArray[i];
            this.addItem(new ComboBoxItem<Integer>(value + " - " + values.get(value), value));
        }
        this.reset();
    }

    @Override
    public void reset() {
        try {
            int value = (Integer)ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            this.setSelectedItem(this.values.get(value));
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    @Override
    public void save() {
        try {
            Object value = this.getChangedValue();
            if (value != null) {
                ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    private SpinnerModel getModel(SWFType swfType, Object value) {
        SpinnerNumberModel m = null;
        BasicType basicType = swfType == null ? BasicType.NONE : swfType.value();
        switch (basicType) {
            case UI8: {
                m = new SpinnerNumberModel(this.toInt(value), 0, 255, 1);
                break;
            }
            case UI16: {
                m = new SpinnerNumberModel(this.toInt(value), 0, 65535, 1);
                break;
            }
            case UB: {
                long max = 1L;
                max = swfType.count() > 0 ? (max <<= swfType.count()) : (max <<= 31);
                m = new SpinnerNumberModel((Number)this.toLong(value), Long.valueOf(0L), Long.valueOf(max - 1L), (Number)1L);
                break;
            }
            case UI32: 
            case EncodedU32: 
            case NONE: {
                m = new SpinnerNumberModel((Number)this.toLong(value), Long.valueOf(0L), Long.valueOf(0xFFFFFFFFL), (Number)1L);
                break;
            }
            case SI8: {
                m = new SpinnerNumberModel(this.toInt(value), -128, 127, 1);
                break;
            }
            case SI16: 
            case FLOAT16: {
                m = new SpinnerNumberModel(this.toInt(value), Short.MIN_VALUE, Short.MAX_VALUE, 1);
                break;
            }
            case FB: 
            case SB: {
                long max = 1L;
                max = swfType.count() > 0 ? (max <<= swfType.count() - 1) : (max <<= 30);
                m = new SpinnerNumberModel((Number)this.toLong(value), Long.valueOf(-max), Long.valueOf(max - 1L), (Number)1L);
                break;
            }
            case SI32: {
                m = new SpinnerNumberModel(this.toDouble(value), -2.147483648E9, 2.147483647E9, 1.0);
                break;
            }
            case FLOAT: 
            case FIXED: 
            case FIXED8: {
                m = new SpinnerNumberModel(this.toDouble(value), -2.147483648E9, 2.147483647E9, 0.01);
            }
        }
        return m;
    }

    private double toDouble(Object value) {
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return 0.0;
    }

    private int toInt(Object value) {
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    private long toLong(Object value) {
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final EnumEditor t = this;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public void validateValue() {
    }

    @Override
    public Object getChangedValue() {
        ComboBoxItem item = (ComboBoxItem)this.getSelectedItem();
        int value = (Integer)item.getValue();
        return value;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return this.getChangedValue().toString();
    }
}

