/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReflectionTools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Field;
import javax.swing.JButton;

public class BinaryDataEditor
extends JButton
implements GenericTagEditor {
    private final MainPanel mainPanel;
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private final String fieldName;
    private Object value;

    public BinaryDataEditor(MainPanel mainPanel, String fieldName, Object obj, Field field, int index, Class<?> type) {
        this.mainPanel = mainPanel;
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.fieldName = fieldName;
        this.setText(AppStrings.translate("button.replace"));
        this.addActionListener(this::buttonActionPerformed);
        this.reset();
    }

    @Override
    public void validateValue() {
    }

    @Override
    public void reset() {
        try {
            Object val = ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            if (val instanceof byte[]) {
                byte[] ba = (byte[])val;
                this.setToolTipText(ba.length + " bytes");
            } else if (val instanceof ByteArrayRange) {
                ByteArrayRange bar = (ByteArrayRange)val;
                this.setToolTipText(bar.getLength() + " bytes");
            }
            this.value = val;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    private void buttonActionPerformed(ActionEvent evt) {
        File selectedFile = this.mainPanel.showImportFileChooser("");
        if (selectedFile != null) {
            File selfile = Helper.fixDialogFile((File)selectedFile);
            byte[] data = Helper.readFile((String[])new String[]{selfile.getAbsolutePath()});
            this.setToolTipText(data.length + " bytes");
            Class<?> type = this.field.getType();
            if (type.equals(byte[].class)) {
                this.value = data;
            } else if (type.equals(ByteArrayRange.class)) {
                this.value = new ByteArrayRange(data);
            }
        }
    }

    @Override
    public void save() {
        try {
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)this.value);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final BinaryDataEditor t = this;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public Object getChangedValue() {
        return this.value;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return this.getChangedValue().toString();
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public int getBaseline(int width, int height) {
        return 0;
    }

    @Override
    public void added() {
    }
}

