/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;

public class MyMarkers {
    public static void removeMarkers(JTextComponent component, Highlighter.HighlightPainter marker) {
        Highlighter hilite = component.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        for (int i = 0; i < hilites.length; ++i) {
            Highlighter.HighlightPainter hMarker = hilites[i].getPainter();
            if (marker != null && !hMarker.equals(marker)) continue;
            hilite.removeHighlight(hilites[i]);
        }
    }

    public static void removeMarkers(JTextComponent editorPane) {
        MyMarkers.removeMarkers(editorPane, null);
    }

    public static void markToken(JTextComponent pane, Token token, Highlighter.HighlightPainter marker) {
        MyMarkers.markText(pane, token.start, token.end(), marker);
    }

    public static void markText(JTextComponent pane, int start, int end, Highlighter.HighlightPainter marker) {
        try {
            Highlighter hiliter = pane.getHighlighter();
            int selStart = pane.getSelectionStart();
            int selEnd = pane.getSelectionEnd();
            if (selStart == selEnd || end < selStart || start > selStart) {
                hiliter.addHighlight(start, end, marker);
                return;
            }
            if (selStart > start && selStart < end) {
                hiliter.addHighlight(start, selStart, marker);
            }
            if (selEnd > start && selEnd < end) {
                hiliter.addHighlight(selEnd, end, marker);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void markAll(JTextComponent pane, Pattern pattern, Highlighter.HighlightPainter marker) {
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument((JTextComponent)pane);
        if (sDoc == null || pattern == null) {
            return;
        }
        Matcher matcher = sDoc.getMatcher(pattern);
        if (matcher == null) {
            return;
        }
        while (matcher.find()) {
            MyMarkers.markText(pane, matcher.start(), matcher.end(), marker);
        }
    }
}

