/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.controls;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class JRepeatButton
extends JButton {
    final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private int repeatCount;

    public JRepeatButton(String text, ImageIcon icon) {
        super(text, icon);
        this.addMouseListener(new MouseAdapter(){
            ScheduledFuture<?> future;

            @Override
            public void mousePressed(final MouseEvent e) {
                JRepeatButton.this.repeatCount = 0;
                Runnable runnable = new Runnable(){
                    private int cnt = 0;

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(() -> {
                            ++this.cnt;
                            JRepeatButton button = JRepeatButton.this;
                            JRepeatButton.this.repeatCount = this.cnt;
                            JRepeatButton.this.fireActionPerformed(new ActionEvent(button, 1001, button.getActionCommand(), e.getWhen(), e.getModifiers()));
                        });
                    }
                };
                this.future = JRepeatButton.this.executor.scheduleAtFixedRate(runnable, 200L, 200L, TimeUnit.MILLISECONDS);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.future != null) {
                    this.future.cancel(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.future != null) {
                    this.future.cancel(true);
                }
            }
        });
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }
}

