/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc.tablemodels;

import com.jpexs.decompiler.flash.abc.ABC;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MultinameTableModel
implements TableModel {
    private final ABC abc;
    private static final String[] columnNames = new String[]{"Index", "Kind", "Name", "Namespace", "NamespaceSet"};
    private static final Class[] classes = new Class[]{Long.class, String.class, String.class, String.class, String.class};

    public MultinameTableModel(ABC abc) {
        this.abc = abc;
    }

    @Override
    public int getRowCount() {
        if (this.abc == null) {
            return 0;
        }
        return this.abc.constants.getMultinameCount();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return classes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return rowIndex;
            }
            case 1: {
                if (rowIndex == 0) {
                    return "";
                }
                return this.abc.constants.getMultiname(rowIndex).getKindStr();
            }
            case 2: {
                if (rowIndex == 0) {
                    return "";
                }
                if (this.abc.constants.getMultiname((int)rowIndex).name_index == -1) {
                    return "";
                }
                return this.abc.constants.getMultiname(rowIndex).getName(this.abc.constants, null, true, true);
            }
            case 3: {
                if (rowIndex == 0) {
                    return "";
                }
                if (this.abc.constants.getMultiname((int)rowIndex).namespace_index <= 0) {
                    return "-";
                }
                return this.abc.constants.getMultiname(rowIndex).getNamespace(this.abc.constants).getNameWithKind(this.abc.constants);
            }
            case 4: {
                if (rowIndex == 0) {
                    return "";
                }
                if (this.abc.constants.getMultiname((int)rowIndex).namespace_set_index <= 0) {
                    return "-";
                }
                return this.abc.constants.getMultiname(rowIndex).getNamespaceSet(this.abc.constants).toString(this.abc.constants);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

