/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.debugger.flash.Variable;
import com.jpexs.debugger.flash.messages.in.InGetVariable;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.Reference;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.abc.usages.MultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.TraitMultinameUsage;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.script.ActionScriptLexer;
import com.jpexs.decompiler.flash.action.parser.script.ParsedSymbol;
import com.jpexs.decompiler.flash.action.parser.script.SymbolType;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.DebugPanel;
import com.jpexs.decompiler.flash.gui.DebuggerHandler;
import com.jpexs.decompiler.flash.gui.HeaderLabel;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.SearchListener;
import com.jpexs.decompiler.flash.gui.SearchPanel;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.abc.ABCPanelSearchResult;
import com.jpexs.decompiler.flash.gui.abc.ClassesListTreeModel;
import com.jpexs.decompiler.flash.gui.abc.DecompiledEditorPane;
import com.jpexs.decompiler.flash.gui.abc.DetailPanel;
import com.jpexs.decompiler.flash.gui.abc.NewTraitDialog;
import com.jpexs.decompiler.flash.gui.abc.TraitsList;
import com.jpexs.decompiler.flash.gui.abc.UsageFrame;
import com.jpexs.decompiler.flash.gui.abc.tablemodels.DecimalTableModel;
import com.jpexs.decompiler.flash.gui.abc.tablemodels.DoubleTableModel;
import com.jpexs.decompiler.flash.gui.abc.tablemodels.IntTableModel;
import com.jpexs.decompiler.flash.gui.abc.tablemodels.MultinameTableModel;
import com.jpexs.decompiler.flash.gui.abc.tablemodels.NamespaceSetTableModel;
import com.jpexs.decompiler.flash.gui.abc.tablemodels.NamespaceTableModel;
import com.jpexs.decompiler.flash.gui.abc.tablemodels.StringTableModel;
import com.jpexs.decompiler.flash.gui.abc.tablemodels.UIntTableModel;
import com.jpexs.decompiler.flash.gui.controls.JPersistentSplitPane;
import com.jpexs.decompiler.flash.gui.editor.LinkHandler;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeModel;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceException;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceExceptionItem;
import com.jpexs.decompiler.flash.importers.As3ScriptReplacerInterface;
import com.jpexs.decompiler.flash.importers.FFDecAs3ScriptReplacer;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import de.hameister.treetable.MyTreeTable;
import de.hameister.treetable.MyTreeTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import javax.swing.border.BevelBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Highlighter;
import javax.swing.tree.TreePath;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;

public class ABCPanel
extends JPanel
implements ItemListener,
SearchListener<ABCPanelSearchResult>,
TagEditorPanel {
    private As3ScriptReplacerInterface scriptReplacer = null;
    private ScriptPack pack = null;
    private final MainPanel mainPanel;
    public final TraitsList navigator;
    public ABC abc;
    public final DecompiledEditorPane decompiledTextArea;
    public final JScrollPane decompiledScrollPane;
    private final JPersistentSplitPane splitPane;
    private final JTable constantTable;
    public JComboBox<String> constantTypeList;
    public JLabel asmLabel = new HeaderLabel(AppStrings.translate("panel.disassembled"));
    public JLabel decLabel = new HeaderLabel(AppStrings.translate("panel.decompiled"));
    public final DetailPanel detailPanel;
    private final JPanel navPanel;
    public final JTabbedPane tabbedPane;
    public final SearchPanel<ABCPanelSearchResult> searchPanel;
    private NewTraitDialog newTraitDialog;
    public final JLabel scriptNameLabel;
    private final DebugPanel debugPanel;
    private final JLabel experimentalLabel = new JLabel(AppStrings.translate("action.edit.experimental"));
    private final JButton editDecompiledButton = new JButton(AppStrings.translate("button.edit.script.decompiled"), View.getIcon("edit16"));
    private final JButton saveDecompiledButton = new JButton(AppStrings.translate("button.save"), View.getIcon("save16"));
    private final JButton cancelDecompiledButton = new JButton(AppStrings.translate("button.cancel"), View.getIcon("cancel16"));
    private String lastDecompiled = null;

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public List<ABCPanelSearchResult> search(SWF swf, String txt, boolean ignoreCase, boolean regexp, boolean pcode, CancellableWorker<Void> worker) {
        ArrayList ignoredClasses = new ArrayList();
        ArrayList ignoredNss = new ArrayList();
        if (((Boolean)Configuration._ignoreAdditionalFlexClasses.get()).booleanValue()) {
            this.abc.getSwf().getFlexMainClass(ignoredClasses, ignoredNss);
        }
        if (txt != null && !txt.isEmpty()) {
            this.searchPanel.setOptions(ignoreCase, regexp);
            TagTreeModel ttm = this.mainPanel.tagTree.getModel();
            TreeItem scriptsNode = ttm.getScriptsNode(swf);
            ArrayList<ABCPanelSearchResult> found = new ArrayList<ABCPanelSearchResult>();
            if (scriptsNode instanceof ClassesListTreeModel) {
                ClassesListTreeModel clModel = (ClassesListTreeModel)scriptsNode;
                List<ScriptPack> allpacks = clModel.getList();
                Pattern pat = regexp ? Pattern.compile(txt, ignoreCase ? 66 : 0) : Pattern.compile(Pattern.quote(txt), ignoreCase ? 66 : 0);
                int pos = 0;
                block2: for (ScriptPack pack : allpacks) {
                    ++pos;
                    if (!pack.isSimple && ((Boolean)Configuration.ignoreCLikePackages.get()).booleanValue()) continue;
                    if (((Boolean)Configuration._ignoreAdditionalFlexClasses.get()).booleanValue()) {
                        String fullName = pack.getClassPath().packageStr.add(pack.getClassPath().className, pack.getClassPath().namespaceSuffix).toRawString();
                        if (ignoredClasses.contains(fullName)) continue;
                        for (String ns : ignoredNss) {
                            if (!fullName.startsWith(ns + ".")) continue;
                            continue block2;
                        }
                    }
                    String workText = AppStrings.translate("work.searching");
                    String decAdd = "";
                    if (!SWF.isCached((ScriptPack)pack)) {
                        decAdd = ", " + AppStrings.translate("work.decompiling");
                    }
                    Main.startWork(workText + " \"" + txt + "\"" + decAdd + " - (" + pos + "/" + allpacks.size() + ") " + pack.getClassPath().toString() + "... ", worker);
                    try {
                        if (!pat.matcher(SWF.getCached((ScriptPack)pack).text).find()) continue;
                        ABCPanelSearchResult searchResult = new ABCPanelSearchResult(pack);
                        found.add(searchResult);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            return found;
        }
        return null;
    }

    public void setAbc(ABC abc) {
        if (abc == this.abc) {
            return;
        }
        this.abc = abc;
        this.setDecompiledEditMode(false);
        this.navigator.setAbc(abc);
        this.updateConstList();
    }

    public void updateConstList() {
        switch (this.constantTypeList.getSelectedIndex()) {
            case 0: {
                View.autoResizeColWidth(this.constantTable, new UIntTableModel(this.abc));
                break;
            }
            case 1: {
                View.autoResizeColWidth(this.constantTable, new IntTableModel(this.abc));
                break;
            }
            case 2: {
                View.autoResizeColWidth(this.constantTable, new DoubleTableModel(this.abc));
                break;
            }
            case 3: {
                View.autoResizeColWidth(this.constantTable, new DecimalTableModel(this.abc));
                break;
            }
            case 4: {
                View.autoResizeColWidth(this.constantTable, new StringTableModel(this.abc));
                break;
            }
            case 5: {
                View.autoResizeColWidth(this.constantTable, new NamespaceTableModel(this.abc));
                break;
            }
            case 6: {
                View.autoResizeColWidth(this.constantTable, new NamespaceSetTableModel(this.abc));
                break;
            }
            case 7: {
                View.autoResizeColWidth(this.constantTable, new MultinameTableModel(this.abc));
            }
        }
    }

    public SWF getSwf() {
        return this.abc == null ? null : this.abc.getSwf();
    }

    public List<ABCContainerTag> getAbcList() {
        SWF swf = this.getSwf();
        return swf == null ? null : swf.getAbcList();
    }

    public void clearSwf() {
        this.abc = null;
        this.constantTable.setModel(new DefaultTableModel());
        this.navigator.clearAbc();
        this.decompiledTextArea.clearScript();
    }

    public static Long varToObjectId(Variable var) {
        if (var != null && var.vType == 3) {
            return (Long)var.value;
        }
        return 0L;
    }

    public ABCPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.setLayout(new BorderLayout());
        this.decompiledTextArea = new DecompiledEditorPane(this);
        this.decompiledTextArea.addTextChangedListener(this::decompiledTextAreaTextChanged);
        this.decompiledTextArea.setLinkHandler(new LinkHandler(){

            @Override
            public boolean isLink(Token token) {
                return ABCPanel.this.hasDeclaration(token.start);
            }

            @Override
            public void handleLink(Token token) {
                ABCPanel.this.gotoDeclaration(token.start);
            }

            @Override
            public Highlighter.HighlightPainter linkPainter() {
                return ABCPanel.this.decompiledTextArea.linkPainter();
            }
        });
        this.searchPanel = new SearchPanel<ABCPanelSearchResult>((LayoutManager)new FlowLayout(), this);
        this.decompiledScrollPane = new JScrollPane(this.decompiledTextArea);
        JPanel iconDecPanel = new JPanel();
        iconDecPanel.setLayout(new BoxLayout(iconDecPanel, 1));
        JPanel iconsPanel = new JPanel();
        iconsPanel.setLayout(new BoxLayout(iconsPanel, 0));
        JButton newTraitButton = new JButton(View.getIcon("traitadd16"));
        newTraitButton.setMargin(new Insets(5, 5, 5, 5));
        newTraitButton.addActionListener(this::addTraitButtonActionPerformed);
        newTraitButton.setToolTipText(AppStrings.translate("button.addtrait"));
        iconsPanel.add(newTraitButton);
        this.scriptNameLabel = new JLabel("-");
        this.scriptNameLabel.setAlignmentX(0.0f);
        iconsPanel.setAlignmentX(0.0f);
        this.decompiledScrollPane.setAlignmentX(0.0f);
        iconDecPanel.add(this.scriptNameLabel);
        iconDecPanel.add(iconsPanel);
        iconDecPanel.add(this.decompiledScrollPane);
        final JPanel decButtonsPan = new JPanel(new FlowLayout());
        decButtonsPan.setBorder(new BevelBorder(0));
        decButtonsPan.add(this.editDecompiledButton);
        decButtonsPan.add(this.experimentalLabel);
        decButtonsPan.add(this.saveDecompiledButton);
        decButtonsPan.add(this.cancelDecompiledButton);
        this.editDecompiledButton.setMargin(new Insets(3, 3, 3, 10));
        this.saveDecompiledButton.setMargin(new Insets(3, 3, 3, 10));
        this.cancelDecompiledButton.setMargin(new Insets(3, 3, 3, 10));
        this.saveDecompiledButton.addActionListener(this::saveDecompiledButtonActionPerformed);
        this.editDecompiledButton.addActionListener(this::editDecompiledButtonActionPerformed);
        this.cancelDecompiledButton.addActionListener(this::cancelDecompiledButtonActionPerformed);
        this.saveDecompiledButton.setVisible(false);
        this.cancelDecompiledButton.setVisible(false);
        decButtonsPan.setAlignmentX(0.0f);
        JPanel decPanel = new JPanel(new BorderLayout());
        decPanel.add(this.searchPanel, "North");
        decPanel.add((Component)iconDecPanel, "Center");
        decPanel.add((Component)decButtonsPan, "South");
        this.detailPanel = new DetailPanel(this);
        JPanel panB = new JPanel();
        panB.setLayout(new BorderLayout());
        panB.add((Component)this.decLabel, "North");
        Main.getDebugHandler().addConnectionListener(new DebuggerHandler.ConnectionListener(){

            @Override
            public void connected() {
                decButtonsPan.setVisible(false);
            }

            @Override
            public void disconnected() {
                decButtonsPan.setVisible(true);
            }
        });
        this.debugPanel = new DebugPanel();
        JPersistentSplitPane sp2 = new JPersistentSplitPane(0, decPanel, (Component)this.debugPanel, (ConfigurationItem<Double>)Configuration.guiAvm2VarsSplitPaneDividerLocationPercent);
        panB.add((Component)sp2, "Center");
        sp2.setContinuousLayout(true);
        this.debugPanel.setVisible(false);
        this.decLabel.setHorizontalAlignment(0);
        this.splitPane = new JPersistentSplitPane(1, panB, (Component)this.detailPanel, (ConfigurationItem<Double>)Configuration.guiAvm2SplitPaneDividerLocationPercent);
        this.splitPane.setContinuousLayout(true);
        this.decompiledTextArea.changeContentType("text/actionscript");
        this.decompiledTextArea.setFont(Configuration.getSourceFont());
        View.addEditorAction(this.decompiledTextArea, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int multinameIndex = ABCPanel.this.decompiledTextArea.getMultinameUnderCaret();
                if (multinameIndex > -1) {
                    UsageFrame usageFrame = new UsageFrame(ABCPanel.this.abc, multinameIndex, ABCPanel.this, false);
                    usageFrame.setVisible(true);
                }
            }
        }, "find-usages", AppStrings.translate("abc.action.find-usages"), "control U");
        View.addEditorAction(this.decompiledTextArea, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ABCPanel.this.gotoDeclaration(ABCPanel.this.decompiledTextArea.getCaretPosition());
            }
        }, "find-declaration", AppStrings.translate("abc.action.find-declaration"), "control B");
        CtrlClickHandler cch = new CtrlClickHandler();
        this.decompiledTextArea.addKeyListener(cch);
        this.decompiledTextArea.addMouseListener(cch);
        this.decompiledTextArea.addMouseMotionListener(cch);
        this.navigator = new TraitsList(this);
        this.navPanel = new JPanel(new BorderLayout());
        JPanel navIconsPanel = new JPanel();
        navIconsPanel.setLayout(new BoxLayout(navIconsPanel, 0));
        final JToggleButton sortButton = new JToggleButton(View.getIcon("sort16"));
        sortButton.setMargin(new Insets(3, 3, 3, 3));
        navIconsPanel.add(sortButton);
        this.navPanel.add((Component)navIconsPanel, "South");
        this.navPanel.add((Component)new JScrollPane(this.navigator), "Center");
        sortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ABCPanel.this.navigator.setSorted(sortButton.isSelected());
                ABCPanel.this.navigator.updateUI();
            }
        });
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(AppStrings.translate("traits"), this.navPanel);
        this.add((Component)this.splitPane, "Center");
        JPanel panConstants = new JPanel();
        panConstants.setLayout(new BorderLayout());
        this.constantTypeList = new JComboBox<String>(new String[]{"UINT", "INT", "DOUBLE", "DECIMAL", "STRING", "NAMESPACE", "NAMESPACESET", "MULTINAME"});
        this.constantTable = new JTable();
        if (this.abc != null) {
            View.autoResizeColWidth(this.constantTable, new UIntTableModel(this.abc));
        }
        this.constantTable.setAutoCreateRowSorter(true);
        final ABCPanel t = this;
        this.constantTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ABCPanel.this.constantTypeList.getSelectedIndex() == 7) {
                    int rowIndex = ABCPanel.this.constantTable.getSelectedRow();
                    if (rowIndex == -1) {
                        return;
                    }
                    int multinameIndex = ABCPanel.this.constantTable.convertRowIndexToModel(rowIndex);
                    if (multinameIndex > 0) {
                        UsageFrame usageFrame = new UsageFrame(ABCPanel.this.abc, multinameIndex, t, false);
                        usageFrame.setVisible(true);
                    }
                }
            }
        });
        this.constantTypeList.addItemListener(this);
        panConstants.add(this.constantTypeList, "North");
        panConstants.add((Component)new JScrollPane(this.constantTable), "Center");
        this.tabbedPane.addTab(AppStrings.translate("constants"), panConstants);
    }

    private void decompiledTextAreaTextChanged() {
        this.setModified(true);
    }

    private boolean isModified() {
        return this.saveDecompiledButton.isVisible() && this.saveDecompiledButton.isEnabled();
    }

    private void setModified(boolean value) {
        this.saveDecompiledButton.setEnabled(value);
        this.cancelDecompiledButton.setEnabled(value);
    }

    private boolean hasDeclaration(int pos) {
        Token t;
        if (this.decompiledTextArea == null) {
            return false;
        }
        SyntaxDocument sd = (SyntaxDocument)this.decompiledTextArea.getDocument();
        Token currentChartoken = sd.getTokenAt(pos);
        Token nextChartoken = sd.getTokenAt(pos + 1);
        Token token = t = currentChartoken != null && currentChartoken.length == 1 ? currentChartoken : nextChartoken;
        if (t == null || t.type != TokenType.IDENTIFIER && t.type != TokenType.KEYWORD && t.type != TokenType.REGEX) {
            return false;
        }
        Reference abcIndex = new Reference((Object)0);
        Reference classIndex = new Reference((Object)0);
        Reference traitIndex = new Reference((Object)0);
        Reference multinameIndexRef = new Reference((Object)0);
        Reference classTrait = new Reference((Object)false);
        if (this.decompiledTextArea.getPropertyTypeAtPos(pos, (Reference<Integer>)abcIndex, (Reference<Integer>)classIndex, (Reference<Integer>)traitIndex, (Reference<Boolean>)classTrait, (Reference<Integer>)multinameIndexRef)) {
            return true;
        }
        int multinameIndex = this.decompiledTextArea.getMultinameAtPos(pos);
        if (multinameIndex > -1) {
            if (multinameIndex == 0) {
                return false;
            }
            List usages = this.abc.findMultinameDefinition(multinameIndex);
            Multiname m = this.abc.constants.getMultiname(multinameIndex);
            if (m.getSingleNamespaceIndex(this.abc.constants) > 0 && this.abc.constants.getNamespace((int)m.getSingleNamespaceIndex((AVM2ConstantPool)this.abc.constants)).kind != 5) {
                for (ABCContainerTag at : this.getAbcList()) {
                    int mid;
                    ABC a = at.getABC();
                    if (a == this.abc || (mid = a.constants.getMultinameId(m, this.abc.constants)) <= 0) continue;
                    usages.addAll(a.findMultinameDefinition(mid));
                }
            }
            if (!usages.isEmpty()) {
                return true;
            }
        }
        return this.decompiledTextArea.getLocalDeclarationOfPos(pos, (Reference<DottedChain>)new Reference(null)) != -1;
    }

    private void gotoDeclaration(int pos) {
        int dpos;
        Reference multinameIndexRef;
        Reference classTrait;
        Reference traitIndex;
        Reference classIndex;
        Reference abcIndex = new Reference((Object)0);
        if (this.decompiledTextArea.getPropertyTypeAtPos(pos, (Reference<Integer>)abcIndex, (Reference<Integer>)(classIndex = new Reference((Object)0)), (Reference<Integer>)(traitIndex = new Reference((Object)0)), (Reference<Boolean>)(classTrait = new Reference((Object)false)), (Reference<Integer>)(multinameIndexRef = new Reference((Object)0)))) {
            UsageFrame.gotoUsage(this, (MultinameUsage)new TraitMultinameUsage(this.getAbcList().get((Integer)abcIndex.getVal()).getABC(), (Integer)multinameIndexRef.getVal(), this.decompiledTextArea.getScriptLeaf().scriptIndex, (Integer)classIndex.getVal(), (Integer)traitIndex.getVal(), (Boolean)classTrait.getVal() != false ? 1 : 2, null, -1){});
            return;
        }
        int multinameIndex = this.decompiledTextArea.getMultinameAtPos(pos);
        if (multinameIndex > -1) {
            List usages = this.abc.findMultinameDefinition(multinameIndex);
            Multiname m = this.abc.constants.getMultiname(multinameIndex);
            if (m.getSingleNamespaceIndex(this.abc.constants) > 0 && m.getSingleNamespace((AVM2ConstantPool)this.abc.constants).kind != 5) {
                for (ABCContainerTag at : this.getAbcList()) {
                    int mid;
                    ABC a = at.getABC();
                    if (a == this.abc || (mid = a.constants.getMultinameId(m, this.abc.constants)) <= 0) continue;
                    usages.addAll(a.findMultinameDefinition(mid));
                }
            }
            if (usages.size() > 1) {
                UsageFrame usageFrame = new UsageFrame(this.abc, multinameIndex, this, true);
                usageFrame.setVisible(true);
                return;
            }
            if (!usages.isEmpty()) {
                UsageFrame.gotoUsage(this, (MultinameUsage)usages.get(0));
                return;
            }
        }
        if ((dpos = this.decompiledTextArea.getLocalDeclarationOfPos(pos, (Reference<DottedChain>)new Reference(null))) > -1) {
            this.decompiledTextArea.setCaretPosition(dpos);
        }
    }

    public void reload() {
        this.lastDecompiled = "";
        SWF swf = this.getSwf();
        if (swf != null) {
            swf.clearScriptCache();
        }
        this.decompiledTextArea.reloadClass();
        this.detailPanel.methodTraitPanel.methodCodePanel.clear();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.constantTypeList) {
            int index = ((JComboBox)e.getSource()).getSelectedIndex();
            if (index == -1) {
                return;
            }
            this.updateConstList();
        }
    }

    public void display() {
        this.setVisible(true);
    }

    public void hilightScript(SWF swf, String name) {
        TagTreeModel ttm = this.mainPanel.tagTree.getModel();
        TreeItem scriptsNode = ttm.getScriptsNode(swf);
        if (scriptsNode instanceof ClassesListTreeModel) {
            ClassesListTreeModel clModel = (ClassesListTreeModel)scriptsNode;
            ScriptPack pack = null;
            for (ScriptPack item : clModel.getList()) {
                if (!item.isSimple && ((Boolean)Configuration.ignoreCLikePackages.get()).booleanValue()) continue;
                ClassPath classPath = item.getClassPath();
                if (!name.endsWith(classPath.className + classPath.namespaceSuffix) || !classPath.toRawString().equals(name)) continue;
                pack = item;
                break;
            }
            if (pack != null) {
                this.hilightScript(pack);
            }
        }
    }

    public void hilightScript(ScriptPack pack) {
        TagTreeModel ttm = this.mainPanel.tagTree.getModel();
        TreePath tp0 = ttm.getTreePath((TreeItem)pack);
        if (tp0 == null) {
            this.mainPanel.closeTagTreeSearch();
            tp0 = ttm.getTreePath((TreeItem)pack);
        }
        TreePath tp = tp0;
        View.execInEventDispatchLater(() -> {
            this.mainPanel.tagTree.setSelectionPath(tp);
            this.mainPanel.tagTree.scrollPathToVisible(tp);
        });
    }

    @Override
    public void updateSearchPos(ABCPanelSearchResult item) {
        ScriptPack pack = item.getScriptPack();
        this.setAbc(pack.abc);
        this.decompiledTextArea.setScript(pack, false);
        this.hilightScript(pack);
        this.decompiledTextArea.setCaretPosition(0);
        View.execInEventDispatchLater(() -> this.searchPanel.showQuickFindDialog(this.decompiledTextArea));
    }

    public boolean isDirectEditing() {
        return this.saveDecompiledButton.isVisible() && this.saveDecompiledButton.isEnabled();
    }

    public void setDecompiledEditMode(final boolean val) {
        View.execInEventDispatch(new Runnable(){

            @Override
            public void run() {
                if (val) {
                    ABCPanel.this.lastDecompiled = ABCPanel.this.decompiledTextArea.getText();
                } else {
                    ABCPanel.this.decompiledTextArea.setText(ABCPanel.this.lastDecompiled);
                }
                ABCPanel.this.decompiledTextArea.setEditable(val);
                ABCPanel.this.saveDecompiledButton.setVisible(val);
                ABCPanel.this.saveDecompiledButton.setEnabled(false);
                ABCPanel.this.editDecompiledButton.setVisible(!val);
                ABCPanel.this.experimentalLabel.setVisible(!val);
                ABCPanel.this.cancelDecompiledButton.setVisible(val);
                ABCPanel.this.decompiledTextArea.getCaret().setVisible(true);
                ABCPanel.this.decLabel.setIcon(val ? View.getIcon("editing16") : null);
                ABCPanel.this.detailPanel.setVisible(!val);
                ABCPanel.this.decompiledTextArea.ignoreCarret = val;
                ABCPanel.this.decompiledTextArea.requestFocusInWindow();
            }
        });
    }

    private void editDecompiledButtonActionPerformed(ActionEvent evt) {
        this.scriptReplacer = this.mainPanel.getAs3ScriptReplacer();
        if (this.scriptReplacer == null) {
            return;
        }
        if (View.showConfirmDialog(null, AppStrings.translate("message.confirm.experimental.function"), AppStrings.translate("message.warning"), 2, 2, (ConfigurationItem<Boolean>)Configuration.warningExperimentalAS3Edit, 0) == 0) {
            this.pack = this.decompiledTextArea.getScriptLeaf();
            this.setDecompiledEditMode(true);
            SwingWorker initReplaceWorker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    ABCPanel.this.scriptReplacer.initReplacement(ABCPanel.this.pack);
                    return null;
                }
            };
            initReplaceWorker.execute();
        }
    }

    private void cancelDecompiledButtonActionPerformed(ActionEvent evt) {
        this.setDecompiledEditMode(false);
        if (this.scriptReplacer != null) {
            this.scriptReplacer.deinitReplacement(this.pack);
        }
    }

    private void saveDecompiledButtonActionPerformed(ActionEvent evt) {
        int oldIndex = this.pack.scriptIndex;
        SWF.uncache((ScriptPack)this.pack);
        try {
            String oldSp = this.pack.getClassPath().toRawString();
            String as = this.decompiledTextArea.getText();
            this.abc.replaceScriptPack(this.scriptReplacer, this.pack, as);
            this.scriptReplacer.deinitReplacement(this.pack);
            this.lastDecompiled = as;
            this.setDecompiledEditMode(false);
            this.mainPanel.updateClassesList();
            if (oldSp != null) {
                this.hilightScript(this.getSwf(), oldSp);
            }
            this.reload();
            View.showMessageDialog(this, AppStrings.translate("message.action.saved"), AppStrings.translate("dialog.message.title"), 1, (ConfigurationItem<Boolean>)Configuration.showCodeSavedMessage);
        }
        catch (As3ScriptReplaceException asre) {
            StringBuilder sb = new StringBuilder();
            int firstErrorLine = -1;
            int firstErrorCol = -1;
            String firstErrorText = null;
            ((ScriptInfo)this.abc.script_info.get(oldIndex)).delete(this.abc, false);
            for (As3ScriptReplaceExceptionItem item : asre.getExceptionItems()) {
                if (firstErrorLine == -1) {
                    firstErrorLine = item.getLine();
                    firstErrorCol = item.getCol();
                }
                if (firstErrorText == null) {
                    firstErrorText = item.getMessage();
                }
                sb.append(item.getFile()).append(":").append(item.getLine()).append(" (column ").append(item.getCol()).append(")").append(":").append("\n");
                sb.append("  ").append(item.getMessage());
                sb.append("\n");
                sb.append("\n");
            }
            if (firstErrorLine != -1) {
                if (firstErrorCol != -1) {
                    this.decompiledTextArea.gotoLineCol(firstErrorLine, firstErrorCol);
                } else {
                    this.decompiledTextArea.gotoLine(firstErrorLine);
                }
                this.decompiledTextArea.markError();
            }
            if (this.scriptReplacer instanceof FFDecAs3ScriptReplacer) {
                View.showMessageDialog(this, AppStrings.translate("error.action.save").replace("%error%", firstErrorText).replace("%line%", Long.toString(firstErrorLine)), AppStrings.translate("error"), 0);
            } else {
                View.showMessageDialog(this, sb.toString(), AppStrings.translate("error"), 0);
            }
            this.decompiledTextArea.requestFocus();
        }
        catch (Throwable ex) {
            Logger.getLogger(ABCPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addTraitButtonActionPerformed(ActionEvent evt) {
        Multiname m;
        boolean isStatic;
        int kind;
        int class_index = this.decompiledTextArea.getClassIndex();
        if (class_index < 0) {
            return;
        }
        if (this.newTraitDialog == null) {
            this.newTraitDialog = new NewTraitDialog();
        }
        int void_type = this.abc.constants.getPublicQnameId("void", true);
        int int_type = this.abc.constants.getPublicQnameId("int", true);
        TraitSlotConst t = null;
        String name = null;
        boolean again = false;
        block4: do {
            if (again) {
                View.showMessageDialog(null, AppStrings.translate("error.trait.exists").replace("%name%", name), AppStrings.translate("error"), 0);
            }
            again = false;
            if (this.newTraitDialog.showDialog() != 0) {
                return;
            }
            kind = this.newTraitDialog.getTraitType();
            int nskind = this.newTraitDialog.getNamespaceKind();
            name = this.newTraitDialog.getTraitName();
            isStatic = this.newTraitDialog.getStatic();
            m = Multiname.createQName((boolean)false, (int)this.abc.constants.getStringId(name, true), (int)this.abc.constants.getNamespaceId(nskind, "", 0, true));
            int mid = this.abc.constants.getMultinameId(m, false);
            if (mid <= 0) break;
            for (Trait tr : ((ClassInfo)this.abc.class_info.get((int)class_index)).static_traits.traits) {
                if (tr.name_index != mid) continue;
                again = true;
                break;
            }
            for (Trait tr : ((InstanceInfo)this.abc.instance_info.get((int)class_index)).instance_traits.traits) {
                if (tr.name_index != mid) continue;
                again = true;
                continue block4;
            }
        } while (again);
        switch (kind) {
            case 1: 
            case 2: 
            case 3: {
                int method_info;
                TraitMethodGetterSetter tm = new TraitMethodGetterSetter();
                MethodInfo mi = new MethodInfo(new int[0], void_type, this.abc.constants.getStringId(name, true), 0, new ValueKind[0], new int[0]);
                tm.method_info = method_info = this.abc.addMethodInfo(mi);
                MethodBody body = new MethodBody(this.abc, new Traits(), new byte[0], new ABCException[0]);
                body.method_info = method_info;
                body.init_scope_depth = 1;
                body.max_regs = 1;
                body.max_scope_depth = 1;
                body.max_stack = 1;
                body.exceptions = new ABCException[0];
                AVM2Code code = new AVM2Code();
                code.code.add(new AVM2Instruction(0L, 208, null));
                code.code.add(new AVM2Instruction(0L, 48, null));
                code.code.add(new AVM2Instruction(0L, 71, null));
                body.setCode(code);
                Traits traits = new Traits();
                traits.traits = new ArrayList();
                body.traits = traits;
                this.abc.addMethodBody(body);
                t = tm;
                break;
            }
            case 0: 
            case 6: {
                TraitSlotConst ts = new TraitSlotConst();
                ts.type_index = int_type;
                ts.value_kind = 3;
                ts.value_index = this.abc.constants.getIntId(0L, true);
                t = ts;
            }
        }
        if (t != null) {
            t.kindType = kind;
            t.name_index = this.abc.constants.getMultinameId(m, true);
            int traitId = isStatic ? ((ClassInfo)this.abc.class_info.get((int)class_index)).static_traits.addTrait((Trait)t) : ((ClassInfo)this.abc.class_info.get((int)class_index)).static_traits.traits.size() + ((InstanceInfo)this.abc.instance_info.get((int)class_index)).instance_traits.addTrait((Trait)t);
            int scriptIndex = this.decompiledTextArea.getScriptLeaf().scriptIndex;
            if (scriptIndex >= 0 && scriptIndex < this.abc.script_info.size()) {
                ((ScriptInfo)this.abc.script_info.get(scriptIndex)).setModified(true);
            }
            ((Tag)this.abc.parentTag).setModified(true);
            this.reload();
            this.decompiledTextArea.gotoTrait(traitId);
        }
    }

    @Override
    public boolean tryAutoSave() {
        return false;
    }

    @Override
    public boolean isEditing() {
        return this.detailPanel.isEditing() || this.isModified();
    }

    private class CtrlClickHandler
    extends KeyAdapter
    implements MouseListener,
    MouseMotionListener {
        private boolean ctrlDown = false;

        private CtrlClickHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 17 && !ABCPanel.this.decompiledTextArea.isEditable()) {
                this.ctrlDown = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                this.ctrlDown = false;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.ctrlDown && e.getButton() == 1 && e.getClickCount() == 1 && !ABCPanel.this.decompiledTextArea.isEditable()) {
                this.ctrlDown = false;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.ctrlDown = false;
            ABCPanel.this.decompiledTextArea.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.ctrlDown && ABCPanel.this.decompiledTextArea.isEditable()) {
                this.ctrlDown = false;
                ABCPanel.this.decompiledTextArea.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public static class VariablesTableModel
    implements MyTreeTableModel {
        List<TableModelListener> tableListeners = new ArrayList<TableModelListener>();
        VariableNode root;
        private final Map<VariableNode, List<VariableNode>> nodeCache = new HashMap<VariableNode, List<VariableNode>>();
        protected EventListenerList listenerList = new EventListenerList();
        private static final int CHANGED = 0;
        private static final int INSERTED = 1;
        private static final int REMOVED = 2;
        private static final int STRUCTURE_CHANGED = 3;
        private final MyTreeTable ttable;
        private static final int COLUMN_NAME = 0;
        private static final int COLUMN_TRAIT = 1;
        private static final int COLUMN_SCOPE = 2;
        private static final int COLUMN_FLAGS = 3;
        private static final int COLUMN_TYPE = 4;
        private static final int COLUMN_VALUE = 5;

        public VariablesTableModel(MyTreeTable ttable, List<Variable> vars, List<Long> parentIds) {
            this.ttable = ttable;
            ArrayList<VariableNode> childs = new ArrayList<VariableNode>();
            for (int i = 0; i < vars.size(); ++i) {
                childs.add(new VariableNode(new ArrayList<VariableNode>(), 1, vars.get(i), 0L, null));
            }
            this.root = new VariableNode(new ArrayList<VariableNode>(), 0, null, 0L, null, childs);
        }

        public int getColumnCount() {
            return 6;
        }

        public Variable getVarAt(Object node) {
            if (node == this.root) {
                return null;
            }
            return ((VariableNode)node).var;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return AppStrings.translate("variables.column.name");
                }
                case 2: {
                    return AppStrings.translate("variables.column.scope");
                }
                case 3: {
                    return AppStrings.translate("variables.column.flags");
                }
                case 4: {
                    return AppStrings.translate("variables.column.type");
                }
                case 5: {
                    return AppStrings.translate("variables.column.value");
                }
                case 1: {
                    return AppStrings.translate("variables.column.trait");
                }
            }
            return null;
        }

        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return MyTreeTableModel.class;
            }
            return String.class;
        }

        private String flagsToScopeString(int flags) {
            int scope = flags & 0x3800000;
            switch (scope) {
                case 0x800000: {
                    return "private";
                }
                case 0x1000000: {
                    return "protected";
                }
                case 0: {
                    return "public";
                }
                case 0x2000000: {
                    return "namespace";
                }
                case 0x1800000: {
                    return "internal";
                }
            }
            return "?";
        }

        private String flagsToString(int flags) {
            Integer[] unknownFlags = new Integer[]{2, 8, 16, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
            ArrayList<String> flagsStr = new ArrayList<String>();
            if ((flags & 1) > 0) {
                flagsStr.add("dontEnumerate");
            }
            for (Integer f : unknownFlags) {
                if ((flags & f) <= 0) continue;
                flagsStr.add("unk" + f);
            }
            if ((flags & 0x80000) > 0) {
                flagsStr.add("get");
            }
            if ((flags & 0x100000) > 0) {
                flagsStr.add("set");
            }
            if ((flags & 4) > 0) {
                flagsStr.add("readonly");
            }
            if ((flags & 0x400000) > 0) {
                flagsStr.add("const");
            }
            if ((flags & 0x20000) > 0) {
                flagsStr.add("dynamic");
            }
            if ((flags & 0x4000000) > 0) {
                flagsStr.add("class");
            }
            if ((flags & 0x10000) > 0) {
                flagsStr.add("argument");
            }
            if ((flags & 0x40000) > 0) {
                flagsStr.add("exception");
            }
            if ((flags & 0x20) > 0) {
                flagsStr.add("local");
            }
            if ((flags & 0x200000) > 0) {
                flagsStr.add("static");
            }
            return String.join((CharSequence)", ", flagsStr);
        }

        public Object getValueAt(Object node, int columnIndex) {
            if (node == this.root) {
                if (columnIndex == 0) {
                    return "root";
                }
                return "";
            }
            Variable var = ((VariableNode)node).var;
            Variable var_getter = ((VariableNode)node).varInsideGetter;
            Variable trait = ((VariableNode)node).trait;
            boolean readOnly = (var.flags & 4) > 0;
            boolean hasGetter = (var.flags & 0x80000) > 0;
            boolean hasSetter = (var.flags & 0x100000) > 0;
            boolean onlySetter = hasSetter && !hasGetter;
            Variable val = var;
            if (var_getter != null) {
                val = var_getter;
            }
            switch (columnIndex) {
                case 0: {
                    return var.name;
                }
                case 2: {
                    return this.flagsToScopeString(var.flags);
                }
                case 3: {
                    return this.flagsToString(var.flags);
                }
                case 4: {
                    String typeStr = val.getTypeAsStr();
                    if ("Object".equals(typeStr)) {
                        typeStr = val.className;
                    }
                    if ("Object".equals(typeStr)) {
                        typeStr = val.typeName;
                    }
                    return typeStr;
                }
                case 5: {
                    switch (val.vType) {
                        case 3: 
                        case 4: 
                        case 5: {
                            return var.getTypeAsStr() + "(" + val.value + ")";
                        }
                        case 2: {
                            return "\"" + Helper.escapeActionScriptString((String)("" + val.value)) + "\"";
                        }
                    }
                    return EcmaScript.toString((Object)val.value);
                }
                case 1: {
                    if (trait != null) {
                        return trait.name;
                    }
                    return "";
                }
            }
            return null;
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0 || column == 5 && node != this.root && ((VariableNode)node).var.isPrimitive;
        }

        public void setValueAt(Object aValue, Object node, int column) {
            int valType;
            ParsedSymbol symb;
            ActionScriptLexer lexer = new ActionScriptLexer((Reader)new StringReader("" + aValue));
            try {
                symb = lexer.lex();
                ParsedSymbol f = lexer.yylex();
                if (f.type != SymbolType.EOF) {
                    return;
                }
            }
            catch (ActionParseException | IOException ex) {
                return;
            }
            switch (symb.type) {
                case DOUBLE: {
                    valType = 0;
                    break;
                }
                case INTEGER: {
                    valType = 0;
                    break;
                }
                case NULL: {
                    valType = 6;
                    break;
                }
                case STRING: {
                    valType = 2;
                    break;
                }
                case UNDEFINED: {
                    valType = 7;
                    break;
                }
                default: {
                    return;
                }
            }
            Main.getDebugHandler().setVariable(((VariableNode)node).parentObjectId, ((VariableNode)node).var.name, valType, symb.value);
            Object[] path = new Object[((VariableNode)node).path.size()];
            for (int i = 0; i < path.length; ++i) {
                path[i] = ((VariableNode)node).path.get(i);
            }
            this.valueForPathChanged(new TreePath(path), aValue);
        }

        public Object getRoot() {
            return this.root;
        }

        public Object getChild(Object parent, int index) {
            return ((VariableNode)parent).getChildAt(index);
        }

        public int getChildCount(Object parent) {
            int cnt = ((VariableNode)parent).getChildCount();
            return cnt;
        }

        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
            this.fireTreeNodesChanged(this.ttable, path.getParentPath().getPath(), new int[0], new Object[]{path.getLastPathComponent()});
        }

        public int getIndexOfChild(Object parent, Object child) {
            int cnt = this.getChildCount(parent);
            for (int i = 0; i < cnt; ++i) {
                if (this.getChild(parent, i) != child) continue;
                return i;
            }
            return -1;
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.fireTreeNode(0, source, path, childIndices, children);
        }

        protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.fireTreeNode(1, source, path, childIndices, children);
        }

        protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.fireTreeNode(2, source, path, childIndices, children);
        }

        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.fireTreeNode(3, source, path, childIndices, children);
        }

        private void fireTreeNode(int changeType, Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
            block6: for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                switch (changeType) {
                    case 0: {
                        ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
                        continue block6;
                    }
                    case 1: {
                        ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
                        continue block6;
                    }
                    case 2: {
                        ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
                        continue block6;
                    }
                    case 3: {
                        ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
                        continue block6;
                    }
                }
            }
        }
    }

    public static class VariableNode {
        public List<VariableNode> path = new ArrayList<VariableNode>();
        public Variable var;
        public Variable varInsideGetter;
        public Long parentObjectId;
        public int level;
        public Variable trait;
        public long traitId;
        private List<VariableNode> childs;
        public boolean loaded = false;

        public int hashCode() {
            int hash = 3;
            hash = 53 * hash + Objects.hashCode(this.parentObjectId);
            hash = 53 * hash + (this.var == null ? 0 : Objects.hashCode(this.var.name));
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableNode other = (VariableNode)obj;
            if (!Objects.equals(this.parentObjectId, other.parentObjectId)) {
                return false;
            }
            if (this.var == null && other.var == null) {
                return true;
            }
            if (this.var == null) {
                return false;
            }
            if (other.var == null) {
                return false;
            }
            return Objects.equals(this.var.name, other.var.name);
        }

        private static boolean isTraits(Variable v) {
            return v.vType == 8 && "traits".equals(v.typeName);
        }

        public String toString() {
            if (this.level == 0) {
                return "root";
            }
            return this.var.name;
        }

        private void refresh() {
            if (this.path.size() > 1) {
                this.path.get(this.path.size() - 2).reloadChildren();
            }
        }

        private void reloadChildren() {
            this.childs = new ArrayList<VariableNode>();
            if ("".equals(this.var.name)) {
                return;
            }
            Long objectId = ABCPanel.varToObjectId(this.varInsideGetter);
            InGetVariable igv = this.parentObjectId == 0L && objectId != 0L ? Main.getDebugHandler().getVariable(objectId, "", true) : Main.getDebugHandler().getVariable(this.parentObjectId, this.var.name, true);
            this.varInsideGetter = igv.parent;
            Variable curTrait = null;
            for (int i = 0; i < igv.childs.size(); ++i) {
                if (!VariableNode.isTraits((Variable)igv.childs.get(i))) {
                    Long parentObjectId = ABCPanel.varToObjectId(this.var);
                    this.childs.add(new VariableNode(this.path, this.level + 1, (Variable)igv.childs.get(i), parentObjectId, curTrait));
                    continue;
                }
                curTrait = (Variable)igv.childs.get(i);
            }
        }

        private void ensureLoaded() {
            if (!this.loaded) {
                this.reloadChildren();
                this.loaded = true;
            }
        }

        public VariableNode getChildAt(int index) {
            this.ensureLoaded();
            return this.childs.get(index);
        }

        public int getChildCount() {
            this.ensureLoaded();
            return this.childs.size();
        }

        public VariableNode(List<VariableNode> parentPath, int level, Variable var, Long parentObjectId, Variable trait) {
            this.var = var;
            this.parentObjectId = parentObjectId;
            this.level = level;
            this.trait = trait;
            this.path.addAll(parentPath);
            this.path.add(this);
            this.loaded = false;
        }

        public VariableNode(List<VariableNode> parentPath, int level, Variable var, Long parentObjectId, Variable trait, List<VariableNode> subvars) {
            this.var = var;
            this.parentObjectId = parentObjectId;
            this.level = level;
            this.trait = trait;
            this.childs = subvars;
            this.path.addAll(parentPath);
            this.path.add(this);
            for (VariableNode vn : subvars) {
                vn.path.clear();
                vn.path.addAll(this.path);
                vn.path.add(vn);
            }
            this.loaded = true;
        }
    }
}

