/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.tags.TagInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TagInfoPanel
extends JPanel {
    private final MainPanel mainPanel;
    private final JTable infoTable = new JTable();
    private TagInfo tagInfo = new TagInfo();

    public TagInfoPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.infoTable.setModel(new InfoTableModel("general"));
        this.setLayout(new BorderLayout());
        this.infoTable.setAutoCreateRowSorter(true);
        JLabel topLabel = new JLabel(AppStrings.translate("taginfo.header"), 0);
        this.add((Component)topLabel, "North");
        this.add((Component)new JScrollPane(this.infoTable), "Center");
    }

    public void setTagInfos(TagInfo tagInfo) {
        this.tagInfo = tagInfo;
        this.infoTable.setBackground(Color.WHITE);
        this.infoTable.setModel(new InfoTableModel("general"));
    }

    private class InfoTableModel
    implements TableModel {
        private final String categoryName;

        public InfoTableModel(String categoryName) {
            this.categoryName = categoryName;
        }

        @Override
        public int getRowCount() {
            List category = (List)TagInfoPanel.this.tagInfo.getInfos().get(this.categoryName);
            if (category != null) {
                return category.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return TagInfoPanel.this.mainPanel.translate("tagInfo.header.name");
                }
                case 1: {
                    return TagInfoPanel.this.mainPanel.translate("tagInfo.header.value");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            List category = (List)TagInfoPanel.this.tagInfo.getInfos().get(this.categoryName);
            if (category == null) return null;
            TagInfo.TagInfoItem item = (TagInfo.TagInfoItem)category.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    String name = item.getName();
                    String key = "tagInfo." + name;
                    try {
                        return TagInfoPanel.this.mainPanel.translate(key);
                    }
                    catch (MissingResourceException mes) {
                        if ((Boolean)Configuration._debugMode.get() == false) return name;
                        Logger.getLogger(TagInfoPanel.class.getName()).log(Level.WARNING, "Resource not found: {0}", key);
                    }
                    return name;
                }
                case 1: {
                    Object value = item.getValue();
                    if (!(value instanceof Boolean)) return "" + value;
                    boolean boolValue = (Boolean)value;
                    return boolValue ? AppStrings.translate("yes") : AppStrings.translate("no");
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

