/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.SearchListener;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SearchResultsDialog<E>
extends AppDialog {
    private final JList<E> resultsList;
    private final DefaultListModel<E> model;
    private final SearchListener<E> listener;
    private final JButton gotoButton = new JButton(this.translate("button.goto"));
    private final JButton closeButton = new JButton(this.translate("button.close"));

    public SearchResultsDialog(Window owner, String text, SearchListener<E> listener) {
        super(owner);
        this.setTitle(this.translate("dialog.title").replace("%text%", text));
        Container cnt = this.getContentPane();
        this.model = new DefaultListModel();
        this.resultsList = new JList<E>(this.model);
        this.listener = listener;
        this.gotoButton.addActionListener(this::gotoButtonActionPerformed);
        this.closeButton.addActionListener(this::closeButtonActionPerformed);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(this.gotoButton);
        buttonsPanel.add(this.closeButton);
        this.resultsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SearchResultsDialog.this.gotoElement();
                }
            }
        });
        this.resultsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SearchResultsDialog.this.gotoElement();
                }
            }
        });
        cnt.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.resultsList);
        sp.setPreferredSize(new Dimension(300, 300));
        cnt.add((Component)sp, "Center");
        cnt.add((Component)buttonsPanel, "South");
        this.pack();
        View.centerScreen(this);
        View.setWindowIcon(this);
    }

    public void setResults(List<E> results) {
        this.model.clear();
        for (E e : results) {
            this.model.addElement(e);
        }
    }

    private void gotoButtonActionPerformed(ActionEvent evt) {
        this.gotoElement();
        this.setVisible(false);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void gotoElement() {
        if (this.resultsList.getSelectedIndex() != -1) {
            View.execInEventDispatchLater(() -> this.listener.updateSearchPos(this.resultsList.getSelectedValue()));
        }
    }
}

