/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.Version;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class NewVersionDialog
extends AppDialog {
    private Version latestVersion;

    public NewVersionDialog(List<Version> versions) {
        this.setSize(new Dimension(500, 300));
        Container cnt = this.getContentPane();
        cnt.setLayout(new BoxLayout(cnt, 3));
        JEditorPane changesText = new JEditorPane();
        changesText.setEditable(false);
        changesText.setFont(UIManager.getFont("TextField.font"));
        SimpleDateFormat serverFormatter = new SimpleDateFormat("MM/dd/yyyy");
        String customFormat = this.translate("customDateFormat");
        DateFormat formatter = customFormat.equals("default") ? DateFormat.getDateInstance() : new SimpleDateFormat(customFormat);
        StringBuilder changesStr = new StringBuilder();
        changesStr.append("<html>");
        boolean first = true;
        for (Version v : versions) {
            if (!first) {
                changesStr.append("<hr />");
            }
            first = false;
            changesStr.append("<b>").append(this.translate("version")).append(" ").append(v.versionName).append("</b><br />");
            String releaseDate = v.releaseDate;
            try {
                Date date = serverFormatter.parse(releaseDate);
                releaseDate = formatter.format(date);
            }
            catch (ParseException ex) {
                Logger.getLogger(NewVersionDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
            changesStr.append(this.translate("releasedate")).append(" ").append(releaseDate);
            if (v.changes.isEmpty()) continue;
            changesStr.append("<br />");
            changesStr.append("<pre>");
            for (String type : v.changes.keySet()) {
                changesStr.append(type).append(":<br />");
                for (String ch : (List)v.changes.get(type)) {
                    changesStr.append(" - ").append(ch).append("<br />");
                }
            }
            changesStr.append("</pre>");
        }
        changesStr.append("</html>");
        this.latestVersion = null;
        if (!versions.isEmpty()) {
            this.latestVersion = versions.get(0);
        }
        changesText.setContentType("text/html");
        changesText.setText(changesStr.toString());
        if (this.latestVersion != null) {
            JLabel newAvailableLabel = new JLabel("<html><b><center>" + this.translate("newversionavailable") + " " + this.latestVersion.appName + " " + this.translate("version") + " " + this.latestVersion.versionName + "</center></b></html>", 0);
            newAvailableLabel.setAlignmentX(0.5f);
            cnt.add(newAvailableLabel);
        }
        JLabel changeslogLabel = new JLabel("<html>" + this.translate("changeslog") + "</html>");
        changeslogLabel.setAlignmentX(0.5f);
        cnt.add(changeslogLabel);
        JScrollPane span = new JScrollPane(changesText);
        span.setAlignmentX(0.5f);
        cnt.add(span);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton buttonOk = new JButton(this.translate("button.ok"));
        buttonOk.addActionListener(this::okButtonActionPerformed);
        JButton buttonCancel = new JButton(this.translate("button.cancel"));
        buttonCancel.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(buttonOk);
        buttonsPanel.add(buttonCancel);
        buttonsPanel.setAlignmentX(0.5f);
        JLabel downloadNowLabel = new JLabel("<html><b><center>" + this.translate("downloadnow") + "</center></b></html>", 0);
        downloadNowLabel.setAlignmentX(0.5f);
        cnt.add(downloadNowLabel);
        cnt.add(buttonsPanel);
        this.setResizable(false);
        this.setTitle(this.translate("dialog.title"));
        this.getRootPane().setDefaultButton(buttonOk);
        View.centerScreen(this);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        changesText.setCaretPosition(0);
        View.setWindowIcon(this);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String url = this.latestVersion.updateLink != null ? this.latestVersion.updateLink : ApplicationInfo.updateUrl;
        if (View.navigateUrl(url)) {
            Main.exit();
        } else {
            View.showMessageDialog(null, this.translate("newvermessage").replace("%oldAppName%", "FFDec").replace("%newAppName%", this.latestVersion.appName).replace("%projectPage%", "https://www.free-decompiler.com/flash"), this.translate("newversion"), 1);
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

