/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.Stage;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.gui.SoundTagPlayer;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.MediaDisplayListener;
import com.jpexs.decompiler.flash.gui.player.Zoom;
import com.jpexs.decompiler.flash.tags.DefineButtonSoundTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.ConstantColorColorTransform;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.Stopwatch;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class ImagePanel
extends JPanel
implements MediaDisplay {
    private static final Logger logger = Logger.getLogger(ImagePanel.class.getName());
    private final List<MediaDisplayListener> listeners = new ArrayList<MediaDisplayListener>();
    private Timelined timelined;
    private boolean stillFrame = false;
    private volatile Timer timer;
    private int frame = -1;
    private boolean loop;
    private LocalDataArea lda;
    private boolean zoomAvailable = false;
    private SWF swf;
    private boolean loaded;
    private int mouseButton;
    private final JLabel debugLabel = new JLabel("-");
    private Point cursorPosition = null;
    private MouseEvent lastMouseEvent = null;
    private final List<SoundTagPlayer> soundPlayers = new ArrayList<SoundTagPlayer>();
    private final Cache<PlaceObjectTypeTag, SerializableImage> displayObjectCache = Cache.getInstance((boolean)false, (boolean)false, (String)"displayObject");
    private final IconPanel iconPanel;
    private int time = 0;
    private int selectedDepth = -1;
    private Zoom zoom = new Zoom();
    private final Object delayObject = new Object();
    private boolean drawReady;
    private final int drawWaitLimit = 50;
    private TextTag textTag;
    private TextTag newTextTag;
    private int msPerFrame;
    private final boolean lowQuality = false;
    private final double LQ_FACTOR = 2.0;
    private long startRun = 0L;
    private final long startDrop = 0L;
    private int skippedFrames = 0;
    private float fpsShouldBe = 0.0f;
    private float fpsIs = 0.0f;
    private Timer fpsTimer;
    private int startFrame = 0;

    public synchronized void selectDepth(int depth) {
        if (depth != this.selectedDepth) {
            this.selectedDepth = depth;
        }
        this.hideMouseSelection();
    }

    public void fireMediaDisplayStateChanged() {
        for (MediaDisplayListener l : this.listeners) {
            l.mediaDisplayStateChanged(this);
        }
    }

    @Override
    public void addEventListener(MediaDisplayListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(MediaDisplayListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setBackground(Color bg) {
        if (this.iconPanel != null) {
            this.iconPanel.setBackground(bg);
        }
        super.setBackground(bg);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.iconPanel.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.iconPanel.removeMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.iconPanel.addMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.iconPanel.removeMouseMotionListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updatePos(Timelined timelined, MouseEvent lastMouseEvent, Timer thisTimer) {
        if (timelined == null) return;
        Timelined bounded = timelined;
        RECT rect = bounded.getRect();
        int width = rect.getWidth();
        double scale = 1.0;
        Matrix m = Matrix.getTranslateInstance((double)(-rect.Xmin), (double)(-rect.Ymin));
        m.scale(scale);
        Point p = lastMouseEvent == null ? null : lastMouseEvent.getPoint();
        Class<ImagePanel> clazz = ImagePanel.class;
        synchronized (ImagePanel.class) {
            if (this.timer != thisTimer) return;
            this.cursorPosition = p;
            // ** MonitorExit[var11_10] (shouldn't be in output)
            return;
        }
    }

    private void showSelectedName() {
        CharacterTag cht;
        DepthState ds;
        if (this.selectedDepth > -1 && this.frame > -1 && (ds = (DepthState)this.timelined.getTimeline().getFrame((int)this.frame).layers.get(this.selectedDepth)) != null && (cht = this.timelined.getTimeline().swf.getCharacter(ds.characterId)) != null) {
            this.debugLabel.setText(cht.getName());
        }
    }

    public void hideMouseSelection() {
        if (this.selectedDepth > -1) {
            this.showSelectedName();
        } else {
            this.debugLabel.setText(" - ");
        }
    }

    public ImagePanel() {
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(View.getDefaultBackgroundColor());
        this.loop = true;
        this.iconPanel = new IconPanel();
        this.add((Component)this.iconPanel, "Center");
        this.add((Component)this.debugLabel, "North");
        this.iconPanel.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseEntered(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseExited(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    ImagePanel.this.lastMouseEvent = null;
                    ImagePanel.this.hideMouseSelection();
                    ImagePanel.this.redraw();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    DefineButtonSoundTag sounds;
                    ImagePanel.this.mouseButton = e.getButton();
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    ButtonTag button = ImagePanel.this.iconPanel.mouseOverButton;
                    if (button != null && (sounds = button.getSounds()) != null && sounds.buttonSoundChar2 != 0) {
                        ImagePanel.this.playSound((SoundTag)ImagePanel.this.swf.getCharacter(sounds.buttonSoundChar2), sounds.buttonSoundInfo2, ImagePanel.this.timer);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    DefineButtonSoundTag sounds;
                    ImagePanel.this.mouseButton = 0;
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    ButtonTag button = ImagePanel.this.iconPanel.mouseOverButton;
                    if (button != null && (sounds = button.getSounds()) != null && sounds.buttonSoundChar3 != 0) {
                        ImagePanel.this.playSound((SoundTag)ImagePanel.this.swf.getCharacter(sounds.buttonSoundChar3), sounds.buttonSoundInfo3, ImagePanel.this.timer);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        this.iconPanel.addMouseMotionListener(new MouseMotionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseMoved(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDragged(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    private synchronized void redraw() {
        if (this.timer == null && this.timelined != null) {
            this.startTimer(this.timelined.getTimeline(), false);
        }
    }

    @Override
    public synchronized void zoom(Zoom zoom) {
        boolean modified;
        boolean bl = modified = this.zoom.value != zoom.value || this.zoom.fit != zoom.fit;
        if (modified) {
            this.zoom = zoom;
            this.displayObjectCache.clear();
            this.redraw();
            if (this.textTag != null) {
                this.setText(this.textTag, this.newTextTag);
            }
            this.fireMediaDisplayStateChanged();
        }
    }

    @Override
    public synchronized BufferedImage printScreen() {
        return this.iconPanel.getLastImage();
    }

    @Override
    public synchronized double getZoomToFit() {
        if (this.timelined != null) {
            double h2;
            double w2;
            RECT bounds = this.timelined.getRect();
            double w1 = (double)bounds.getWidth() / 20.0;
            double h1 = (double)bounds.getHeight() / 20.0;
            double h = h1 * (w2 = (double)this.getWidth()) / w1;
            double w = h > (h2 = (double)this.getHeight()) ? w1 * h2 / h1 : w2;
            if (w1 <= Double.MIN_NORMAL) {
                return 1.0;
            }
            return w / w1;
        }
        return 1.0;
    }

    @Override
    public synchronized boolean zoomAvailable() {
        return this.zoomAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimelined(Timelined drawable, final SWF swf, int frame) {
        Stage stage = new Stage(drawable){

            public void callFrame(int frame) {
                ImagePanel.this.executeFrame(frame);
            }

            public Object callFunction(long functionAddress, long functionLength, List<Object> args, Map<Integer, String> regNames, Object thisObj) {
                try {
                    SWFInputStream sis = new SWFInputStream(swf, swf.uncompressedData, functionAddress, (int)(functionAddress + functionLength));
                    return ImagePanel.this.execute(sis);
                }
                catch (IOException ex) {
                    Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
                    return Undefined.INSTANCE;
                }
            }

            public int getCurrentFrame() {
                return ImagePanel.this.getCurrentFrame();
            }

            public int getTotalFrames() {
                return ImagePanel.this.getTotalFrames();
            }

            public void gotoFrame(int frame) {
                ImagePanel.this.pause();
                ImagePanel.this.gotoFrame(frame);
            }

            public void gotoLabel(String label) {
            }

            public void pause() {
                ImagePanel.this.pause();
            }

            public void play() {
                ImagePanel.this.play();
            }

            public void trace(Object ... val) {
                for (Object o : val) {
                    System.out.println("trace:" + o.toString());
                }
            }
        };
        this.lda = new LocalDataArea(stage);
        Class<ImagePanel> clazz = ImagePanel.class;
        synchronized (ImagePanel.class) {
            this.stopInternal();
            if (drawable instanceof ButtonTag) {
                frame = ButtonTag.FRAME_UP;
            }
            this.displayObjectCache.clear();
            this.timelined = drawable;
            this.swf = swf;
            this.zoomAvailable = true;
            this.timer = null;
            if (frame > -1) {
                this.frame = frame;
                this.stillFrame = true;
            } else {
                this.frame = 0;
                this.stillFrame = false;
            }
            this.loaded = true;
            if (drawable.getTimeline().getFrameCount() == 0) {
                this.clearImagePanel();
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            this.time = 0;
            this.drawReady = false;
            this.redraw();
            this.play();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            clazz = this.delayObject;
            synchronized (clazz) {
                try {
                    this.delayObject.wait(50L);
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            clazz = ImagePanel.class;
            synchronized (ImagePanel.class) {
                if (!this.drawReady) {
                    this.clearImagePanel();
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                this.fireMediaDisplayStateChanged();
                return;
            }
        }
    }

    public synchronized void setImage(SerializableImage image) {
        this.lda = null;
        this.setBackground(View.getSwfBackgroundColor());
        this.clear();
        this.timelined = null;
        this.loaded = true;
        this.stillFrame = true;
        this.zoomAvailable = false;
        this.iconPanel.setImg(image);
        this.drawReady = true;
        this.fireMediaDisplayStateChanged();
    }

    public synchronized void setText(TextTag textTag, TextTag newTextTag) {
        this.setBackground(View.getSwfBackgroundColor());
        this.clear();
        this.lda = null;
        this.timelined = null;
        this.loaded = true;
        this.stillFrame = true;
        this.zoomAvailable = true;
        this.textTag = textTag;
        this.newTextTag = newTextTag;
        double zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
        RECT rect = textTag.getRect();
        int width = (int)((double)rect.getWidth() * zoomDouble);
        int height = (int)((double)rect.getHeight() * zoomDouble);
        SerializableImage image = new SerializableImage((int)((double)width / 20.0) + 1, (int)((double)height / 20.0) + 1, SerializableImage.TYPE_INT_ARGB);
        image.fillTransparent();
        Matrix m = Matrix.getTranslateInstance((double)((double)(-rect.Xmin) * zoomDouble), (double)((double)(-rect.Ymin) * zoomDouble));
        m.scale(zoomDouble);
        textTag.toImage(0, 0, 0, new RenderContext(), image, false, m, m, m, (ColorTransform)new ConstantColorColorTransform(-4144960));
        if (newTextTag != null) {
            newTextTag.toImage(0, 0, 0, new RenderContext(), image, false, m, m, m, (ColorTransform)new ConstantColorColorTransform(-16777216));
        }
        this.iconPanel.setImg(image);
        this.drawReady = true;
        this.fireMediaDisplayStateChanged();
    }

    private synchronized void clearImagePanel() {
        this.iconPanel.setImg(null);
    }

    @Override
    public synchronized int getCurrentFrame() {
        return this.frame;
    }

    @Override
    public synchronized int getTotalFrames() {
        if (this.timelined == null) {
            return 0;
        }
        if (this.stillFrame) {
            return 0;
        }
        return this.timelined.getTimeline().getFrameCount();
    }

    @Override
    public void pause() {
        this.stopInternal();
        this.redraw();
    }

    @Override
    public void stop() {
        this.stopInternal();
        this.rewind();
        this.redraw();
    }

    @Override
    public void close() throws IOException {
        this.stopInternal();
    }

    private void stopAllSounds() {
        for (int i = this.soundPlayers.size() - 1; i >= 0; --i) {
            SoundTagPlayer pl = this.soundPlayers.get(i);
            pl.close();
        }
        this.soundPlayers.clear();
    }

    private void clear() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.fireMediaDisplayStateChanged();
        }
        this.textTag = null;
        this.newTextTag = null;
        this.displayObjectCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextFrame(Timer thisTimer, int cnt, int timeShouldBe) {
        this.drawFrame(thisTimer, true);
        Class<ImagePanel> clazz = ImagePanel.class;
        synchronized (ImagePanel.class) {
            if (this.timelined != null && this.timer == thisTimer) {
                int frameCount = this.timelined.getTimeline().getFrameCount();
                int oldFrame = this.frame;
                for (int i = 0; i < cnt; ++i) {
                    if (!this.stillFrame && frameCount > 0) {
                        this.frame = (this.frame + 1) % frameCount;
                    }
                    if (!this.stillFrame && this.frame == frameCount - 1 && !this.loop) {
                        this.stopInternal();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                    if (i >= cnt - 1) continue;
                    this.drawFrame(thisTimer, false);
                }
                if (this.frame != oldFrame) {
                    if (this.frame == 0) {
                        this.stopAllSounds();
                    }
                    this.time = 0;
                } else {
                    this.time = timeShouldBe;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.fireMediaDisplayStateChanged();
            return;
        }
    }

    private static SerializableImage getFrame(SWF swf, int frame, int time, Timelined drawable, RenderContext renderContext, int selectedDepth, double zoom) {
        CharacterTag cht;
        Timeline timeline = drawable.getTimeline();
        RECT rect = drawable.getRect();
        int width = (int)((double)rect.getWidth() * zoom);
        int height = (int)((double)rect.getHeight() * zoom);
        SerializableImage image = new SerializableImage((int)Math.ceil((double)width / 20.0), (int)Math.ceil((double)height / 20.0), SerializableImage.TYPE_INT_ARGB);
        image.fillTransparent();
        Matrix m = new Matrix();
        m.translate((double)(-rect.Xmin) * zoom, (double)(-rect.Ymin) * zoom);
        m.scale(zoom);
        timeline.toImage(frame, time, renderContext, image, false, m, m, m, null);
        Graphics2D gg = (Graphics2D)image.getGraphics();
        gg.setStroke(new BasicStroke(3.0f));
        gg.setPaint(Color.green);
        gg.setTransform(AffineTransform.getTranslateInstance(0.0, 0.0));
        DepthState ds = null;
        if (timeline.getFrameCount() > frame) {
            ds = (DepthState)timeline.getFrame((int)frame).layers.get(selectedDepth);
        }
        if (ds != null && (cht = swf.getCharacter(ds.characterId)) != null && cht instanceof DrawableTag) {
            DrawableTag dt = (DrawableTag)cht;
            int drawableFrameCount = dt.getNumFrames();
            if (drawableFrameCount == 0) {
                drawableFrameCount = 1;
            }
            int dframe = time % drawableFrameCount;
            Shape outline = dt.getOutline(dframe, time, ds.ratio, renderContext, Matrix.getScaleInstance((double)0.05).concatenate(m.concatenate(new Matrix(ds.matrix))), true);
            Rectangle bounds = outline.getBounds();
            gg.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f));
            gg.setPaint(Color.red);
            gg.draw(bounds);
        }
        SerializableImage img = image;
        return img;
    }

    private Object execute(SWFInputStream sis) throws IOException {
        Action a;
        if (!((Boolean)Configuration.internalFlashViewerExecuteAs12.get()).booleanValue()) {
            return Undefined.INSTANCE;
        }
        if (this.lda == null) {
            return Undefined.INSTANCE;
        }
        long ip = sis.getPos();
        while ((a = sis.readAction()) != null) {
            int actionLengthWithHeader = a.getTotalActionLength();
            a.setAddress(ip);
            a.execute(this.lda);
            if (this.lda.returnValue != null) {
                return this.lda.returnValue;
            }
            if (this.lda.jump != null) {
                ip = this.lda.jump;
                this.lda.jump = null;
            } else {
                ip += (long)actionLengthWithHeader;
            }
            sis.seek(ip);
        }
        return Undefined.INSTANCE;
    }

    private void executeFrame(int frame) {
        if (!((Boolean)Configuration.internalFlashViewerExecuteAs12.get()).booleanValue()) {
            return;
        }
        if (this.timelined == null) {
            return;
        }
        Frame f = this.timelined.getTimeline().getFrame(frame);
        List actions = f.actions;
        if (this.lda != null) {
            this.lda.clear();
        }
        for (DoActionTag src : actions) {
            try {
                ByteArrayRange actionBytes = src.getActionBytes();
                int prevLength = actionBytes.getPos();
                SWFInputStream rri = new SWFInputStream(this.swf, actionBytes.getArray(), 0L, prevLength + actionBytes.getLength());
                if (prevLength != 0) {
                    rri.seek((long)prevLength);
                }
                this.execute(rri);
            }
            catch (IOException ex) {
                Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawFrame(Timer thisTimer, boolean display) {
        Class<ImagePanel> clazz = ImagePanel.class;
        synchronized (ImagePanel.class) {
            Timelined timelined = this.timelined;
            MouseEvent lastMouseEvent = this.lastMouseEvent;
            // ** MonitorExit[var12_3] (shouldn't be in output)
            clazz = ImagePanel.class;
            synchronized (ImagePanel.class) {
                SerializableImage img;
                int frame = this.frame;
                int time = this.time;
                Point cursorPosition = this.cursorPosition;
                if (cursorPosition != null) {
                    cursorPosition = this.iconPanel.toImagePoint(cursorPosition);
                }
                int mouseButton = this.mouseButton;
                int selectedDepth = this.selectedDepth;
                Zoom zoom = this.zoom;
                SWF swf = this.swf;
                // ** MonitorExit[var12_3] (shouldn't be in output)
                if (timelined == null) {
                    return;
                }
                RenderContext renderContext = new RenderContext();
                renderContext.displayObjectCache = this.displayObjectCache;
                if (cursorPosition != null) {
                    renderContext.cursorPosition = new Point((int)((double)cursorPosition.x * 20.0), (int)((double)cursorPosition.y * 20.0));
                }
                renderContext.mouseButton = mouseButton;
                renderContext.stateUnderCursor = new ArrayList();
                try {
                    CharacterTag c;
                    Timeline timeline = timelined.getTimeline();
                    if (frame >= timeline.getFrameCount()) {
                        return;
                    }
                    double zoomDouble = zoom.fit ? this.getZoomToFit() : zoom.value;
                    this.updatePos(timelined, lastMouseEvent, thisTimer);
                    Matrix mat = new Matrix();
                    mat.translateX = swf.displayRect.Xmin;
                    mat.translateY = swf.displayRect.Ymin;
                    img = null;
                    if (display) {
                        Stopwatch sw = Stopwatch.startNew();
                        img = ImagePanel.getFrame(swf, frame, time, timelined, renderContext, selectedDepth, zoomDouble);
                        sw.stop();
                        if (sw.getElapsedMilliseconds() > 100L) {
                            logger.log(Level.WARNING, "Slow rendering. {0}. frame, time={1}, {2}ms", new Object[]{frame, time, sw.getElapsedMilliseconds()});
                        }
                        if (renderContext.borderImage != null) {
                            img = renderContext.borderImage;
                        }
                    }
                    ArrayList<Integer> sounds = new ArrayList<Integer>();
                    ArrayList soundClasses = new ArrayList();
                    timeline.getSounds(frame, time, renderContext.mouseOverButton, mouseButton, sounds, soundClasses);
                    Iterator<Object> iterator = swf.getCharacters().keySet().iterator();
                    while (iterator.hasNext()) {
                        int cid = (Integer)iterator.next();
                        c = swf.getCharacter(cid);
                        for (String cls : soundClasses) {
                            if (!cls.equals(c.getClassName())) continue;
                            sounds.add(cid);
                        }
                    }
                    iterator = sounds.iterator();
                    while (iterator.hasNext()) {
                        int sndId = (Integer)iterator.next();
                        c = swf.getCharacter(sndId);
                        if (!(c instanceof SoundTag)) continue;
                        SoundTag st = (SoundTag)c;
                        this.playSound(st, null, thisTimer);
                    }
                    this.executeFrame(frame);
                }
                catch (Throwable ex) {
                    return;
                }
                if (!display) return;
                StringBuilder ret = new StringBuilder();
                if (cursorPosition != null) {
                    ret.append(" [").append(cursorPosition.x).append(",").append(cursorPosition.y).append("] : ");
                }
                boolean handCursor = renderContext.mouseOverButton != null;
                boolean first = true;
                for (int i = renderContext.stateUnderCursor.size() - 1; i >= 0; --i) {
                    DepthState ds = (DepthState)renderContext.stateUnderCursor.get(i);
                    if (!first) {
                        ret.append(", ");
                    }
                    first = false;
                    CharacterTag c = swf.getCharacter(ds.characterId);
                    ret.append(c.toString());
                }
                if (first) {
                    ret.append(" - ");
                }
                Class<ImagePanel> clazz2 = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    if (this.timer != thisTimer) return;
                    this.iconPanel.setImg(img);
                    ButtonTag lastMouseOverButton = this.iconPanel.mouseOverButton;
                    this.iconPanel.mouseOverButton = renderContext.mouseOverButton;
                    this.debugLabel.setText(ret.toString());
                    if (handCursor) {
                        this.iconPanel.setCursor(Cursor.getPredefinedCursor(12));
                    } else if (this.iconPanel.hasAllowMove()) {
                        this.iconPanel.setCursor(Cursor.getPredefinedCursor(13));
                    } else {
                        this.iconPanel.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    if (lastMouseOverButton != renderContext.mouseOverButton) {
                        DefineButtonSoundTag sounds;
                        ButtonTag b = renderContext.mouseOverButton;
                        if (b != null && (sounds = b.getSounds()) != null && sounds.buttonSoundChar1 != 0) {
                            this.playSound((SoundTag)swf.getCharacter(sounds.buttonSoundChar1), sounds.buttonSoundInfo1, this.timer);
                        }
                        if ((b = lastMouseOverButton) != null && (sounds = b.getSounds()) != null && sounds.buttonSoundChar0 != 0) {
                            this.playSound((SoundTag)swf.getCharacter(sounds.buttonSoundChar0), sounds.buttonSoundInfo0, this.timer);
                        }
                    }
                    this.drawReady = true;
                    Object object = this.delayObject;
                    synchronized (object) {
                        this.delayObject.notify();
                    }
                    // ** MonitorExit[var18_23] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playSound(SoundTag st, SOUNDINFO soundInfo, Timer thisTimer) {
        try {
            int loopCount = 1;
            if (soundInfo != null && soundInfo.hasLoops) {
                loopCount = Math.max(1, soundInfo.loopCount);
            }
            final SoundTagPlayer sp = new SoundTagPlayer(st, loopCount, false);
            sp.addEventListener(new MediaDisplayListener(){

                @Override
                public void mediaDisplayStateChanged(MediaDisplay source) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void playingFinished(MediaDisplay source) {
                    Class<ImagePanel> clazz = ImagePanel.class;
                    synchronized (ImagePanel.class) {
                        sp.close();
                        ImagePanel.this.soundPlayers.remove(sp);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            Class<ImagePanel> clazz = ImagePanel.class;
            synchronized (ImagePanel.class) {
                if (this.timer != null && this.timer == thisTimer) {
                    this.soundPlayers.add(sp);
                    sp.play();
                } else {
                    sp.close();
                }
                // ** MonitorExit[var6_7] (shouldn't be in output)
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
            logger.log(Level.SEVERE, "Error during playing sound", ex);
        }
        {
            return;
        }
    }

    public synchronized void clearAll() {
        this.stopInternal();
        this.clearImagePanel();
        this.timelined = null;
        this.swf = null;
        this.fireMediaDisplayStateChanged();
    }

    private synchronized void stopInternal() {
        this.clear();
        this.stopAllSounds();
    }

    @Override
    public synchronized void play() {
        this.stopInternal();
        if (this.timelined != null) {
            Timeline timeline = this.timelined.getTimeline();
            if (!this.stillFrame && this.frame == timeline.getFrameCount() - 1) {
                this.frame = 0;
            }
            this.startTimer(timeline, true);
        }
    }

    private synchronized void setMsPerFrame(int val) {
        this.msPerFrame = val;
    }

    private synchronized int getMsPerFrame() {
        return this.msPerFrame;
    }

    private synchronized void setFpsIs(float val) {
        this.fpsIs = val;
    }

    private synchronized float getFpsIs() {
        return this.fpsIs;
    }

    private synchronized void setSkippedFrames(int val) {
        this.skippedFrames = val;
    }

    private synchronized void addSkippedFrames(int val) {
        this.skippedFrames += val;
    }

    private synchronized int getSkippedFrames() {
        return this.skippedFrames;
    }

    private synchronized int getAndResetSkippedFrames() {
        int ret = this.skippedFrames;
        this.skippedFrames = 0;
        return ret;
    }

    private void scheduleTask(final boolean singleFrame, long msDelay) {
        TimerTask task = new TimerTask(){
            public final Timer thisTimer;
            public final boolean isSingleFrame;
            private long lastRun;
            {
                this.thisTimer = ImagePanel.this.timer;
                this.isSingleFrame = singleFrame;
                this.lastRun = 0L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    Class<ImagePanel> clazz = ImagePanel.class;
                    synchronized (ImagePanel.class) {
                        if (ImagePanel.this.timer != this.thisTimer) {
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        this.lastRun = System.currentTimeMillis();
                        int curFrame = ImagePanel.this.frame;
                        long delay = ImagePanel.this.getMsPerFrame();
                        if (this.isSingleFrame) {
                            ImagePanel.this.drawFrame(this.thisTimer, true);
                            Class<ImagePanel> clazz2 = ImagePanel.class;
                            synchronized (ImagePanel.class) {
                                this.thisTimer.cancel();
                                if (ImagePanel.this.timer == this.thisTimer) {
                                    ImagePanel.this.timer = null;
                                }
                                // ** MonitorExit[var4_6] (shouldn't be in output)
                                ImagePanel.this.fireMediaDisplayStateChanged();
                            }
                        } else {
                            long frameTimeMsIs = System.currentTimeMillis();
                            int frameCount = ImagePanel.this.timelined.getTimeline().getFrameCount();
                            int ticksFromStart = (int)Math.floor((double)(frameTimeMsIs - ImagePanel.this.startRun) / (double)ImagePanel.this.getMsPerFrame()) + 1;
                            int frameOverMaxShouldBeNow = ImagePanel.this.startFrame + ticksFromStart;
                            int frameShouldBeNow = frameOverMaxShouldBeNow % frameCount;
                            int skipFrames = frameShouldBeNow - curFrame;
                            if (skipFrames < 0) {
                                skipFrames += frameCount;
                            }
                            if (skipFrames > 1) {
                                ImagePanel.this.addSkippedFrames(skipFrames - 1);
                            }
                            int currentFrameTicks = 0;
                            if (frameCount == 1) {
                                currentFrameTicks = ticksFromStart;
                            }
                            ImagePanel.this.nextFrame(this.thisTimer, skipFrames, currentFrameTicks);
                            long afterDrawFrameTimeMsIs = System.currentTimeMillis();
                            int nextFrameOverMax = frameOverMaxShouldBeNow;
                            while (delay < 0L) {
                                long nextFrameOverMaxTimeMsShouldBe = ImagePanel.this.startRun + (long)(ImagePanel.this.getMsPerFrame() * ++nextFrameOverMax);
                                delay = nextFrameOverMaxTimeMsShouldBe - afterDrawFrameTimeMsIs;
                            }
                        }
                        {
                            ImagePanel.this.scheduleTask(this.isSingleFrame, delay);
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Frame drawing error", ex);
                }
            }
        };
        if (this.timer != null) {
            this.timer.schedule(task, msDelay);
        }
    }

    private synchronized void startTimer(Timeline timeline, boolean playing) {
        boolean singleFrame;
        this.startRun = System.currentTimeMillis();
        this.startFrame = this.frame;
        float frameRate = timeline.frameRate;
        this.setMsPerFrame(frameRate == 0.0f ? 1000 : (int)(1000.0 / (double)frameRate));
        boolean bl = singleFrame = !playing || this.stillFrame && timeline.isSingleFrame(this.frame) || !this.stillFrame && timeline.getRealFrameCount() <= 1 && timeline.isSingleFrame();
        if (this.fpsTimer == null) {
            this.fpsTimer = new Timer();
            this.fpsTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    float skipped = ImagePanel.this.getAndResetSkippedFrames();
                    ImagePanel.this.setFpsIs(ImagePanel.this.fpsShouldBe - skipped);
                }
            }, 1000L, 1000L);
        }
        this.timer = new Timer();
        this.fpsIs = this.fpsShouldBe = timeline.frameRate;
        this.scheduleTask(singleFrame, 0L);
    }

    @Override
    public synchronized void rewind() {
        this.frame = 0;
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public synchronized boolean isPlaying() {
        if (this.timelined == null || this.stillFrame) {
            return false;
        }
        return this.timelined.getTimeline().getFrameCount() <= 1 || this.timer != null;
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public synchronized void gotoFrame(int frame) {
        if (this.timelined == null) {
            return;
        }
        Timeline timeline = this.timelined.getTimeline();
        if (frame >= timeline.getFrameCount()) {
            return;
        }
        if (frame < 0) {
            return;
        }
        this.frame = frame;
        this.stopInternal();
        this.redraw();
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public synchronized float getFrameRate() {
        if (this.timelined == null) {
            return 1.0f;
        }
        if (this.stillFrame) {
            return 1.0f;
        }
        return this.timelined.getTimeline().frameRate;
    }

    @Override
    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public boolean loopAvailable() {
        return false;
    }

    @Override
    public boolean screenAvailable() {
        return true;
    }

    @Override
    public synchronized Zoom getZoom() {
        return this.zoom;
    }

    private class IconPanel
    extends JPanel {
        private SerializableImage _img;
        private Rectangle _rect = null;
        private ButtonTag mouseOverButton = null;
        private boolean autoFit = false;
        private boolean allowMove = true;
        private Point dragStart = null;
        private Point offsetPoint = new Point(0, 0);
        VolatileImage renderImage;

        private synchronized SerializableImage getImg() {
            return this._img;
        }

        public synchronized Rectangle getRect() {
            return this._rect;
        }

        public boolean hasAllowMove() {
            return this.allowMove;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render() {
            VolatileImage ri;
            SerializableImage img = this.getImg();
            Rectangle rect = this.getRect();
            if (img == null) {
                return;
            }
            Graphics2D g2 = null;
            do {
                if ((ri = this.renderImage) == null) {
                    return;
                }
                int valid = ri.validate(View.getDefaultConfiguration());
                if (valid == 2) {
                    ri = View.createRenderImage(this.getWidth(), this.getHeight(), 3);
                }
                try {
                    g2 = ri.createGraphics();
                    g2.setPaint(View.transparentPaint);
                    g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
                    g2.setComposite(AlphaComposite.SrcOver);
                    g2.setPaint(View.getSwfBackgroundColor());
                    g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
                    g2.setComposite(AlphaComposite.SrcOver);
                    if (rect == null) continue;
                    g2.drawImage(img.getBufferedImage(), rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, 0, 0, img.getWidth(), img.getHeight(), null);
                }
                finally {
                    if (g2 != null) {
                        g2.dispose();
                    }
                }
            } while (ri.contentsLost());
        }

        public IconPanel() {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int width = IconPanel.this.getWidth();
                    int height = IconPanel.this.getHeight();
                    IconPanel.this.renderImage = width > 0 && height > 0 ? View.createRenderImage(width, height, 3) : null;
                    if (IconPanel.this._img != null) {
                        IconPanel.this.calcRect();
                        IconPanel.this.render();
                    }
                    IconPanel.this.repaint();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        IconPanel.this.dragStart = e.getPoint();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        IconPanel.this.dragStart = null;
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (IconPanel.this.dragStart != null && IconPanel.this.allowMove) {
                        Point dragEnd = e.getPoint();
                        Point delta = new Point(dragEnd.x - ((IconPanel)IconPanel.this).dragStart.x, dragEnd.y - ((IconPanel)IconPanel.this).dragStart.y);
                        ((IconPanel)IconPanel.this).offsetPoint.x += delta.x;
                        ((IconPanel)IconPanel.this).offsetPoint.y += delta.y;
                        IconPanel.this.dragStart = dragEnd;
                        IconPanel.this.repaint();
                    }
                }
            });
        }

        public void setAutoFit(boolean autoFit) {
            this.autoFit = autoFit;
            this.repaint();
        }

        public synchronized BufferedImage getLastImage() {
            if (this._img == null) {
                return null;
            }
            return this._img.getBufferedImage();
        }

        public synchronized void setImg(SerializableImage img) {
            this._img = img;
            if (img != null) {
                this.calcRect();
                this.render();
            }
            this.repaint();
        }

        public synchronized Point toImagePoint(Point p) {
            if (this._img == null) {
                return null;
            }
            return new Point((p.x - this._rect.x) * this._img.getWidth() / this._rect.width, (p.y - this._rect.y) * this._img.getHeight() / this._rect.height);
        }

        private void setAllowMove(boolean allowMove) {
            this.allowMove = allowMove;
            if (!allowMove) {
                this.offsetPoint = new Point();
            }
        }

        private synchronized void calcRect() {
            if (this._img != null) {
                int h;
                int w;
                int w1 = (int)((double)this._img.getWidth() * 1.0);
                int h1 = (int)((double)this._img.getHeight() * 1.0);
                int w2 = this.getWidth();
                int h2 = this.getHeight();
                if (this.autoFit) {
                    if (w1 <= w2 && h1 <= h2) {
                        w = w1;
                        h = h1;
                    } else {
                        h = h1 * w2 / w1;
                        if (h > h2) {
                            w = w1 * h2 / h1;
                            h = h2;
                        } else {
                            w = w2;
                        }
                    }
                } else {
                    w = w1;
                    h = h1;
                }
                this.setAllowMove(h > h2 || w > w2);
                this._rect = new Rectangle(this.getWidth() / 2 - w / 2 + this.offsetPoint.x, this.getHeight() / 2 - h / 2 + this.offsetPoint.y, w, h);
            } else {
                this._rect = null;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            VolatileImage ri = this.renderImage;
            if (ri != null) {
                this.calcRect();
                if (ri.validate(View.getDefaultConfiguration()) != 0) {
                    ri = View.createRenderImage(this.getWidth(), this.getHeight(), 3);
                    this.render();
                }
                if (ri != null) {
                    g2d.drawImage(ri, 0, 0, null);
                }
            }
            g2d.setColor(Color.red);
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(0);
            df.setGroupingUsed(false);
            float frameLoss = 100.0f - ImagePanel.this.getFpsIs() / ImagePanel.this.fpsShouldBe * 100.0f;
            if (((Boolean)Configuration._debugMode.get()).booleanValue()) {
                g2d.drawString("frameLoss:" + df.format(frameLoss) + "%", 20, 20);
            }
        }
    }
}

