/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationCategory;
import com.jpexs.decompiler.flash.configuration.ConfigurationDirectory;
import com.jpexs.decompiler.flash.configuration.ConfigurationFile;
import com.jpexs.decompiler.flash.configuration.ConfigurationInternal;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.HtmlLabel;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.OceanicSkin;
import com.jpexs.decompiler.flash.gui.SelectLanguageDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.helpers.SpringUtilities;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.api.skin.SkinInfo;

public class AdvancedSettingsDialog
extends AppDialog {
    private final Map<String, Component> componentsMap = new HashMap<String, Component>();
    private JButton cancelButton;
    private JButton okButton;
    private JButton resetButton;

    public AdvancedSettingsDialog(String selectedCategory) {
        this.initComponents(selectedCategory);
        View.centerScreen(this);
        View.setWindowIcon(this);
        this.pack();
    }

    private DefaultTableModel getModel() {
        return new DefaultTableModel(new Object[0][], new String[]{this.translate("advancedSettings.columns.name"), this.translate("advancedSettings.columns.value"), this.translate("advancedSettings.columns.description")}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class, String.class};
                this.canEdit = new boolean[]{false, true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
    }

    private void initComponents(String selectedCategory) {
        String[] catOrder;
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.resetButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.translate("advancedSettings.dialog.title"));
        this.setModal(true);
        this.setPreferredSize(new Dimension(800, 500));
        this.okButton.setText(AppStrings.translate("button.ok"));
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.setText(AppStrings.translate("button.cancel"));
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        this.resetButton.setText(AppStrings.translate("button.reset"));
        this.resetButton.addActionListener(this::resetButtonActionPerformed);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        JPanel buttonsLeftPanel = new JPanel(new FlowLayout());
        buttonsLeftPanel.add((Component)this.resetButton, "West");
        buttonsPanel.add((Component)buttonsLeftPanel, "West");
        JPanel buttonsRightPanel = new JPanel(new FlowLayout());
        buttonsRightPanel.add(this.okButton);
        buttonsRightPanel.add(this.cancelButton);
        buttonsPanel.add((Component)buttonsRightPanel, "East");
        cnt.add((Component)buttonsPanel, "South");
        JTabbedPane tabPane = new JTabbedPane();
        JComboBox<SkinSelect> skinComboBox = new JComboBox<SkinSelect>();
        skinComboBox.setRenderer((ListCellRenderer<SkinSelect>)new SubstanceDefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SubstanceDefaultListCellRenderer cmp = (SubstanceDefaultListCellRenderer)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                final SkinSelect ss = (SkinSelect)value;
                cmp.setIcon(new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        Graphics2D g2 = (Graphics2D)g;
                        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        try {
                            Class<?> act = Class.forName(ss.getClassName());
                            SubstanceSkin skin = (SubstanceSkin)act.newInstance();
                            Color fill = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
                            Color hilight = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getBackgroundFillColor();
                            Color border = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED).getDarkColor();
                            g2.setColor(fill);
                            g2.fillOval(0, 0, 16, 16);
                            g2.setColor(hilight);
                            g2.fillArc(0, 0, 16, 16, -45, 90);
                            g2.setColor(border);
                            g2.drawOval(0, 0, 16, 16);
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public int getIconWidth() {
                        return 16;
                    }

                    @Override
                    public int getIconHeight() {
                        return 16;
                    }
                });
                return cmp;
            }
        });
        skinComboBox.addItem(new SkinSelect("Oceanic", OceanicSkin.class.getName()));
        Map skins = SubstanceLookAndFeel.getAllSkins();
        for (String skinKey : skins.keySet()) {
            SkinInfo skin = (SkinInfo)skins.get(skinKey);
            skinComboBox.addItem(new SkinSelect(skin.getDisplayName(), skin.getClassName()));
            if (!skin.getClassName().equals(Configuration.guiSkin.get())) continue;
            skinComboBox.setSelectedIndex(skinComboBox.getItemCount() - 1);
        }
        HashMap<String, Component> tabs = new HashMap<String, Component>();
        AdvancedSettingsDialog.getCategories(this.componentsMap, tabs, skinComboBox, this.getResourceBundle());
        for (String cat : catOrder = new String[]{"ui", "display", "decompilation", "script", "format", "export", "import", "paths", "limit", "update", "debug", "other"}) {
            if (!tabs.containsKey(cat)) continue;
            tabPane.add(this.translate("config.group.name." + cat), (Component)tabs.get(cat));
            tabPane.setToolTipTextAt(tabPane.getTabCount() - 1, this.translate("config.group.description." + cat));
        }
        if (selectedCategory != null && tabs.containsKey(selectedCategory)) {
            tabPane.setSelectedComponent((Component)tabs.get(selectedCategory));
        }
        cnt.add((Component)tabPane, "Center");
        this.pack();
    }

    public static String selectConfigFile(ConfigurationItem config, String current, final String pattern) {
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(current));
        fc.setMultiSelectionEnabled(false);
        fc.setCurrentDirectory(new File((String)config.get()));
        FileFilter allSupportedFilter = new FileFilter(){
            private final String[] supportedExtensions = new String[]{".swf", ".gfx", ".swc", ".zip", ".iggy"};

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().matches(pattern);
            }

            @Override
            public String getDescription() {
                return "";
            }
        };
        fc.setFileFilter(allSupportedFilter);
        fc.setAcceptAllFileFilterUsed(false);
        JFrame f = new JFrame();
        View.setWindowIcon(f);
        int returnVal = fc.showOpenDialog(f);
        if (returnVal == 0) {
            return Helper.fixDialogFile((File)fc.getSelectedFile()).getAbsolutePath();
        }
        return (String)config.get();
    }

    public static void getCategories(Map<String, Component> componentsMap, Map<String, Component> tabs, JComboBox<?> skinComboBox, ResourceBundle resourceBundle) {
        HashMap categorized = new HashMap();
        Map fields = Configuration.getConfigurationFields();
        Object[] keys = new String[fields.size()];
        keys = fields.keySet().toArray(keys);
        Arrays.sort(keys);
        for (Object name : keys) {
            Iterator scat;
            Field field = (Field)fields.get(name);
            ConfigurationCategory cat = field.getAnnotation(ConfigurationCategory.class);
            Iterator iterator = scat = cat == null || cat.value().isEmpty() ? "other" : cat.value();
            if (!categorized.containsKey(scat)) {
                categorized.put((String)((Object)scat), new HashMap());
            }
            ((Map)categorized.get(scat)).put(name, field);
        }
        for (String cat : categorized.keySet()) {
            JPanel configPanel = new JPanel(new SpringLayout());
            int itemCount = 0;
            ArrayList names = new ArrayList(((Map)categorized.get(cat)).keySet());
            final HashMap<String, String> locNames = new HashMap<String, String>();
            for (String name : names) {
                String locName;
                if (resourceBundle.containsKey("config.name." + name)) {
                    locName = resourceBundle.getString("config.name." + name);
                } else {
                    Field f = (Field)fields.get(name);
                    ConfigurationInternal cint = f.getAnnotation(ConfigurationInternal.class);
                    if (cint == null) {
                        throw new RuntimeException("Missing configuration name: " + name);
                    }
                    locName = "(Internal) " + name;
                }
                locNames.put(name, locName);
            }
            Collections.sort(names, new Comparator<String>(){

                @Override
                public int compare(String name1, String name2) {
                    return ((String)locNames.get(name1)).compareTo((String)locNames.get(name2));
                }
            });
            for (String name : names) {
                Field field = (Field)((Map)categorized.get(cat)).get(name);
                String locName = (String)locNames.get(name);
                try {
                    JComponent cb;
                    ConfigurationItem item = (ConfigurationItem)field.get(null);
                    ParameterizedType listType = (ParameterizedType)field.getGenericType();
                    Type itemType2 = listType.getActualTypeArguments()[0];
                    if (!(itemType2 instanceof Class)) continue;
                    Class itemType = (Class)itemType2;
                    String description = "";
                    if (resourceBundle.containsKey("config.description." + name)) {
                        description = resourceBundle.getString("config.description." + name);
                    }
                    Object defaultValue = Configuration.getDefaultValue((Field)field);
                    if (name.equals("gui.skin")) {
                        try {
                            Class<?> c = Class.forName((String)defaultValue);
                            defaultValue = c.getField("NAME").get(c);
                        }
                        catch (ClassNotFoundException | NoSuchFieldException | SecurityException ex) {
                            Logger.getLogger(AdvancedSettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (defaultValue != null) {
                        description = description + " (" + resourceBundle.getString("default") + ": " + defaultValue + ")";
                    }
                    JLabel l = new JLabel(locName, 11);
                    l.setToolTipText(description);
                    configPanel.add(l);
                    JComponent c = null;
                    JComponent addComponent = null;
                    if (name.equals("gui.skin")) {
                        skinComboBox.setToolTipText(description);
                        skinComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, skinComboBox.getPreferredSize().height));
                        c = skinComboBox;
                    } else if (itemType == String.class || itemType == Integer.class || itemType == Long.class || itemType == Double.class || itemType == Float.class || itemType == Calendar.class) {
                        ConfigurationFile confFile = field.getAnnotation(ConfigurationFile.class);
                        ConfigurationDirectory confDirectory = field.getAnnotation(ConfigurationDirectory.class);
                        JTextField tf = new JTextField();
                        Object val = item.get();
                        if (val == null) {
                            val = "";
                        }
                        if (itemType == Calendar.class) {
                            tf.setText(new SimpleDateFormat().format(((Calendar)val).getTime()));
                        } else {
                            tf.setText(val.toString());
                        }
                        tf.setToolTipText(description);
                        tf.setMaximumSize(new Dimension(Integer.MAX_VALUE, tf.getPreferredSize().height));
                        c = tf;
                        if (confFile != null) {
                            JPanel p = new JPanel(new BorderLayout());
                            p.setMaximumSize(new Dimension(Integer.MAX_VALUE, tf.getPreferredSize().height));
                            p.add((Component)tf, "Center");
                            JButton butSelect = new JButton(View.getIcon("folderopen16"));
                            butSelect.setToolTipText(ResourceBundle.getBundle(AppStrings.getResourcePath(MainFrame.class)).getString("FileChooser.openButtonText"));
                            butSelect.setMargin(new Insets(2, 2, 2, 2));
                            butSelect.addActionListener(e -> tf.setText(AdvancedSettingsDialog.selectConfigFile(item, tf.getText(), confFile.value())));
                            p.add((Component)butSelect, "East");
                            addComponent = p;
                        }
                    } else if (itemType == Boolean.class) {
                        cb = new JCheckBox();
                        ((AbstractButton)cb).setSelected((Boolean)item.get());
                        cb.setToolTipText(description);
                        c = cb;
                    } else if (itemType.isEnum()) {
                        cb = new JComboBox();
                        EnumSet enumValues = EnumSet.allOf(itemType);
                        String stringValue = null;
                        for (Object enumValue : enumValues) {
                            String enumValueStr = enumValue.toString();
                            if (stringValue == null) {
                                stringValue = enumValueStr;
                            }
                            ((JComboBox)cb).addItem(enumValueStr);
                        }
                        if (item.get() != null) {
                            stringValue = item.get().toString();
                        }
                        cb.setToolTipText(description);
                        ((JComboBox)cb).setSelectedItem(stringValue);
                        cb.setMaximumSize(new Dimension(Integer.MAX_VALUE, cb.getPreferredSize().height));
                        c = cb;
                    } else {
                        throw new UnsupportedOperationException("Configuration ttem type '" + itemType.getName() + "' is not supported");
                    }
                    componentsMap.put(name, c);
                    if (addComponent == null) {
                        addComponent = c;
                    }
                    l.setLabelFor(c);
                    configPanel.add(addComponent);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw new Error(ex.getMessage());
                }
                ++itemCount;
            }
            SpringUtilities.makeCompactGrid(configPanel, itemCount, 2, 6, 6, 6, 6);
            if (resourceBundle.containsKey("config.group.tip." + cat)) {
                String tip = resourceBundle.getString("config.group.tip." + cat);
                String[] urls = new String[]{};
                if (resourceBundle.containsKey("config.group.link." + cat)) {
                    urls = resourceBundle.getString("config.group.link." + cat).split(" ");
                }
                for (int i = 0; i < urls.length; ++i) {
                    tip = tip.replace("%link" + (i + 1) + "%", urls[i]);
                }
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)configPanel, "Center");
                JPanel tipPanel = new JPanel(new FlowLayout());
                tipPanel.add(new HtmlLabel("<b>" + resourceBundle.getString("tip") + "</b>" + tip));
                p.add((Component)tipPanel, "South");
                configPanel = p;
            }
            tabs.put(cat, new JScrollPane(configPanel));
        }
    }

    private void showRestartConfirmDialod() {
        if (View.showConfirmDialog(this, this.translate("advancedSettings.restartConfirmation"), AppStrings.translate("message.warning"), 0) == 0) {
            View.execInEventDispatchLater(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AdvancedSettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
                SelectLanguageDialog.reloadUi();
            });
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Object value;
        Component c;
        boolean modified = false;
        Map fields = Configuration.getConfigurationFields();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String name : fields.keySet()) {
            block19: {
                c = this.componentsMap.get(name);
                value = null;
                ParameterizedType listType = (ParameterizedType)((Field)fields.get(name)).getGenericType();
                Type itemType2 = listType.getActualTypeArguments()[0];
                if (!(itemType2 instanceof Class)) continue;
                Class itemType = (Class)itemType2;
                if (name.equals("gui.skin")) {
                    value = ((SkinSelect)((JComboBox)c).getSelectedItem()).className;
                } else if (itemType == String.class) {
                    value = ((JTextField)c).getText();
                }
                if (itemType == Boolean.class) {
                    value = ((JCheckBox)c).isSelected();
                }
                if (itemType == Calendar.class) {
                    Calendar cal = Calendar.getInstance();
                    try {
                        cal.setTime(new SimpleDateFormat().parse(((JTextField)c).getText()));
                    }
                    catch (ParseException ex) {
                        c.requestFocusInWindow();
                        return;
                    }
                    value = cal;
                }
                if (itemType.isEnum()) {
                    String stringValue = (String)((JComboBox)c).getSelectedItem();
                    value = Enum.valueOf(itemType, stringValue);
                }
                try {
                    if (itemType == Integer.class) {
                        value = Integer.parseInt(((JTextField)c).getText());
                    }
                    if (itemType == Long.class) {
                        value = Long.parseLong(((JTextField)c).getText());
                    }
                    if (itemType == Double.class) {
                        value = Double.parseDouble(((JTextField)c).getText());
                    }
                    if (itemType == Float.class) {
                        value = Float.valueOf(Float.parseFloat(((JTextField)c).getText()));
                    }
                }
                catch (NumberFormatException nfe) {
                    if (((JTextField)c).getText().isEmpty()) break block19;
                    c.requestFocusInWindow();
                    return;
                }
            }
            values.put(name, value);
        }
        for (String name : fields.keySet()) {
            c = this.componentsMap.get(name);
            value = values.get(name);
            Field field = (Field)fields.get(name);
            ConfigurationItem item = null;
            try {
                item = (ConfigurationItem)field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new Error(ex.getMessage());
            }
            if (item.get() != null && item.get().equals(value) || !item.hasValue() && value == null) continue;
            item.set(value);
            modified = true;
        }
        Configuration.saveConfig();
        this.setVisible(false);
        if (modified) {
            this.showRestartConfirmDialod();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        Map rfields = Configuration.getConfigurationFields();
        for (Map.Entry entry : rfields.entrySet()) {
            String name = (String)entry.getKey();
            Field field = (Field)entry.getValue();
            try {
                ConfigurationItem item = (ConfigurationItem)field.get(null);
                item.unset();
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new Error(ex.getMessage());
            }
        }
        Configuration.saveConfig();
        this.setVisible(false);
        this.showRestartConfirmDialod();
    }

    private static class SkinSelect {
        private final String name;
        private final String className;

        public SkinSelect(String name, String className) {
            this.name = name;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return this.name;
        }
    }
}

