/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.firefox;

import com.jpexs.browsers.cache.firefox.CacheInputStream;
import com.jpexs.browsers.cache.firefox.IncompatibleVersionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class MetaData {
    public int majorVersion;
    public int minorVersion;
    public long location;
    public long fetchCount;
    public long firstFetchTime;
    public long lastFetchTime;
    public long expireTime;
    public long dataSize;
    public long requestSize;
    public long infoSize;
    public String request;
    public Map<String, String> response;

    public MetaData(InputStream is) throws IOException, IncompatibleVersionException {
        int nulpos;
        CacheInputStream cis = new CacheInputStream(is);
        this.majorVersion = cis.readInt16();
        if (this.majorVersion != 1) {
            throw new IncompatibleVersionException(this.majorVersion);
        }
        this.minorVersion = cis.readInt16();
        this.location = cis.readInt32();
        this.fetchCount = cis.readInt32();
        this.firstFetchTime = cis.readInt32();
        this.lastFetchTime = cis.readInt32();
        this.expireTime = cis.readInt32();
        this.dataSize = cis.readInt32();
        this.requestSize = cis.readInt32();
        this.infoSize = cis.readInt32();
        byte[] req = new byte[(int)this.requestSize];
        if (cis.read(req) != req.length) {
            throw new IOException();
        }
        this.request = new String(req, 0, (int)this.requestSize - 1);
        byte[] res = new byte[(int)this.infoSize];
        cis.read(res);
        String responseStr = new String(res);
        boolean inKey = true;
        String key = null;
        this.response = new HashMap<String, String>();
        while ((nulpos = responseStr.indexOf(0)) > 0) {
            String v = responseStr.substring(0, nulpos);
            responseStr = responseStr.substring(nulpos + 1);
            if (inKey) {
                key = v;
            } else {
                this.response.put(key, v);
            }
            inKey = !inKey;
        }
    }
}

