/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.firefox;

import com.jpexs.browsers.cache.CacheEntry;
import com.jpexs.browsers.cache.firefox.CacheInputStream;
import com.jpexs.browsers.cache.firefox.IncompatibleVersionException;
import com.jpexs.browsers.cache.firefox.Location;
import com.jpexs.browsers.cache.firefox.MetaData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MapBucket
extends CacheEntry {
    public long hash;
    public long enviction;
    public Location dataLocation;
    public Location metadataLocation;
    private MetaData metadata;

    public MapBucket(InputStream is, File rootDir, Map<Integer, RandomAccessFile> dataFiles) throws IOException {
        CacheInputStream cis = new CacheInputStream(is);
        this.hash = cis.readInt32();
        this.enviction = cis.readInt32();
        this.dataLocation = new Location(cis.readInt32(), false, this.hash, rootDir, dataFiles);
        this.metadataLocation = new Location(cis.readInt32(), true, this.hash, rootDir, dataFiles);
    }

    public InputStream getMetaDataStream() throws IOException {
        return this.metadataLocation.getInputStream();
    }

    public MetaData getMetaData() {
        if (this.metadata == null) {
            try {
                this.metadata = new MetaData(this.getMetaDataStream());
            }
            catch (IncompatibleVersionException incompatibleVersionException) {
            }
            catch (IOException ex) {
                Logger.getLogger(MapBucket.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.metadata;
    }

    @Override
    public String getRequestURL() {
        MetaData m = this.getMetaData();
        if (m == null) {
            return null;
        }
        String req = m.request;
        if (req == null) {
            return null;
        }
        if (req.startsWith("HTTP:")) {
            req = req.substring("HTTP:".length());
        }
        return req;
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        MetaData m = this.getMetaData();
        if (m == null) {
            return null;
        }
        String responseHead = m.response.get("response-head");
        if (responseHead == null) {
            return null;
        }
        String[] headers = responseHead.split("\r\n");
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int h = 1; h < headers.length; ++h) {
            String hs = headers[h];
            if (!hs.contains(":")) continue;
            String[] hp = hs.split(":");
            ret.put(hp[0].trim(), hp[1].trim());
        }
        return ret;
    }

    @Override
    public String getStatusLine() {
        MetaData m = this.getMetaData();
        if (m == null) {
            return null;
        }
        String responseHead = m.response.get("response-head");
        String[] headers = responseHead.split("\r\n");
        return headers[0];
    }

    @Override
    public String getRequestMethod() {
        return "GET";
    }

    @Override
    public InputStream getResponseRawDataStream() {
        try {
            return this.dataLocation.getInputStream();
        }
        catch (IOException ex) {
            Logger.getLogger(MapBucket.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

