/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.chrome;

import com.jpexs.browsers.cache.RafInputStream;
import com.jpexs.browsers.cache.chrome.IndexInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Map;

public class CacheAddr {
    private static final int EXTERNAL = 0;
    private static final int RANKINGS = 1;
    private static final int BLOCK_256 = 2;
    private static final int BLOCK_1K = 3;
    private static final int BLOCK_4K = 4;
    private static final int BLOCK_FILES = 5;
    private static final int BLOCK_ENTRIES = 6;
    private static final int BLOCK_EVICTED = 7;
    private static final String[] blockNames = new String[]{"EXTERNAL", "RANKINGS", "BLOCK_256", "BLOCK_1K", "BLOCK_4K", "BLOCK_FILES", "BLOCK_ENTRIES", "BLOCK_EVICTED"};
    private static final int[] blockSizes = new int[]{0, 36, 256, 1024, 4096, 8, 104, 48};
    private static final long kInitializedMask = 0x80000000L;
    private static final long kFileTypeMask = 0x70000000L;
    private static final int kFileTypeOffset = 28;
    private static final long kReservedBitsMask = 0xC000000L;
    private static final long kNumBlocksMask = 0x3000000L;
    private static final int kNumBlocksOffset = 24;
    private static final long kFileSelectorMask = 0xFF0000L;
    private static final int FileSelectorOffset = 16;
    private static final long kStartBlockMask = 65535L;
    private static final long kFileNameMask = 0xFFFFFFFL;
    private final boolean initialized;
    private final int fileType;
    private int numBlocks;
    private int fileSelector;
    private int startBlock;
    private int fileName;
    private final long val;
    private final File rootPath;
    private final Map<Integer, RandomAccessFile> dataFiles;
    private final File externalFilesDir;

    public CacheAddr(InputStream is, File rootPath, Map<Integer, RandomAccessFile> dataFiles, File externalFilesDir) throws IOException {
        this.dataFiles = dataFiles;
        this.rootPath = rootPath;
        this.externalFilesDir = externalFilesDir;
        IndexInputStream iis = new IndexInputStream(is);
        this.val = iis.readUInt32();
        this.initialized = (this.val & 0x80000000L) == 0x80000000L;
        this.fileType = (int)((this.val & 0x70000000L) >> 28);
        if (this.fileType == 0) {
            this.fileName = (int)(this.val & 0xFFFFFFFL);
        } else {
            this.numBlocks = (int)((this.val & 0x3000000L) >> 24);
            this.fileSelector = (int)((this.val & 0xFF0000L) >> 16);
            this.startBlock = (int)(this.val & 0xFFFFL);
        }
    }

    public String toString() {
        String ft = blockNames[this.fileType];
        if (this.fileType == 0) {
            return ft + ":" + this.fileName;
        }
        if (!this.initialized) {
            return "uninitialized";
        }
        return ft + ": numBlocks " + this.numBlocks + " fileSelector " + this.fileSelector + " startBlock " + this.startBlock;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.initialized) {
            return null;
        }
        switch (this.fileType) {
            case 0: {
                String fileNameStr = Long.toHexString(this.fileName);
                while (fileNameStr.length() < 6) {
                    fileNameStr = "0" + fileNameStr;
                }
                fileNameStr = "f_" + fileNameStr;
                return new RafInputStream(new RandomAccessFile(new File(this.externalFilesDir, fileNameStr), "r"));
            }
            case 2: 
            case 3: 
            case 4: {
                RandomAccessFile raf;
                if (this.dataFiles.containsKey(this.fileSelector)) {
                    raf = this.dataFiles.get(this.fileSelector);
                } else {
                    raf = new RandomAccessFile(this.rootPath + "\\data_" + this.fileSelector, "r");
                    this.dataFiles.put(this.fileSelector, raf);
                }
                raf.seek(8192 + this.startBlock * blockSizes[this.fileType]);
                return new RafInputStream(raf);
            }
        }
        return null;
    }
}

