/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;

public class GlyphStripper {
    private final GlyphTable.Builder glyphTableBuilder;

    public GlyphStripper(GlyphTable.Builder builder) {
        this.glyphTableBuilder = builder;
    }

    public Glyph.Builder<? extends Glyph> stripGlyph(Glyph glyph) {
        WritableFontData writableFontData = null;
        if (glyph != null && glyph.readFontData().length() > 0) {
            switch (glyph.glyphType()) {
                case Simple: {
                    writableFontData = this.stripSimpleGlyph(glyph);
                    break;
                }
                case Composite: {
                    writableFontData = this.stripCompositeGlyph(glyph);
                    break;
                }
            }
        }
        if (writableFontData == null) {
            writableFontData = WritableFontData.createWritableFontData(0);
        }
        return this.glyphTableBuilder.glyphBuilder(writableFontData);
    }

    private WritableFontData stripSimpleGlyph(Glyph glyph) {
        int n = this.computeSimpleStrippedGlyphSize(glyph);
        int n2 = n + 1 & 0xFFFFFFFE;
        WritableFontData writableFontData = WritableFontData.createWritableFontData(n2);
        SimpleGlyph simpleGlyph = (SimpleGlyph)glyph;
        ReadableFontData readableFontData = glyph.readFontData();
        int n3 = this.writeHeaderAndContoursSize(writableFontData, 0, readableFontData, 0, simpleGlyph);
        n3 += this.writeZeroInstructionLength(writableFontData, n3);
        n3 += this.writeEndSimpleGlyph(writableFontData, n3, readableFontData, n3 + simpleGlyph.instructionSize() * FontData.DataSize.BYTE.size(), n - n3);
        return writableFontData;
    }

    private int writeHeaderAndContoursSize(WritableFontData writableFontData, int n, ReadableFontData readableFontData, int n2, SimpleGlyph simpleGlyph) {
        int n3 = FontData.DataSize.SHORT.size() * 5 + simpleGlyph.numberOfContours() * FontData.DataSize.USHORT.size();
        WritableFontData writableFontData2 = writableFontData.slice(n, n3);
        readableFontData.slice(n2, n3).copyTo(writableFontData2);
        return n3;
    }

    private int writeZeroInstructionLength(WritableFontData writableFontData, int n) {
        writableFontData.writeUShort(n, 0);
        return FontData.DataSize.USHORT.size();
    }

    private int writeEndSimpleGlyph(WritableFontData writableFontData, int n, ReadableFontData readableFontData, int n2, int n3) {
        ReadableFontData readableFontData2 = readableFontData.slice(n2, n3);
        WritableFontData writableFontData2 = writableFontData.slice(n, n3);
        readableFontData2.copyTo(writableFontData2);
        return n3;
    }

    private WritableFontData stripCompositeGlyph(Glyph glyph) {
        int n = this.computeCompositeStrippedGlyphSize(glyph);
        WritableFontData writableFontData = WritableFontData.createWritableFontData(n);
        CompositeGlyph compositeGlyph = (CompositeGlyph)glyph;
        ReadableFontData readableFontData = glyph.readFontData().slice(0, n);
        readableFontData.copyTo(writableFontData);
        if (compositeGlyph.instructionSize() > 0) {
            this.overrideCompositeGlyfFlags(writableFontData, n);
        }
        return writableFontData;
    }

    private void overrideCompositeGlyfFlags(WritableFontData writableFontData, int n) {
        int n2 = 5 * FontData.DataSize.USHORT.size();
        int n3 = 32;
        while ((n3 & 0x20) != 0) {
            n3 = writableFontData.readUShort(n2);
            writableFontData.writeUShort(n2, n3 &= 0xFFFFFEFF);
            n2 += 2 * FontData.DataSize.USHORT.size();
            n2 = (n3 & 1) != 0 ? (n2 += 2 * FontData.DataSize.SHORT.size()) : (n2 += 2 * FontData.DataSize.BYTE.size());
            if ((n3 & 8) != 0) {
                n2 += FontData.DataSize.F2DOT14.size();
                continue;
            }
            if ((n3 & 0x40) != 0) {
                n2 += 2 * FontData.DataSize.F2DOT14.size();
                continue;
            }
            if ((n3 & 0x80) == 0) continue;
            n2 += 4 * FontData.DataSize.F2DOT14.size();
        }
    }

    private int computeSimpleStrippedGlyphSize(Glyph glyph) {
        SimpleGlyph simpleGlyph = (SimpleGlyph)glyph;
        int n = simpleGlyph.instructionSize();
        int n2 = simpleGlyph.dataLength() - simpleGlyph.padding();
        if (n > 0) {
            return n2 - this.computeInstructionsSize(simpleGlyph);
        }
        return n2;
    }

    private int computeInstructionsSize(SimpleGlyph simpleGlyph) {
        return simpleGlyph.instructionSize() * FontData.DataSize.BYTE.size();
    }

    private int computeCompositeStrippedGlyphSize(Glyph glyph) {
        CompositeGlyph compositeGlyph = (CompositeGlyph)glyph;
        int n = compositeGlyph.instructionSize();
        int n2 = compositeGlyph.dataLength() - compositeGlyph.padding();
        if (n > 0) {
            return n2 - n * FontData.DataSize.BYTE.size() - FontData.DataSize.USHORT.size();
        }
        return n2;
    }
}

