/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.tools.conversion.eot.BitIOWriter;
import com.google.typography.font.tools.conversion.eot.HuffmanEncoder;

public class LzcompCompress {
    private static final int MAX_2BYTE_DIST = 512;
    private static final int DIST_MIN = 1;
    private static final int DIST_WIDTH = 3;
    private static final int LEN_MIN = 2;
    private static final int LEN_MIN3 = 3;
    private static final int LEN_WIDTH = 3;
    private static final int BIT_RANGE = 2;
    private static final int PRELOAD_SIZE = 7168;
    private static final int DEFAULT_MAX_COPY_DIST = Integer.MAX_VALUE;
    private BitIOWriter bits;
    private boolean usingRunLength = false;
    private int length1;
    private int maxCopyDist = Integer.MAX_VALUE;
    private HuffmanEncoder distEncoder;
    private HuffmanEncoder lenEncoder;
    private HuffmanEncoder symEncoder;
    private int numDistRanges;
    private int distMax;
    private int dup2;
    private int dup4;
    private int dup6;
    private int numSyms;
    private byte[] buf;
    private HashNode[] hashTable;

    private LzcompCompress() {
        this.bits = new BitIOWriter();
    }

    private void write(byte[] byArray) {
        this.bits.writeBit(this.usingRunLength);
        this.length1 = byArray.length;
        this.setDistRange(this.length1);
        this.distEncoder = new HuffmanEncoder(this.bits, 8);
        this.lenEncoder = new HuffmanEncoder(this.bits, 8);
        this.symEncoder = new HuffmanEncoder(this.bits, this.numSyms);
        this.buf = new byte[7168 + this.length1];
        System.arraycopy(byArray, 0, this.buf, 7168, this.length1);
        this.encode();
        this.bits.flush();
    }

    void setDistRange(int n) {
        this.numDistRanges = 1;
        this.distMax = 1 + (1 << 3 * this.numDistRanges) - 1;
        while (this.distMax < this.length1) {
            ++this.numDistRanges;
            this.distMax = 1 + (1 << 3 * this.numDistRanges) - 1;
        }
        this.dup2 = 256 + 8 * this.numDistRanges;
        this.dup4 = this.dup2 + 1;
        this.dup6 = this.dup4 + 1;
        this.numSyms = this.dup6 + 1;
    }

    private void encode() {
        int n = this.length1 + 7168;
        this.initializeModel();
        this.bits.writeValue(this.length1, 24);
        int n2 = this.length1 + 7168;
        int[] nArray = new int[1];
        int n3 = 7168;
        while (n3 < n2) {
            int n4;
            int n5;
            int n6 = n3;
            if ((n5 = this.makeCopyDecision(n3++, nArray)) > 0) {
                n4 = this.getNumDistRanges(nArray[0]);
                this.encodeLength(n5, nArray[0], n4);
                this.encodeDistance2(nArray[0], n4);
                for (int i = 1; i < n5; ++i) {
                    this.updateModel(n3++);
                }
                continue;
            }
            n4 = this.buf[n6];
            if (n6 >= 2 && n4 == this.buf[n6 - 2]) {
                this.symEncoder.writeSymbol(this.dup2);
                continue;
            }
            if (n6 >= 4 && n4 == this.buf[n6 - 4]) {
                this.symEncoder.writeSymbol(this.dup4);
                continue;
            }
            if (n6 >= 6 && n4 == this.buf[n6 - 6]) {
                this.symEncoder.writeSymbol(this.dup6);
                continue;
            }
            this.symEncoder.writeSymbol(this.buf[n6] & 0xFF);
        }
    }

    void initializeModel() {
        int n;
        this.hashTable = new HashNode[65536];
        int n2 = 0;
        for (n = 0; n < 32; ++n) {
            for (int i = 0; i < 96; ++i) {
                this.buf[n2] = (byte)n;
                this.updateModel(n2++);
                this.buf[n2] = (byte)i;
                this.updateModel(n2++);
            }
        }
        for (n = 0; n2 < 7168 && n < 256; ++n) {
            this.buf[n2] = (byte)n;
            this.updateModel(n2++);
            this.buf[n2] = (byte)n;
            this.updateModel(n2++);
            this.buf[n2] = (byte)n;
            this.updateModel(n2++);
            this.buf[n2] = (byte)n;
            this.updateModel(n2++);
        }
    }

    private int makeCopyDecision(int n, int[] nArray) {
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int n2 = n;
        int n3 = this.findMatch(n, nArray2, nArray3, nArray4);
        this.updateModel(n++);
        if (nArray3[0] > 0) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int[] nArray5;
            int[] nArray6;
            int[] nArray7;
            int n9;
            int[] nArray8 = new int[1];
            int[] nArray9 = new int[1];
            int[] nArray10 = new int[1];
            int n10 = this.findMatch(n, nArray8, nArray9, nArray10);
            int n11 = this.symEncoder.writeSymbolCost(this.buf[n2] & 0xFF);
            if (nArray9[0] >= nArray3[0] && nArray4[0] > (nArray10[0] * n10 + n11) / (n10 + 1)) {
                n3 = 0;
            } else if (n3 > 3 && (n10 = this.findMatch(n2 + n3, nArray8, nArray9, nArray10)) >= 2 && (n9 = this.findMatch(n2 + n3 - 1, nArray7 = new int[1], nArray6 = new int[1], nArray5 = new int[1])) > n10 && nArray5[0] < nArray10[0] && (n8 = nArray4[0] * n3 + nArray10[0] * n10) / (n3 + n10) > (n7 = (n6 = this.encodeLengthCost(n3 - 1, nArray2[0] + 1, n5 = this.getNumDistRanges(nArray2[0] + 1))) + (n4 = this.encodeDistance2Cost(nArray2[0] + 1, n5)) + nArray5[0] * n9) / (n3 - 1 + n9)) {
                --n3;
                nArray2[0] = nArray2[0] + 1;
            }
            if (n3 == 2) {
                int n12;
                if (n2 >= 2 && this.buf[n2] == this.buf[n2 - 2]) {
                    int n13 = this.symEncoder.writeSymbolCost(this.dup2);
                    if (nArray4[0] * 2 > n13 + this.symEncoder.writeSymbolCost(this.buf[n2 + 1] & 0xFF)) {
                        n3 = 0;
                    }
                } else if (n2 >= 1 && n2 + 1 < this.buf.length && this.buf[n2 + 1] == this.buf[n2 - 1] && nArray4[0] * 2 > n11 + (n12 = this.symEncoder.writeSymbolCost(this.dup2))) {
                    n3 = 0;
                }
            }
        }
        nArray[0] = nArray2[0];
        return n3;
    }

    int findMatch(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = new int[33];
        int n2 = this.buf.length - n;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n2 > 1) {
            int n8 = (this.buf[n] & 0xFF) << 8 | this.buf[n + 1] & 0xFF;
            HashNode hashNode = null;
            int n9 = 0;
            HashNode hashNode2 = this.hashTable[n8];
            while (hashNode2 != null) {
                int n10 = hashNode2.index;
                int n11 = n - n10;
                if (++n9 > 256 || n11 > this.maxCopyDist) {
                    if (this.hashTable[n8] == hashNode2) {
                        this.hashTable[n8] = null;
                        break;
                    }
                    hashNode.next = null;
                    break;
                }
                int n12 = n - n10;
                if (n2 < n12) {
                    n12 = n2;
                }
                if (n12 >= 2) {
                    n10 += 2;
                    int n13 = 2;
                    for (n13 = 2; n13 < n12 && this.buf[n10] == this.buf[n + n13]; ++n13) {
                        ++n10;
                    }
                    if (n13 >= 2 && (n11 = n11 - n13 + 1) <= this.distMax && (n13 != 2 || n11 < 512) && (n13 > n3 || n11 <= n4 || n13 > n3 - 2 && (n11 <= n4 << 3 || n13 >= n3 && n11 <= n4 << 4))) {
                        int n14;
                        int n15;
                        int n16;
                        int n17 = 0;
                        if (n13 > n7) {
                            n16 = n13;
                            if (n16 > 32) {
                                n16 = 32;
                            }
                            for (n10 = n7; n10 < n16; ++n10) {
                                n15 = this.buf[n + n10];
                                nArray4[n10 + 1] = nArray4[n10] + this.symEncoder.writeSymbolCost(n15 & 0xFF);
                            }
                            n7 = n16;
                            if (n13 > 32) {
                                n17 = nArray4[32];
                                n17 += n17 / 32 * (n13 - 32);
                            } else {
                                n17 = nArray4[n13];
                            }
                        } else {
                            n17 = nArray4[n13];
                        }
                        if (n17 > n5 && n17 - (n15 = this.encodeLengthCost(n13, n11, n16 = this.getNumDistRanges(n11))) - (n16 << 16) > n5 && (n14 = n17 - (n15 += this.encodeDistance2Cost(n11, n16))) > n5) {
                            n5 = n14;
                            n3 = n13;
                            n4 = n11;
                            n6 = n15;
                        }
                    }
                }
                hashNode = hashNode2;
                hashNode2 = hashNode2.next;
            }
        }
        nArray3[0] = n3 > 0 ? n6 / n3 : 0;
        nArray[0] = n4;
        nArray2[0] = n5;
        return n3;
    }

    private int getNumDistRanges(int n) {
        int n2 = HuffmanEncoder.bitsUsed(n - 1);
        int n3 = (n2 + 3 - 1) / 3;
        return n3;
    }

    private void encodeLength(int n, int n2, int n3) {
        int n4;
        int n5;
        n = n2 >= 512 ? (n -= 3) : (n -= 2);
        int n6 = HuffmanEncoder.bitsUsed(n);
        for (n5 = 2; n5 < n6; n5 += 2) {
        }
        int n7 = 1 << n5 - 1;
        int n8 = n4 = n6 > 2 ? 2 : 0;
        if ((n & n7) != 0) {
            n4 |= 1;
        }
        n4 <<= 1;
        if ((n & (n7 >>= 1)) != 0) {
            n4 |= 1;
        }
        n7 >>= 1;
        this.symEncoder.writeSymbol(256 + n4 + (n3 - 1) * 8);
        for (n5 = n6 - 2; n5 >= 1; n5 -= 2) {
            int n9 = n4 = n5 > 2 ? 2 : 0;
            if ((n & n7) != 0) {
                n4 |= 1;
            }
            n4 <<= 1;
            if ((n & (n7 >>= 1)) != 0) {
                n4 |= 1;
            }
            n7 >>= 1;
            this.lenEncoder.writeSymbol(n4);
        }
    }

    private int encodeLengthCost(int n, int n2, int n3) {
        int n4;
        int n5;
        n = n2 >= 512 ? (n -= 3) : (n -= 2);
        int n6 = HuffmanEncoder.bitsUsed(n);
        for (n5 = 2; n5 < n6; n5 += 2) {
        }
        int n7 = 1 << n5 - 1;
        int n8 = n4 = n6 > 2 ? 2 : 0;
        if ((n & n7) != 0) {
            n4 |= 1;
        }
        n4 <<= 1;
        if ((n & (n7 >>= 1)) != 0) {
            n4 |= 1;
        }
        n7 >>= 1;
        int n9 = this.symEncoder.writeSymbolCost(256 + n4 + (n3 - 1) * 8);
        for (n5 = n6 - 2; n5 >= 1; n5 -= 2) {
            int n10 = n4 = n5 > 2 ? 2 : 0;
            if ((n & n7) != 0) {
                n4 |= 1;
            }
            n4 <<= 1;
            if ((n & (n7 >>= 1)) != 0) {
                n4 |= 1;
            }
            n7 >>= 1;
            n9 += this.lenEncoder.writeSymbolCost(n4);
        }
        return n9;
    }

    private void encodeDistance2(int n, int n2) {
        --n;
        for (int i = (n2 - 1) * 3; i >= 0; i -= 3) {
            this.distEncoder.writeSymbol(n >> i & 7);
        }
    }

    private int encodeDistance2Cost(int n, int n2) {
        int n3 = 0;
        --n;
        for (int i = (n2 - 1) * 3; i >= 0; i -= 3) {
            n3 += this.distEncoder.writeSymbolCost(n >> i & 7);
        }
        return n3;
    }

    private void updateModel(int n) {
        byte by = this.buf[n];
        if (n > 0) {
            HashNode hashNode = new HashNode();
            byte by2 = this.buf[n - 1];
            int n2 = (by2 & 0xFF) << 8 | by & 0xFF;
            hashNode.index = n - 1;
            hashNode.next = this.hashTable[n2];
            this.hashTable[n2] = hashNode;
        }
    }

    private byte[] toByteArray() {
        return this.bits.toByteArray();
    }

    public static byte[] compress(byte[] byArray) {
        LzcompCompress lzcompCompress = new LzcompCompress();
        lzcompCompress.write(byArray);
        return lzcompCompress.toByteArray();
    }

    public static int getPreloadSize() {
        return 7168;
    }

    private static class HashNode {
        int index;
        HashNode next;

        private HashNode() {
        }
    }
}

