/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.truetype;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.ByteArrayTableBuilder;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;

public final class ControlValueTable
extends Table {
    protected ControlValueTable(Header header, ReadableFontData readableFontData) {
        super(header, readableFontData);
    }

    public int fword(int n) {
        return this.data.readFWord(n);
    }

    public int fwordCount() {
        return this.dataLength() / FontData.DataSize.FWORD.size();
    }

    public static class Builder
    extends ByteArrayTableBuilder<ControlValueTable> {
        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        protected Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
        }

        @Override
        protected ControlValueTable subBuildTable(ReadableFontData readableFontData) {
            return new ControlValueTable(this.header(), readableFontData);
        }
    }
}

