/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.TableBasedTableBuilder;
import java.util.EnumSet;

public final class FontHeaderTable
extends Table {
    public static final long CHECKSUM_ADJUSTMENT_BASE = 2981146554L;
    public static final long MAGIC_NUMBER = 1594834165L;
    private static final int[] CHECKSUM_RANGES = new int[]{0, Offset.access$000(Offset.checkSumAdjustment), Offset.access$000(Offset.magicNumber)};

    private FontHeaderTable(Header header, ReadableFontData readableFontData) {
        super(header, readableFontData);
        readableFontData.setCheckSumRanges(0, Offset.checkSumAdjustment.offset, Offset.magicNumber.offset);
    }

    public int tableVersion() {
        return this.data.readFixed(Offset.tableVersion.offset);
    }

    public int fontRevision() {
        return this.data.readFixed(Offset.fontRevision.offset);
    }

    public long checkSumAdjustment() {
        return this.data.readULong(Offset.checkSumAdjustment.offset);
    }

    public long magicNumber() {
        return this.data.readULong(Offset.magicNumber.offset);
    }

    public int flagsAsInt() {
        return this.data.readUShort(Offset.flags.offset);
    }

    public EnumSet<Flags> flags() {
        return Flags.asSet(this.flagsAsInt());
    }

    public int unitsPerEm() {
        return this.data.readUShort(Offset.unitsPerEm.offset);
    }

    public long created() {
        return this.data.readDateTimeAsLong(Offset.created.offset);
    }

    public long modified() {
        return this.data.readDateTimeAsLong(Offset.modified.offset);
    }

    public int xMin() {
        return this.data.readUShort(Offset.xMin.offset);
    }

    public int yMin() {
        return this.data.readUShort(Offset.yMin.offset);
    }

    public int xMax() {
        return this.data.readUShort(Offset.xMax.offset);
    }

    public int yMax() {
        return this.data.readUShort(Offset.yMax.offset);
    }

    public int macStyleAsInt() {
        return this.data.readUShort(Offset.macStyle.offset);
    }

    public EnumSet<MacStyle> macStyle() {
        return MacStyle.asSet(this.macStyleAsInt());
    }

    public int lowestRecPPEM() {
        return this.data.readUShort(Offset.lowestRecPPEM.offset);
    }

    public int fontDirectionHintAsInt() {
        return this.data.readShort(Offset.fontDirectionHint.offset);
    }

    public FontDirectionHint fontDirectionHint() {
        return FontDirectionHint.valueOf(this.fontDirectionHintAsInt());
    }

    public int indexToLocFormatAsInt() {
        return this.data.readShort(Offset.indexToLocFormat.offset);
    }

    public IndexToLocFormat indexToLocFormat() {
        return IndexToLocFormat.valueOf(this.indexToLocFormatAsInt());
    }

    public int glyphdataFormat() {
        return this.data.readShort(Offset.glyphDataFormat.offset);
    }

    public static class Builder
    extends TableBasedTableBuilder<FontHeaderTable> {
        private boolean fontChecksumSet = false;
        private long fontChecksum = 0L;

        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        protected Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
            writableFontData.setCheckSumRanges(0, Offset.checkSumAdjustment.offset, Offset.magicNumber.offset);
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
            readableFontData.setCheckSumRanges(CHECKSUM_RANGES);
        }

        @Override
        protected boolean subReadyToSerialize() {
            ReadableFontData readableFontData;
            if (this.dataChanged()) {
                readableFontData = this.internalReadData();
                readableFontData.setCheckSumRanges(CHECKSUM_RANGES);
            }
            if (this.fontChecksumSet) {
                readableFontData = this.internalReadData();
                readableFontData.setCheckSumRanges(CHECKSUM_RANGES);
                long l = 2981146554L - (this.fontChecksum + readableFontData.checksum());
                this.setCheckSumAdjustment(l);
            }
            return super.subReadyToSerialize();
        }

        @Override
        protected FontHeaderTable subBuildTable(ReadableFontData readableFontData) {
            return new FontHeaderTable(this.header(), readableFontData);
        }

        public void setFontChecksum(long l) {
            if (this.fontChecksumSet) {
                return;
            }
            this.fontChecksumSet = true;
            this.fontChecksum = l;
        }

        public void clearFontChecksum() {
            this.fontChecksumSet = false;
        }

        public int tableVersion() {
            return ((FontHeaderTable)this.table()).tableVersion();
        }

        public void setTableVersion(int n) {
            this.internalWriteData().writeFixed(Offset.tableVersion.offset, n);
        }

        public int fontRevision() {
            return ((FontHeaderTable)this.table()).fontRevision();
        }

        public void setFontRevision(int n) {
            this.internalWriteData().writeFixed(Offset.fontRevision.offset, n);
        }

        public long checkSumAdjustment() {
            return ((FontHeaderTable)this.table()).checkSumAdjustment();
        }

        public void setCheckSumAdjustment(long l) {
            this.internalWriteData().writeULong(Offset.checkSumAdjustment.offset, l);
        }

        public long magicNumber() {
            return ((FontHeaderTable)this.table()).magicNumber();
        }

        public void setMagicNumber(long l) {
            this.internalWriteData().writeULong(Offset.magicNumber.offset, l);
        }

        public int flagsAsInt() {
            return ((FontHeaderTable)this.table()).flagsAsInt();
        }

        public EnumSet<Flags> flags() {
            return ((FontHeaderTable)this.table()).flags();
        }

        public void setFlagsAsInt(int n) {
            this.internalWriteData().writeUShort(Offset.flags.offset, n);
        }

        public void setFlags(EnumSet<Flags> enumSet) {
            this.setFlagsAsInt(Flags.cleanValue(enumSet));
        }

        public int unitsPerEm() {
            return ((FontHeaderTable)this.table()).unitsPerEm();
        }

        public void setUnitsPerEm(int n) {
            this.internalWriteData().writeUShort(Offset.unitsPerEm.offset, n);
        }

        public long created() {
            return ((FontHeaderTable)this.table()).created();
        }

        public void setCreated(long l) {
            this.internalWriteData().writeDateTime(Offset.created.offset, l);
        }

        public long modified() {
            return ((FontHeaderTable)this.table()).modified();
        }

        public void setModified(long l) {
            this.internalWriteData().writeDateTime(Offset.modified.offset, l);
        }

        public int xMin() {
            return ((FontHeaderTable)this.table()).xMin();
        }

        public void setXMin(int n) {
            this.internalWriteData().writeShort(Offset.xMin.offset, n);
        }

        public int yMin() {
            return ((FontHeaderTable)this.table()).yMin();
        }

        public void setYMin(int n) {
            this.internalWriteData().writeShort(Offset.yMin.offset, n);
        }

        public int xMax() {
            return ((FontHeaderTable)this.table()).xMax();
        }

        public void setXMax(int n) {
            this.internalWriteData().writeShort(Offset.xMax.offset, n);
        }

        public int yMax() {
            return ((FontHeaderTable)this.table()).yMax();
        }

        public void setYMax(int n) {
            this.internalWriteData().writeShort(Offset.yMax.offset, n);
        }

        public int macStyleAsInt() {
            return ((FontHeaderTable)this.table()).macStyleAsInt();
        }

        public void setMacStyleAsInt(int n) {
            this.internalWriteData().writeUShort(Offset.macStyle.offset, n);
        }

        public EnumSet<MacStyle> macStyle() {
            return ((FontHeaderTable)this.table()).macStyle();
        }

        public void macStyle(EnumSet<MacStyle> enumSet) {
            this.setMacStyleAsInt(MacStyle.cleanValue(enumSet));
        }

        public int lowestRecPPEM() {
            return ((FontHeaderTable)this.table()).lowestRecPPEM();
        }

        public void setLowestRecPPEM(int n) {
            this.internalWriteData().writeUShort(Offset.lowestRecPPEM.offset, n);
        }

        public int fontDirectionHintAsInt() {
            return ((FontHeaderTable)this.table()).fontDirectionHintAsInt();
        }

        public void setFontDirectionHintAsInt(int n) {
            this.internalWriteData().writeShort(Offset.fontDirectionHint.offset, n);
        }

        public FontDirectionHint fontDirectionHint() {
            return ((FontHeaderTable)this.table()).fontDirectionHint();
        }

        public void setFontDirectionHint(FontDirectionHint fontDirectionHint) {
            this.setFontDirectionHintAsInt(fontDirectionHint.value());
        }

        public int indexToLocFormatAsInt() {
            return ((FontHeaderTable)this.table()).indexToLocFormatAsInt();
        }

        public void setIndexToLocFormatAsInt(int n) {
            this.internalWriteData().writeShort(Offset.indexToLocFormat.offset, n);
        }

        public IndexToLocFormat indexToLocFormat() {
            return ((FontHeaderTable)this.table()).indexToLocFormat();
        }

        public void setIndexToLocFormat(IndexToLocFormat indexToLocFormat) {
            this.setIndexToLocFormatAsInt(indexToLocFormat.value());
        }

        public int glyphdataFormat() {
            return ((FontHeaderTable)this.table()).glyphdataFormat();
        }

        public void setGlyphdataFormat(int n) {
            this.internalWriteData().writeShort(Offset.glyphDataFormat.offset, n);
        }
    }

    public static enum IndexToLocFormat {
        shortOffset(0),
        longOffset(1);

        private final int value;

        private IndexToLocFormat(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static IndexToLocFormat valueOf(int n) {
            for (IndexToLocFormat indexToLocFormat : IndexToLocFormat.values()) {
                if (!indexToLocFormat.equals(n)) continue;
                return indexToLocFormat;
            }
            return null;
        }
    }

    public static enum FontDirectionHint {
        FullyMixed(0),
        OnlyStrongLTR(1),
        StrongLTRAndNeutral(2),
        OnlyStrongRTL(-1),
        StrongRTLAndNeutral(-2);

        private final int value;

        private FontDirectionHint(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int n) {
            return n == this.value;
        }

        public static FontDirectionHint valueOf(int n) {
            for (FontDirectionHint fontDirectionHint : FontDirectionHint.values()) {
                if (!fontDirectionHint.equals(n)) continue;
                return fontDirectionHint;
            }
            return null;
        }
    }

    public static enum MacStyle {
        Bold,
        Italic,
        Underline,
        Outline,
        Shadow,
        Condensed,
        Extended,
        Reserved7,
        Reserved8,
        Reserved9,
        Reserved10,
        Reserved11,
        Reserved12,
        Reserved13,
        Reserved14,
        Reserved15;

        private static final EnumSet<MacStyle> reserved;

        public int mask() {
            return 1 << this.ordinal();
        }

        public static EnumSet<MacStyle> asSet(int n) {
            EnumSet<MacStyle> enumSet = EnumSet.noneOf(MacStyle.class);
            for (MacStyle macStyle : MacStyle.values()) {
                if ((n & macStyle.mask()) != macStyle.mask()) continue;
                enumSet.add(macStyle);
            }
            return enumSet;
        }

        public static int value(EnumSet<MacStyle> enumSet) {
            int n = 0;
            for (MacStyle macStyle : enumSet) {
                n |= macStyle.mask();
            }
            return n;
        }

        public static int cleanValue(EnumSet<MacStyle> enumSet) {
            EnumSet<MacStyle> enumSet2 = EnumSet.copyOf(enumSet);
            enumSet2.removeAll(reserved);
            return MacStyle.value(enumSet2);
        }

        static {
            reserved = EnumSet.range(Reserved7, Reserved15);
        }
    }

    public static enum Flags {
        BaselineAtY0,
        LeftSidebearingAtX0,
        InstructionsDependOnPointSize,
        ForcePPEMToInteger,
        InstructionsAlterAdvanceWidth,
        Apple_Vertical,
        Apple_Zero,
        Apple_RequiresLayout,
        Apple_GXMetamorphosis,
        Apple_StrongRTL,
        Apple_IndicRearrangement,
        FontDataLossless,
        FontConverted,
        OptimizedForClearType,
        Reserved14,
        Reserved15;


        public int mask() {
            return 1 << this.ordinal();
        }

        public static EnumSet<Flags> asSet(int n) {
            EnumSet<Flags> enumSet = EnumSet.noneOf(Flags.class);
            for (Flags flags : Flags.values()) {
                if ((n & flags.mask()) != flags.mask()) continue;
                enumSet.add(flags);
            }
            return enumSet;
        }

        public static int value(EnumSet<Flags> enumSet) {
            int n = 0;
            for (Flags flags : enumSet) {
                n |= flags.mask();
            }
            return n;
        }

        public static int cleanValue(EnumSet<Flags> enumSet) {
            EnumSet<Flags> enumSet2 = EnumSet.copyOf(enumSet);
            enumSet2.remove((Object)Reserved14);
            enumSet2.remove((Object)Reserved15);
            return Flags.value(enumSet2);
        }
    }

    private static enum Offset {
        tableVersion(0),
        fontRevision(4),
        checkSumAdjustment(8),
        magicNumber(12),
        flags(16),
        unitsPerEm(18),
        created(20),
        modified(28),
        xMin(36),
        yMin(38),
        xMax(40),
        yMax(42),
        macStyle(44),
        lowestRecPPEM(46),
        fontDirectionHint(48),
        indexToLocFormat(50),
        glyphDataFormat(52);

        private final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

