/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CMapFormat10
extends CMap {
    private final int startCharCode;
    private final int numChars;

    protected CMapFormat10(ReadableFontData readableFontData, CMapTable.CMapId cMapId) {
        super(readableFontData, CMap.CMapFormat.Format10.value, cMapId);
        this.startCharCode = this.data.readULongAsInt(CMapTable.Offset.format10StartCharCode.offset);
        this.numChars = this.data.readUShort(CMapTable.Offset.format10NumChars.offset);
    }

    @Override
    public int glyphId(int n) {
        if (n < this.startCharCode || n >= this.startCharCode + this.numChars) {
            return 0;
        }
        return this.readFontData().readUShort(n - this.startCharCode);
    }

    @Override
    public int language() {
        return this.data.readULongAsInt(CMapTable.Offset.format10Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat10> {
        protected Builder(WritableFontData writableFontData, int n, CMapTable.CMapId cMapId) {
            super(writableFontData == null ? null : writableFontData.slice(n, writableFontData.readULongAsInt(n + CMapTable.Offset.format10Length.offset)), CMap.CMapFormat.Format10, cMapId);
        }

        protected Builder(ReadableFontData readableFontData, int n, CMapTable.CMapId cMapId) {
            super(readableFontData == null ? null : readableFontData.slice(n, readableFontData.readULongAsInt(n + CMapTable.Offset.format10Length.offset)), CMap.CMapFormat.Format10, cMapId);
        }

        @Override
        protected CMapFormat10 subBuildTable(ReadableFontData readableFontData) {
            return new CMapFormat10(readableFontData, this.cmapId());
        }
    }

    private class CharacterIterator
    implements Iterator<Integer> {
        private int character;

        private CharacterIterator() {
            this.character = CMapFormat10.this.startCharCode;
        }

        @Override
        public boolean hasNext() {
            return this.character < CMapFormat10.this.startCharCode + CMapFormat10.this.numChars;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            return this.character++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

