/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.ByteArray;
import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.MemoryByteArray;
import com.google.typography.font.sfntly.data.WritableFontData;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;

public class ReadableFontData
extends FontData {
    private volatile boolean checksumSet = false;
    private final Object checksumLock = new Object();
    private volatile long checksum;
    private volatile int[] checksumRange;

    public static ReadableFontData createReadableFontData(byte[] byArray) {
        MemoryByteArray memoryByteArray = new MemoryByteArray(byArray);
        return new ReadableFontData(memoryByteArray);
    }

    protected ReadableFontData(ByteArray<? extends ByteArray<?>> byteArray) {
        super(byteArray);
    }

    protected ReadableFontData(ReadableFontData readableFontData, int n) {
        super(readableFontData, n);
    }

    protected ReadableFontData(ReadableFontData readableFontData, int n, int n2) {
        super(readableFontData, n, n2);
    }

    @Override
    public ReadableFontData slice(int n, int n2) {
        if (n < 0 || n + n2 > this.size()) {
            throw new IndexOutOfBoundsException("Attempt to bind data outside of its limits.");
        }
        ReadableFontData readableFontData = new ReadableFontData(this, n, n2);
        return readableFontData;
    }

    @Override
    public ReadableFontData slice(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("Attempt to bind data outside of its limits.");
        }
        ReadableFontData readableFontData = new ReadableFontData(this, n);
        return readableFontData;
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[l=" + this.length() + ", cs=" + this.checksum() + "]\n");
        stringBuilder.append(this.array.toString(this.boundOffset(0), this.boundLength(0, n)));
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    public long checksum() {
        if (!this.checksumSet) {
            this.computeChecksum();
        }
        return this.checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeChecksum() {
        Object object = this.checksumLock;
        synchronized (object) {
            if (this.checksumSet) {
                return;
            }
            long l = 0L;
            if (this.checksumRange == null) {
                l = this.computeCheckSum(0, this.length());
            } else {
                for (int i = 0; i < this.checksumRange.length; i += 2) {
                    int n = this.checksumRange[i];
                    int n2 = i == this.checksumRange.length - 1 ? this.length() : this.checksumRange[i + 1];
                    l += this.computeCheckSum(n, n2);
                }
            }
            this.checksum = l & 0xFFFFFFFFL;
            this.checksumSet = true;
        }
    }

    private long computeCheckSum(int n, int n2) {
        int n3;
        long l = 0L;
        for (n3 = n; n3 <= n2 - 4; n3 += 4) {
            l += this.readULong(n3);
        }
        n3 = n2 & 0xFFFFFFFC;
        if (n3 < n2) {
            int n4 = this.readUByte(n3);
            int n5 = n3 + 1 < n2 ? this.readUByte(n3 + 1) : 0;
            int n6 = n3 + 2 < n2 ? this.readUByte(n3 + 2) : 0;
            int n7 = 0;
            l += (long)(n4 << 24 | n5 << 16 | n6 << 8 | n7);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckSumRanges(int ... nArray) {
        Object object = this.checksumLock;
        synchronized (object) {
            this.checksumRange = (int[])(nArray != null && nArray.length > 0 ? Arrays.copyOf(nArray, nArray.length) : null);
            this.checksumSet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] checkSumRange() {
        Object object = this.checksumLock;
        synchronized (object) {
            if (this.checksumRange != null && this.checksumRange.length > 0) {
                return Arrays.copyOf(this.checksumRange, this.checksumRange.length);
            }
            return new int[0];
        }
    }

    public int readUByte(int n) {
        int n2 = this.array.get(this.boundOffset(n));
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index attempted to be read from is out of bounds: " + Integer.toHexString(n));
        }
        return n2;
    }

    public int readByte(int n) {
        int n2 = this.array.get(this.boundOffset(n));
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index attempted to be read from is out of bounds: " + Integer.toHexString(n));
        }
        return n2 << 24 >> 24;
    }

    public int readBytes(int n, byte[] byArray, int n2, int n3) {
        return this.array.get(this.boundOffset(n), byArray, n2, this.boundLength(n, n3));
    }

    public int readChar(int n) {
        return this.readUByte(n);
    }

    public int readUShort(int n) {
        return 0xFFFF & (this.readUByte(n) << 8 | this.readUByte(n + 1));
    }

    public int readShort(int n) {
        return (this.readByte(n) << 8 | this.readUByte(n + 1)) << 16 >> 16;
    }

    public int readUInt24(int n) {
        return 0xFFFFFF & (this.readUByte(n) << 16 | this.readUByte(n + 1) << 8 | this.readUByte(n + 2));
    }

    public long readULong(int n) {
        return 0xFFFFFFFFL & (long)(this.readUByte(n) << 24 | this.readUByte(n + 1) << 16 | this.readUByte(n + 2) << 8 | this.readUByte(n + 3));
    }

    public int readULongAsInt(int n) {
        long l = this.readULong(n);
        if ((l & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            throw new ArithmeticException("Long value too large to fit into an integer.");
        }
        return (int)l;
    }

    public long readULongLE(int n) {
        return 0xFFFFFFFFL & (long)(this.readUByte(n) | this.readUByte(n + 1) << 8 | this.readUByte(n + 2) << 16 | this.readUByte(n + 3) << 24);
    }

    public int readLong(int n) {
        return this.readByte(n) << 24 | this.readUByte(n + 1) << 16 | this.readUByte(n + 2) << 8 | this.readUByte(n + 3);
    }

    public int readFixed(int n) {
        return this.readLong(n);
    }

    public BigDecimal readF2Dot14(int n) {
        throw new UnsupportedOperationException();
    }

    public long readDateTimeAsLong(int n) {
        return this.readULong(n) << 32 | this.readULong(n + 4);
    }

    public Date readLongDateTime(int n) {
        throw new UnsupportedOperationException();
    }

    public int readFUnit(int n) {
        throw new UnsupportedOperationException();
    }

    public int readFWord(int n) {
        return this.readShort(n);
    }

    public int readUFWord(int n) {
        return this.readUShort(n);
    }

    public int copyTo(OutputStream outputStream) throws IOException {
        return this.array.copyTo(outputStream, this.boundOffset(0), this.length());
    }

    public int copyTo(WritableFontData writableFontData) {
        return this.array.copyTo(writableFontData.boundOffset(0), writableFontData.array, this.boundOffset(0), this.length());
    }

    public int searchUShort(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = n5;
        while (n9 != n8) {
            n7 = (n9 + n8) / 2;
            int n10 = this.readUShort(n + n7 * n2);
            if (n6 < n10) {
                n9 = n7;
                continue;
            }
            int n11 = this.readUShort(n3 + n7 * n4);
            if (n6 <= n11) {
                return n7;
            }
            n8 = n7 + 1;
        }
        return -1;
    }

    public int searchULong(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = n5;
        while (n9 != n8) {
            n7 = (n9 + n8) / 2;
            int n10 = this.readULongAsInt(n + n7 * n2);
            if (n6 < n10) {
                n9 = n7;
                continue;
            }
            int n11 = this.readULongAsInt(n3 + n7 * n4);
            if (n6 <= n11) {
                return n7;
            }
            n8 = n7 + 1;
        }
        return -1;
    }

    public int searchUShort(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = n3;
        while (n7 != n6) {
            n5 = (n7 + n6) / 2;
            int n8 = this.readUShort(n + n5 * n2);
            if (n4 < n8) {
                n7 = n5;
                continue;
            }
            if (n4 > n8) {
                n6 = n5 + 1;
                continue;
            }
            return n5;
        }
        return -1;
    }
}

